/**
 * Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.osmanagement;

import com.oracle.bmc.osmanagement.requests.*;
import com.oracle.bmc.osmanagement.responses.*;

/**
 * API for the OS Management service. Use these API operations for working
 * with Managed instances and Managed instance groups.
 *
 */
@javax.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20190801")
public interface Event extends AutoCloseable {

    /**
     * Sets the endpoint to call (ex, https://www.example.com).
     * @param endpoint The endpoint of the service.
     */
    void setEndpoint(String endpoint);

    /**
     * Gets the set endpoint for REST call (ex, https://www.example.com)
     */
    String getEndpoint();

    /**
     * Sets the region to call (ex, Region.US_PHOENIX_1).
     * <p>
     * Note, this will call {@link #setEndpoint(String) setEndpoint} after resolving the endpoint.  If the service is not available in this Region, however, an IllegalArgumentException will be raised.
     * @param region The region of the service.
     */
    void setRegion(com.oracle.bmc.Region region);

    /**
     * Sets the region to call (ex, 'us-phoenix-1').
     * <p>
     * Note, this will first try to map the region ID to a known Region and call
     * {@link #setRegion(Region) setRegion}.
     * <p>
     * If no known Region could be determined, it will create an endpoint based on the
     * default endpoint format ({@link com.oracle.bmc.Region#formatDefaultRegionEndpoint(Service, String)}
     * and then call {@link #setEndpoint(String) setEndpoint}.
     * @param regionId The public region ID.
     */
    void setRegion(String regionId);

    /**
     * Delete an event content ZIP archive from the service
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/2.7.1/osmanagement/DeleteEventContentExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use DeleteEventContent API.
     */
    DeleteEventContentResponse deleteEventContent(DeleteEventContentRequest request);

    /**
     * Gets an Event by identifier
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/2.7.1/osmanagement/GetEventExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetEvent API.
     */
    GetEventResponse getEvent(GetEventRequest request);

    /**
     * Get additional data about a event as a ZIP archive. The archive content depends on the event eventType.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/2.7.1/osmanagement/GetEventContentExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetEventContent API.
     */
    GetEventContentResponse getEventContent(GetEventContentRequest request);

    /**
     * Get summary information about events on this instance.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/2.7.1/osmanagement/GetEventReportExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetEventReport API.
     */
    GetEventReportResponse getEventReport(GetEventReportRequest request);

    /**
     * Returns a list of Events.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/2.7.1/osmanagement/ListEventsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListEvents API.
     */
    ListEventsResponse listEvents(ListEventsRequest request);

    /**
     * Returns a list of related events. For now pagination is not implemented.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/2.7.1/osmanagement/ListRelatedEventsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListRelatedEvents API.
     */
    ListRelatedEventsResponse listRelatedEvents(ListRelatedEventsRequest request);

    /**
     * Updates an existing event associated to a managed instance
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/2.7.1/osmanagement/UpdateEventExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateEvent API.
     */
    UpdateEventResponse updateEvent(UpdateEventRequest request);

    /**
     * Upload the event content as a ZIP archive from the managed instance to the service
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/2.7.1/osmanagement/UploadEventContentExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UploadEventContent API.
     */
    UploadEventContentResponse uploadEventContent(UploadEventContentRequest request);

    /**
     * Gets the pre-configured paginators available for list operations in this service which may return multiple
     * pages of data. These paginators provide an {@link java.lang.Iterable} interface so that service responses, or
     * resources/records, can be iterated through without having to manually deal with pagination and page tokens.
     *
     * @return The service paginators.
     */
    EventPaginators getPaginators();
}
