/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagement.model.ModuleStreamProfileOnManagedInstanceSummary;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModuleStreamOnManagedInstanceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="moduleName")
    private final String moduleName;
    @JsonProperty(value="streamName")
    private final String streamName;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="profiles")
    private final List<ModuleStreamProfileOnManagedInstanceSummary> profiles;
    @JsonProperty(value="softwareSourceId")
    private final String softwareSourceId;
    @JsonProperty(value="timeModified")
    private final Date timeModified;

    @Deprecated
    @ConstructorProperties(value={"moduleName", "streamName", "status", "profiles", "softwareSourceId", "timeModified"})
    public ModuleStreamOnManagedInstanceSummary(String moduleName, String streamName, Status status, List<ModuleStreamProfileOnManagedInstanceSummary> profiles, String softwareSourceId, Date timeModified) {
        this.moduleName = moduleName;
        this.streamName = streamName;
        this.status = status;
        this.profiles = profiles;
        this.softwareSourceId = softwareSourceId;
        this.timeModified = timeModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<ModuleStreamProfileOnManagedInstanceSummary> getProfiles() {
        return this.profiles;
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public Date getTimeModified() {
        return this.timeModified;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModuleStreamOnManagedInstanceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("moduleName=").append(String.valueOf(this.moduleName));
        sb.append(", streamName=").append(String.valueOf(this.streamName));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", profiles=").append(String.valueOf(this.profiles));
        sb.append(", softwareSourceId=").append(String.valueOf(this.softwareSourceId));
        sb.append(", timeModified=").append(String.valueOf(this.timeModified));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleStreamOnManagedInstanceSummary)) {
            return false;
        }
        ModuleStreamOnManagedInstanceSummary other = (ModuleStreamOnManagedInstanceSummary)((Object)o);
        return Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.streamName, other.streamName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.profiles, other.profiles) && Objects.equals(this.softwareSourceId, other.softwareSourceId) && Objects.equals(this.timeModified, other.timeModified) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.moduleName == null ? 43 : this.moduleName.hashCode());
        result = result * 59 + (this.streamName == null ? 43 : this.streamName.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.profiles == null ? 43 : this.profiles.hashCode());
        result = result * 59 + (this.softwareSourceId == null ? 43 : this.softwareSourceId.hashCode());
        result = result * 59 + (this.timeModified == null ? 43 : this.timeModified.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        Active("ACTIVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="moduleName")
        private String moduleName;
        @JsonProperty(value="streamName")
        private String streamName;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="profiles")
        private List<ModuleStreamProfileOnManagedInstanceSummary> profiles;
        @JsonProperty(value="softwareSourceId")
        private String softwareSourceId;
        @JsonProperty(value="timeModified")
        private Date timeModified;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            this.__explicitlySet__.add("moduleName");
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            this.__explicitlySet__.add("streamName");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder profiles(List<ModuleStreamProfileOnManagedInstanceSummary> profiles) {
            this.profiles = profiles;
            this.__explicitlySet__.add("profiles");
            return this;
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            this.__explicitlySet__.add("softwareSourceId");
            return this;
        }

        public Builder timeModified(Date timeModified) {
            this.timeModified = timeModified;
            this.__explicitlySet__.add("timeModified");
            return this;
        }

        public ModuleStreamOnManagedInstanceSummary build() {
            ModuleStreamOnManagedInstanceSummary model = new ModuleStreamOnManagedInstanceSummary(this.moduleName, this.streamName, this.status, this.profiles, this.softwareSourceId, this.timeModified);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModuleStreamOnManagedInstanceSummary model) {
            if (model.wasPropertyExplicitlySet("moduleName")) {
                this.moduleName(model.getModuleName());
            }
            if (model.wasPropertyExplicitlySet("streamName")) {
                this.streamName(model.getStreamName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("profiles")) {
                this.profiles(model.getProfiles());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceId")) {
                this.softwareSourceId(model.getSoftwareSourceId());
            }
            if (model.wasPropertyExplicitlySet("timeModified")) {
                this.timeModified(model.getTimeModified());
            }
            return this;
        }
    }
}

