/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagement.model.UpdateModuleStreamProfileDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateModuleStreamDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="streamName")
    private final String streamName;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="timeModified")
    private final Date timeModified;
    @JsonProperty(value="softwareSourceName")
    private final String softwareSourceName;
    @JsonProperty(value="softwareSourceUrl")
    private final String softwareSourceUrl;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="profiles")
    private final List<UpdateModuleStreamProfileDetails> profiles;

    @Deprecated
    @ConstructorProperties(value={"streamName", "status", "timeModified", "softwareSourceName", "softwareSourceUrl", "isDefault", "profiles"})
    public UpdateModuleStreamDetails(String streamName, Status status, Date timeModified, String softwareSourceName, String softwareSourceUrl, Boolean isDefault, List<UpdateModuleStreamProfileDetails> profiles) {
        this.streamName = streamName;
        this.status = status;
        this.timeModified = timeModified;
        this.softwareSourceName = softwareSourceName;
        this.softwareSourceUrl = softwareSourceUrl;
        this.isDefault = isDefault;
        this.profiles = profiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getTimeModified() {
        return this.timeModified;
    }

    public String getSoftwareSourceName() {
        return this.softwareSourceName;
    }

    public String getSoftwareSourceUrl() {
        return this.softwareSourceUrl;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public List<UpdateModuleStreamProfileDetails> getProfiles() {
        return this.profiles;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateModuleStreamDetails(");
        sb.append("super=").append(super.toString());
        sb.append("streamName=").append(String.valueOf(this.streamName));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeModified=").append(String.valueOf(this.timeModified));
        sb.append(", softwareSourceName=").append(String.valueOf(this.softwareSourceName));
        sb.append(", softwareSourceUrl=").append(String.valueOf(this.softwareSourceUrl));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", profiles=").append(String.valueOf(this.profiles));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateModuleStreamDetails)) {
            return false;
        }
        UpdateModuleStreamDetails other = (UpdateModuleStreamDetails)((Object)o);
        return Objects.equals(this.streamName, other.streamName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeModified, other.timeModified) && Objects.equals(this.softwareSourceName, other.softwareSourceName) && Objects.equals(this.softwareSourceUrl, other.softwareSourceUrl) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals(this.profiles, other.profiles) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.streamName == null ? 43 : this.streamName.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeModified == null ? 43 : this.timeModified.hashCode());
        result = result * 59 + (this.softwareSourceName == null ? 43 : this.softwareSourceName.hashCode());
        result = result * 59 + (this.softwareSourceUrl == null ? 43 : this.softwareSourceUrl.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.profiles == null ? 43 : this.profiles.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        Active("ACTIVE");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="streamName")
        private String streamName;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="timeModified")
        private Date timeModified;
        @JsonProperty(value="softwareSourceName")
        private String softwareSourceName;
        @JsonProperty(value="softwareSourceUrl")
        private String softwareSourceUrl;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="profiles")
        private List<UpdateModuleStreamProfileDetails> profiles;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            this.__explicitlySet__.add("streamName");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeModified(Date timeModified) {
            this.timeModified = timeModified;
            this.__explicitlySet__.add("timeModified");
            return this;
        }

        public Builder softwareSourceName(String softwareSourceName) {
            this.softwareSourceName = softwareSourceName;
            this.__explicitlySet__.add("softwareSourceName");
            return this;
        }

        public Builder softwareSourceUrl(String softwareSourceUrl) {
            this.softwareSourceUrl = softwareSourceUrl;
            this.__explicitlySet__.add("softwareSourceUrl");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder profiles(List<UpdateModuleStreamProfileDetails> profiles) {
            this.profiles = profiles;
            this.__explicitlySet__.add("profiles");
            return this;
        }

        public UpdateModuleStreamDetails build() {
            UpdateModuleStreamDetails model = new UpdateModuleStreamDetails(this.streamName, this.status, this.timeModified, this.softwareSourceName, this.softwareSourceUrl, this.isDefault, this.profiles);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateModuleStreamDetails model) {
            if (model.wasPropertyExplicitlySet("streamName")) {
                this.streamName(model.getStreamName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeModified")) {
                this.timeModified(model.getTimeModified());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceName")) {
                this.softwareSourceName(model.getSoftwareSourceName());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceUrl")) {
                this.softwareSourceUrl(model.getSoftwareSourceUrl());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("profiles")) {
                this.profiles(model.getProfiles());
            }
            return this;
        }
    }
}

