/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModuleStream
extends ExplicitlySetBmcModel {
    @JsonProperty(value="moduleName")
    private final String moduleName;
    @JsonProperty(value="streamName")
    private final String streamName;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="softwareSourceId")
    private final String softwareSourceId;
    @JsonProperty(value="architecture")
    private final String architecture;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="profiles")
    private final List<String> profiles;
    @JsonProperty(value="packages")
    private final List<String> packages;

    @Deprecated
    @ConstructorProperties(value={"moduleName", "streamName", "isDefault", "softwareSourceId", "architecture", "description", "profiles", "packages"})
    public ModuleStream(String moduleName, String streamName, Boolean isDefault, String softwareSourceId, String architecture, String description, List<String> profiles, List<String> packages) {
        this.moduleName = moduleName;
        this.streamName = streamName;
        this.isDefault = isDefault;
        this.softwareSourceId = softwareSourceId;
        this.architecture = architecture;
        this.description = description;
        this.profiles = profiles;
        this.packages = packages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModuleStream(");
        sb.append("super=").append(super.toString());
        sb.append("moduleName=").append(String.valueOf(this.moduleName));
        sb.append(", streamName=").append(String.valueOf(this.streamName));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", softwareSourceId=").append(String.valueOf(this.softwareSourceId));
        sb.append(", architecture=").append(String.valueOf(this.architecture));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", profiles=").append(String.valueOf(this.profiles));
        sb.append(", packages=").append(String.valueOf(this.packages));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleStream)) {
            return false;
        }
        ModuleStream other = (ModuleStream)((Object)o);
        return Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.streamName, other.streamName) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals(this.softwareSourceId, other.softwareSourceId) && Objects.equals(this.architecture, other.architecture) && Objects.equals(this.description, other.description) && Objects.equals(this.profiles, other.profiles) && Objects.equals(this.packages, other.packages) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.moduleName == null ? 43 : this.moduleName.hashCode());
        result = result * 59 + (this.streamName == null ? 43 : this.streamName.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.softwareSourceId == null ? 43 : this.softwareSourceId.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.profiles == null ? 43 : this.profiles.hashCode());
        result = result * 59 + (this.packages == null ? 43 : this.packages.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="moduleName")
        private String moduleName;
        @JsonProperty(value="streamName")
        private String streamName;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="softwareSourceId")
        private String softwareSourceId;
        @JsonProperty(value="architecture")
        private String architecture;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="profiles")
        private List<String> profiles;
        @JsonProperty(value="packages")
        private List<String> packages;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            this.__explicitlySet__.add("moduleName");
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            this.__explicitlySet__.add("streamName");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            this.__explicitlySet__.add("softwareSourceId");
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder profiles(List<String> profiles) {
            this.profiles = profiles;
            this.__explicitlySet__.add("profiles");
            return this;
        }

        public Builder packages(List<String> packages) {
            this.packages = packages;
            this.__explicitlySet__.add("packages");
            return this;
        }

        public ModuleStream build() {
            ModuleStream model = new ModuleStream(this.moduleName, this.streamName, this.isDefault, this.softwareSourceId, this.architecture, this.description, this.profiles, this.packages);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModuleStream model) {
            if (model.wasPropertyExplicitlySet("moduleName")) {
                this.moduleName(model.getModuleName());
            }
            if (model.wasPropertyExplicitlySet("streamName")) {
                this.streamName(model.getStreamName());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceId")) {
                this.softwareSourceId(model.getSoftwareSourceId());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("profiles")) {
                this.profiles(model.getProfiles());
            }
            if (model.wasPropertyExplicitlySet("packages")) {
                this.packages(model.getPackages());
            }
            return this;
        }
    }
}

