/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.osmanagement.model.UpdateEventDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class UpdateEventRequest
extends BmcRequest<UpdateEventDetails> {
    private String managedInstanceId;
    private String eventId;
    private String compartmentId;
    private UpdateEventDetails updateEventDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public UpdateEventDetails getUpdateEventDetails() {
        return this.updateEventDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateEventDetails getBody$() {
        return this.updateEventDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).eventId(this.eventId).compartmentId(this.compartmentId).updateEventDetails(this.updateEventDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",eventId=").append(String.valueOf(this.eventId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",updateEventDetails=").append(String.valueOf((Object)this.updateEventDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateEventRequest)) {
            return false;
        }
        UpdateEventRequest other = (UpdateEventRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.eventId, other.eventId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.updateEventDetails, (Object)other.updateEventDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.eventId == null ? 43 : this.eventId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.updateEventDetails == null ? 43 : this.updateEventDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateEventRequest, UpdateEventDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedInstanceId = null;
        private String eventId = null;
        private String compartmentId = null;
        private UpdateEventDetails updateEventDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder updateEventDetails(UpdateEventDetails updateEventDetails) {
            this.updateEventDetails = updateEventDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateEventRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.eventId(o.getEventId());
            this.compartmentId(o.getCompartmentId());
            this.updateEventDetails(o.getUpdateEventDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateEventRequest build() {
            UpdateEventRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateEventDetails body) {
            this.updateEventDetails(body);
            return this;
        }

        public UpdateEventRequest buildWithoutInvocationCallback() {
            UpdateEventRequest request = new UpdateEventRequest();
            request.managedInstanceId = this.managedInstanceId;
            request.eventId = this.eventId;
            request.compartmentId = this.compartmentId;
            request.updateEventDetails = this.updateEventDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

