/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.osmanagement.OsManagementAsync;
import com.oracle.bmc.osmanagement.internal.http.AddPackagesToSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachChildSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachManagedInstanceToManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachParentSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeManagedInstanceGroupCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeScheduledJobCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeSoftwareSourceCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachChildSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachManagedInstanceFromManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachParentSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.DisableModuleStreamOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.EnableModuleStreamOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetErratumConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.GetModuleStreamConverter;
import com.oracle.bmc.osmanagement.internal.http.GetModuleStreamProfileConverter;
import com.oracle.bmc.osmanagement.internal.http.GetScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwarePackageConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWindowsUpdateConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllPackageUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllUpdatesOnManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllWindowsUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallModuleStreamProfileOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallWindowsUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailablePackagesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableSoftwareSourcesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableWindowsUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListErrataConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstanceErrataConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstanceGroupsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstancesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamProfilesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamProfilesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamsOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListPackagesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListUpcomingScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.osmanagement.internal.http.ManageModuleStreamsOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemoveModuleStreamProfileFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackageFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackagesFromSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.RunScheduledJobNowConverter;
import com.oracle.bmc.osmanagement.internal.http.SearchSoftwarePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.SkipNextScheduledJobExecutionConverter;
import com.oracle.bmc.osmanagement.internal.http.SwitchModuleStreamOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.AttachChildSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.AttachManagedInstanceToManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.AttachParentSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ChangeManagedInstanceGroupCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeScheduledJobCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeSoftwareSourceCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.CreateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DeleteManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DetachChildSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DetachManagedInstanceFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DetachParentSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DisableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.EnableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetErratumRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamProfileRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamRequest;
import com.oracle.bmc.osmanagement.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllPackageUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllUpdatesOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllWindowsUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallModuleStreamProfileOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallWindowsUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailablePackagesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableSoftwareSourcesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableWindowsUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceGroupsRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstancesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsRequest;
import com.oracle.bmc.osmanagement.requests.ListPackagesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcePackagesRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagement.requests.ListUpcomingScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.osmanagement.requests.ManageModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemoveModuleStreamProfileFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackageFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackagesFromSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagement.requests.SearchSoftwarePackagesRequest;
import com.oracle.bmc.osmanagement.requests.SkipNextScheduledJobExecutionRequest;
import com.oracle.bmc.osmanagement.requests.SwitchModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.AttachChildSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.AttachManagedInstanceToManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.AttachParentSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ChangeManagedInstanceGroupCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeScheduledJobCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeSoftwareSourceCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.CreateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DeleteManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DetachChildSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DetachManagedInstanceFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DetachParentSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DisableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.EnableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetErratumResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamProfileResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamResponse;
import com.oracle.bmc.osmanagement.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.osmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllPackageUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllUpdatesOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllWindowsUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallModuleStreamProfileOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallWindowsUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailablePackagesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableSoftwareSourcesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableWindowsUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceGroupsResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstancesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsResponse;
import com.oracle.bmc.osmanagement.responses.ListPackagesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcePackagesResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagement.responses.ListUpcomingScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.osmanagement.responses.ManageModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemoveModuleStreamProfileFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackageFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackagesFromSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagement.responses.SearchSoftwarePackagesResponse;
import com.oracle.bmc.osmanagement.responses.SkipNextScheduledJobExecutionResponse;
import com.oracle.bmc.osmanagement.responses.SwitchModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsManagementAsyncClient
implements OsManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OsManagementAsyncClient.class);
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public OsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration, isNonBufferingApacheClient);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    RestClient getClient() {
        return this.client;
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        java.util.Optional endpoint = GuavaUtils.adaptFromGuava((Optional)region.getEndpoint(SERVICE));
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AddPackagesToSoftwareSourceResponse> addPackagesToSoftwareSource(AddPackagesToSoftwareSourceRequest request, AsyncHandler<AddPackagesToSoftwareSourceRequest, AddPackagesToSoftwareSourceResponse> handler) {
        LOG.trace("Called async addPackagesToSoftwareSource");
        AddPackagesToSoftwareSourceRequest interceptedRequest = AddPackagesToSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddPackagesToSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "AddPackagesToSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/AddPackagesToSoftwareSource");
        Function<Response, AddPackagesToSoftwareSourceResponse> transformer = AddPackagesToSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<AddPackagesToSoftwareSourceRequest, AddPackagesToSoftwareSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getAddPackagesToSoftwareSourceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddPackagesToSoftwareSourceRequest, AddPackagesToSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AttachChildSoftwareSourceToManagedInstanceResponse> attachChildSoftwareSourceToManagedInstance(AttachChildSoftwareSourceToManagedInstanceRequest request, AsyncHandler<AttachChildSoftwareSourceToManagedInstanceRequest, AttachChildSoftwareSourceToManagedInstanceResponse> handler) {
        LOG.trace("Called async attachChildSoftwareSourceToManagedInstance");
        AttachChildSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachChildSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachChildSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "AttachChildSoftwareSourceToManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/AttachChildSoftwareSourceToManagedInstance");
        Function<Response, AttachChildSoftwareSourceToManagedInstanceResponse> transformer = AttachChildSoftwareSourceToManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<AttachChildSoftwareSourceToManagedInstanceRequest, AttachChildSoftwareSourceToManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getAttachChildSoftwareSourceToManagedInstanceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AttachChildSoftwareSourceToManagedInstanceRequest, AttachChildSoftwareSourceToManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AttachManagedInstanceToManagedInstanceGroupResponse> attachManagedInstanceToManagedInstanceGroup(AttachManagedInstanceToManagedInstanceGroupRequest request, AsyncHandler<AttachManagedInstanceToManagedInstanceGroupRequest, AttachManagedInstanceToManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async attachManagedInstanceToManagedInstanceGroup");
        AttachManagedInstanceToManagedInstanceGroupRequest interceptedRequest = AttachManagedInstanceToManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachManagedInstanceToManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "AttachManagedInstanceToManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/AttachManagedInstanceToManagedInstanceGroup");
        Function<Response, AttachManagedInstanceToManagedInstanceGroupResponse> transformer = AttachManagedInstanceToManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<AttachManagedInstanceToManagedInstanceGroupRequest, AttachManagedInstanceToManagedInstanceGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AttachManagedInstanceToManagedInstanceGroupRequest, AttachManagedInstanceToManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AttachParentSoftwareSourceToManagedInstanceResponse> attachParentSoftwareSourceToManagedInstance(AttachParentSoftwareSourceToManagedInstanceRequest request, AsyncHandler<AttachParentSoftwareSourceToManagedInstanceRequest, AttachParentSoftwareSourceToManagedInstanceResponse> handler) {
        LOG.trace("Called async attachParentSoftwareSourceToManagedInstance");
        AttachParentSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachParentSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachParentSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "AttachParentSoftwareSourceToManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/AttachParentSoftwareSourceToManagedInstance");
        Function<Response, AttachParentSoftwareSourceToManagedInstanceResponse> transformer = AttachParentSoftwareSourceToManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<AttachParentSoftwareSourceToManagedInstanceRequest, AttachParentSoftwareSourceToManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getAttachParentSoftwareSourceToManagedInstanceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AttachParentSoftwareSourceToManagedInstanceRequest, AttachParentSoftwareSourceToManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeManagedInstanceGroupCompartmentResponse> changeManagedInstanceGroupCompartment(ChangeManagedInstanceGroupCompartmentRequest request, AsyncHandler<ChangeManagedInstanceGroupCompartmentRequest, ChangeManagedInstanceGroupCompartmentResponse> handler) {
        LOG.trace("Called async changeManagedInstanceGroupCompartment");
        ChangeManagedInstanceGroupCompartmentRequest interceptedRequest = ChangeManagedInstanceGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagedInstanceGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ChangeManagedInstanceGroupCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/ChangeManagedInstanceGroupCompartment");
        Function<Response, ChangeManagedInstanceGroupCompartmentResponse> transformer = ChangeManagedInstanceGroupCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ChangeManagedInstanceGroupCompartmentRequest, ChangeManagedInstanceGroupCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeManagedInstanceGroupCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeManagedInstanceGroupCompartmentRequest, ChangeManagedInstanceGroupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeScheduledJobCompartmentResponse> changeScheduledJobCompartment(ChangeScheduledJobCompartmentRequest request, AsyncHandler<ChangeScheduledJobCompartmentRequest, ChangeScheduledJobCompartmentResponse> handler) {
        LOG.trace("Called async changeScheduledJobCompartment");
        ChangeScheduledJobCompartmentRequest interceptedRequest = ChangeScheduledJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeScheduledJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ChangeScheduledJobCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ChangeScheduledJobCompartment");
        Function<Response, ChangeScheduledJobCompartmentResponse> transformer = ChangeScheduledJobCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ChangeScheduledJobCompartmentRequest, ChangeScheduledJobCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeScheduledJobCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeScheduledJobCompartmentRequest, ChangeScheduledJobCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeSoftwareSourceCompartmentResponse> changeSoftwareSourceCompartment(ChangeSoftwareSourceCompartmentRequest request, AsyncHandler<ChangeSoftwareSourceCompartmentRequest, ChangeSoftwareSourceCompartmentResponse> handler) {
        LOG.trace("Called async changeSoftwareSourceCompartment");
        ChangeSoftwareSourceCompartmentRequest interceptedRequest = ChangeSoftwareSourceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSoftwareSourceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ChangeSoftwareSourceCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/ChangeSoftwareSourceCompartment");
        Function<Response, ChangeSoftwareSourceCompartmentResponse> transformer = ChangeSoftwareSourceCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ChangeSoftwareSourceCompartmentRequest, ChangeSoftwareSourceCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeSoftwareSourceCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeSoftwareSourceCompartmentRequest, ChangeSoftwareSourceCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateManagedInstanceGroupResponse> createManagedInstanceGroup(CreateManagedInstanceGroupRequest request, AsyncHandler<CreateManagedInstanceGroupRequest, CreateManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async createManagedInstanceGroup");
        CreateManagedInstanceGroupRequest interceptedRequest = CreateManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "CreateManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/CreateManagedInstanceGroup");
        Function<Response, CreateManagedInstanceGroupResponse> transformer = CreateManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<CreateManagedInstanceGroupRequest, CreateManagedInstanceGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateManagedInstanceGroupDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateManagedInstanceGroupRequest, CreateManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateScheduledJobResponse> createScheduledJob(CreateScheduledJobRequest request, AsyncHandler<CreateScheduledJobRequest, CreateScheduledJobResponse> handler) {
        LOG.trace("Called async createScheduledJob");
        CreateScheduledJobRequest interceptedRequest = CreateScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "CreateScheduledJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/CreateScheduledJob");
        Function<Response, CreateScheduledJobResponse> transformer = CreateScheduledJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<CreateScheduledJobRequest, CreateScheduledJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateScheduledJobDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateScheduledJobRequest, CreateScheduledJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSoftwareSourceResponse> createSoftwareSource(CreateSoftwareSourceRequest request, AsyncHandler<CreateSoftwareSourceRequest, CreateSoftwareSourceResponse> handler) {
        LOG.trace("Called async createSoftwareSource");
        CreateSoftwareSourceRequest interceptedRequest = CreateSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "CreateSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/CreateSoftwareSource");
        Function<Response, CreateSoftwareSourceResponse> transformer = CreateSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<CreateSoftwareSourceRequest, CreateSoftwareSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateSoftwareSourceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSoftwareSourceRequest, CreateSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteManagedInstanceGroupResponse> deleteManagedInstanceGroup(DeleteManagedInstanceGroupRequest request, AsyncHandler<DeleteManagedInstanceGroupRequest, DeleteManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async deleteManagedInstanceGroup");
        DeleteManagedInstanceGroupRequest interceptedRequest = DeleteManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DeleteManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/DeleteManagedInstanceGroup");
        Function<Response, DeleteManagedInstanceGroupResponse> transformer = DeleteManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<DeleteManagedInstanceGroupRequest, DeleteManagedInstanceGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteManagedInstanceGroupRequest, DeleteManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteScheduledJobResponse> deleteScheduledJob(DeleteScheduledJobRequest request, AsyncHandler<DeleteScheduledJobRequest, DeleteScheduledJobResponse> handler) {
        LOG.trace("Called async deleteScheduledJob");
        DeleteScheduledJobRequest interceptedRequest = DeleteScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DeleteScheduledJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/DeleteScheduledJob");
        Function<Response, DeleteScheduledJobResponse> transformer = DeleteScheduledJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<DeleteScheduledJobRequest, DeleteScheduledJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteScheduledJobRequest, DeleteScheduledJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSoftwareSourceResponse> deleteSoftwareSource(DeleteSoftwareSourceRequest request, AsyncHandler<DeleteSoftwareSourceRequest, DeleteSoftwareSourceResponse> handler) {
        LOG.trace("Called async deleteSoftwareSource");
        DeleteSoftwareSourceRequest interceptedRequest = DeleteSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DeleteSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/DeleteSoftwareSource");
        Function<Response, DeleteSoftwareSourceResponse> transformer = DeleteSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<DeleteSoftwareSourceRequest, DeleteSoftwareSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSoftwareSourceRequest, DeleteSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetachChildSoftwareSourceFromManagedInstanceResponse> detachChildSoftwareSourceFromManagedInstance(DetachChildSoftwareSourceFromManagedInstanceRequest request, AsyncHandler<DetachChildSoftwareSourceFromManagedInstanceRequest, DetachChildSoftwareSourceFromManagedInstanceResponse> handler) {
        LOG.trace("Called async detachChildSoftwareSourceFromManagedInstance");
        DetachChildSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachChildSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachChildSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DetachChildSoftwareSourceFromManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/DetachChildSoftwareSourceFromManagedInstance");
        Function<Response, DetachChildSoftwareSourceFromManagedInstanceResponse> transformer = DetachChildSoftwareSourceFromManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<DetachChildSoftwareSourceFromManagedInstanceRequest, DetachChildSoftwareSourceFromManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetachChildSoftwareSourceFromManagedInstanceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetachChildSoftwareSourceFromManagedInstanceRequest, DetachChildSoftwareSourceFromManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetachManagedInstanceFromManagedInstanceGroupResponse> detachManagedInstanceFromManagedInstanceGroup(DetachManagedInstanceFromManagedInstanceGroupRequest request, AsyncHandler<DetachManagedInstanceFromManagedInstanceGroupRequest, DetachManagedInstanceFromManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async detachManagedInstanceFromManagedInstanceGroup");
        DetachManagedInstanceFromManagedInstanceGroupRequest interceptedRequest = DetachManagedInstanceFromManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachManagedInstanceFromManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DetachManagedInstanceFromManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/DetachManagedInstanceFromManagedInstanceGroup");
        Function<Response, DetachManagedInstanceFromManagedInstanceGroupResponse> transformer = DetachManagedInstanceFromManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<DetachManagedInstanceFromManagedInstanceGroupRequest, DetachManagedInstanceFromManagedInstanceGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetachManagedInstanceFromManagedInstanceGroupRequest, DetachManagedInstanceFromManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetachParentSoftwareSourceFromManagedInstanceResponse> detachParentSoftwareSourceFromManagedInstance(DetachParentSoftwareSourceFromManagedInstanceRequest request, AsyncHandler<DetachParentSoftwareSourceFromManagedInstanceRequest, DetachParentSoftwareSourceFromManagedInstanceResponse> handler) {
        LOG.trace("Called async detachParentSoftwareSourceFromManagedInstance");
        DetachParentSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachParentSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachParentSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DetachParentSoftwareSourceFromManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/DetachParentSoftwareSourceFromManagedInstance");
        Function<Response, DetachParentSoftwareSourceFromManagedInstanceResponse> transformer = DetachParentSoftwareSourceFromManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<DetachParentSoftwareSourceFromManagedInstanceRequest, DetachParentSoftwareSourceFromManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetachParentSoftwareSourceFromManagedInstanceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetachParentSoftwareSourceFromManagedInstanceRequest, DetachParentSoftwareSourceFromManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DisableModuleStreamOnManagedInstanceResponse> disableModuleStreamOnManagedInstance(DisableModuleStreamOnManagedInstanceRequest request, AsyncHandler<DisableModuleStreamOnManagedInstanceRequest, DisableModuleStreamOnManagedInstanceResponse> handler) {
        LOG.trace("Called async disableModuleStreamOnManagedInstance");
        DisableModuleStreamOnManagedInstanceRequest interceptedRequest = DisableModuleStreamOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DisableModuleStreamOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DisableModuleStreamOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/DisableModuleStreamOnManagedInstance");
        Function<Response, DisableModuleStreamOnManagedInstanceResponse> transformer = DisableModuleStreamOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<DisableModuleStreamOnManagedInstanceRequest, DisableModuleStreamOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DisableModuleStreamOnManagedInstanceRequest, DisableModuleStreamOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<EnableModuleStreamOnManagedInstanceResponse> enableModuleStreamOnManagedInstance(EnableModuleStreamOnManagedInstanceRequest request, AsyncHandler<EnableModuleStreamOnManagedInstanceRequest, EnableModuleStreamOnManagedInstanceResponse> handler) {
        LOG.trace("Called async enableModuleStreamOnManagedInstance");
        EnableModuleStreamOnManagedInstanceRequest interceptedRequest = EnableModuleStreamOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EnableModuleStreamOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "EnableModuleStreamOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/EnableModuleStreamOnManagedInstance");
        Function<Response, EnableModuleStreamOnManagedInstanceResponse> transformer = EnableModuleStreamOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<EnableModuleStreamOnManagedInstanceRequest, EnableModuleStreamOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<EnableModuleStreamOnManagedInstanceRequest, EnableModuleStreamOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetErratumResponse> getErratum(GetErratumRequest request, AsyncHandler<GetErratumRequest, GetErratumResponse> handler) {
        LOG.trace("Called async getErratum");
        GetErratumRequest interceptedRequest = GetErratumConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetErratumConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetErratum", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Erratum/GetErratum");
        Function<Response, GetErratumResponse> transformer = GetErratumConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetErratumRequest, GetErratumResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetErratumRequest, GetErratumResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetManagedInstanceResponse> getManagedInstance(GetManagedInstanceRequest request, AsyncHandler<GetManagedInstanceRequest, GetManagedInstanceResponse> handler) {
        LOG.trace("Called async getManagedInstance");
        GetManagedInstanceRequest interceptedRequest = GetManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/GetManagedInstance");
        Function<Response, GetManagedInstanceResponse> transformer = GetManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetManagedInstanceRequest, GetManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetManagedInstanceRequest, GetManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetManagedInstanceGroupResponse> getManagedInstanceGroup(GetManagedInstanceGroupRequest request, AsyncHandler<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async getManagedInstanceGroup");
        GetManagedInstanceGroupRequest interceptedRequest = GetManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/GetManagedInstanceGroup");
        Function<Response, GetManagedInstanceGroupResponse> transformer = GetManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModuleStreamResponse> getModuleStream(GetModuleStreamRequest request, AsyncHandler<GetModuleStreamRequest, GetModuleStreamResponse> handler) {
        LOG.trace("Called async getModuleStream");
        GetModuleStreamRequest interceptedRequest = GetModuleStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModuleStreamConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetModuleStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStream/GetModuleStream");
        Function<Response, GetModuleStreamResponse> transformer = GetModuleStreamConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetModuleStreamRequest, GetModuleStreamResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModuleStreamRequest, GetModuleStreamResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModuleStreamProfileResponse> getModuleStreamProfile(GetModuleStreamProfileRequest request, AsyncHandler<GetModuleStreamProfileRequest, GetModuleStreamProfileResponse> handler) {
        LOG.trace("Called async getModuleStreamProfile");
        GetModuleStreamProfileRequest interceptedRequest = GetModuleStreamProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModuleStreamProfileConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetModuleStreamProfile", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfile/GetModuleStreamProfile");
        Function<Response, GetModuleStreamProfileResponse> transformer = GetModuleStreamProfileConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetModuleStreamProfileRequest, GetModuleStreamProfileResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModuleStreamProfileRequest, GetModuleStreamProfileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetScheduledJobResponse> getScheduledJob(GetScheduledJobRequest request, AsyncHandler<GetScheduledJobRequest, GetScheduledJobResponse> handler) {
        LOG.trace("Called async getScheduledJob");
        GetScheduledJobRequest interceptedRequest = GetScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetScheduledJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/GetScheduledJob");
        Function<Response, GetScheduledJobResponse> transformer = GetScheduledJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetScheduledJobRequest, GetScheduledJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetScheduledJobRequest, GetScheduledJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSoftwarePackageResponse> getSoftwarePackage(GetSoftwarePackageRequest request, AsyncHandler<GetSoftwarePackageRequest, GetSoftwarePackageResponse> handler) {
        LOG.trace("Called async getSoftwarePackage");
        GetSoftwarePackageRequest interceptedRequest = GetSoftwarePackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSoftwarePackageConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetSoftwarePackage", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/GetSoftwarePackage");
        Function<Response, GetSoftwarePackageResponse> transformer = GetSoftwarePackageConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetSoftwarePackageRequest, GetSoftwarePackageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSoftwarePackageRequest, GetSoftwarePackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSoftwareSourceResponse> getSoftwareSource(GetSoftwareSourceRequest request, AsyncHandler<GetSoftwareSourceRequest, GetSoftwareSourceResponse> handler) {
        LOG.trace("Called async getSoftwareSource");
        GetSoftwareSourceRequest interceptedRequest = GetSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/GetSoftwareSource");
        Function<Response, GetSoftwareSourceResponse> transformer = GetSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetSoftwareSourceRequest, GetSoftwareSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSoftwareSourceRequest, GetSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWindowsUpdateResponse> getWindowsUpdate(GetWindowsUpdateRequest request, AsyncHandler<GetWindowsUpdateRequest, GetWindowsUpdateResponse> handler) {
        LOG.trace("Called async getWindowsUpdate");
        GetWindowsUpdateRequest interceptedRequest = GetWindowsUpdateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWindowsUpdateConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetWindowsUpdate", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WindowsUpdate/GetWindowsUpdate");
        Function<Response, GetWindowsUpdateResponse> transformer = GetWindowsUpdateConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetWindowsUpdateRequest, GetWindowsUpdateResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWindowsUpdateRequest, GetWindowsUpdateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetWorkRequest", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/GetWorkRequest");
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<InstallAllPackageUpdatesOnManagedInstanceResponse> installAllPackageUpdatesOnManagedInstance(InstallAllPackageUpdatesOnManagedInstanceRequest request, AsyncHandler<InstallAllPackageUpdatesOnManagedInstanceRequest, InstallAllPackageUpdatesOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installAllPackageUpdatesOnManagedInstance");
        InstallAllPackageUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllPackageUpdatesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllPackageUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallAllPackageUpdatesOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallAllPackageUpdatesOnManagedInstance");
        Function<Response, InstallAllPackageUpdatesOnManagedInstanceResponse> transformer = InstallAllPackageUpdatesOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<InstallAllPackageUpdatesOnManagedInstanceRequest, InstallAllPackageUpdatesOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<InstallAllPackageUpdatesOnManagedInstanceRequest, InstallAllPackageUpdatesOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<InstallAllUpdatesOnManagedInstanceGroupResponse> installAllUpdatesOnManagedInstanceGroup(InstallAllUpdatesOnManagedInstanceGroupRequest request, AsyncHandler<InstallAllUpdatesOnManagedInstanceGroupRequest, InstallAllUpdatesOnManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async installAllUpdatesOnManagedInstanceGroup");
        InstallAllUpdatesOnManagedInstanceGroupRequest interceptedRequest = InstallAllUpdatesOnManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllUpdatesOnManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallAllUpdatesOnManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/InstallAllUpdatesOnManagedInstanceGroup");
        Function<Response, InstallAllUpdatesOnManagedInstanceGroupResponse> transformer = InstallAllUpdatesOnManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<InstallAllUpdatesOnManagedInstanceGroupRequest, InstallAllUpdatesOnManagedInstanceGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<InstallAllUpdatesOnManagedInstanceGroupRequest, InstallAllUpdatesOnManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<InstallAllWindowsUpdatesOnManagedInstanceResponse> installAllWindowsUpdatesOnManagedInstance(InstallAllWindowsUpdatesOnManagedInstanceRequest request, AsyncHandler<InstallAllWindowsUpdatesOnManagedInstanceRequest, InstallAllWindowsUpdatesOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installAllWindowsUpdatesOnManagedInstance");
        InstallAllWindowsUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllWindowsUpdatesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallAllWindowsUpdatesOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallAllWindowsUpdatesOnManagedInstance");
        Function<Response, InstallAllWindowsUpdatesOnManagedInstanceResponse> transformer = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<InstallAllWindowsUpdatesOnManagedInstanceRequest, InstallAllWindowsUpdatesOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<InstallAllWindowsUpdatesOnManagedInstanceRequest, InstallAllWindowsUpdatesOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<InstallModuleStreamProfileOnManagedInstanceResponse> installModuleStreamProfileOnManagedInstance(InstallModuleStreamProfileOnManagedInstanceRequest request, AsyncHandler<InstallModuleStreamProfileOnManagedInstanceRequest, InstallModuleStreamProfileOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installModuleStreamProfileOnManagedInstance");
        InstallModuleStreamProfileOnManagedInstanceRequest interceptedRequest = InstallModuleStreamProfileOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallModuleStreamProfileOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallModuleStreamProfileOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileDetails/InstallModuleStreamProfileOnManagedInstance");
        Function<Response, InstallModuleStreamProfileOnManagedInstanceResponse> transformer = InstallModuleStreamProfileOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<InstallModuleStreamProfileOnManagedInstanceRequest, InstallModuleStreamProfileOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<InstallModuleStreamProfileOnManagedInstanceRequest, InstallModuleStreamProfileOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<InstallPackageOnManagedInstanceResponse> installPackageOnManagedInstance(InstallPackageOnManagedInstanceRequest request, AsyncHandler<InstallPackageOnManagedInstanceRequest, InstallPackageOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installPackageOnManagedInstance");
        InstallPackageOnManagedInstanceRequest interceptedRequest = InstallPackageOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallPackageOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallPackageOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallPackageOnManagedInstance");
        Function<Response, InstallPackageOnManagedInstanceResponse> transformer = InstallPackageOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<InstallPackageOnManagedInstanceRequest, InstallPackageOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<InstallPackageOnManagedInstanceRequest, InstallPackageOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<InstallPackageUpdateOnManagedInstanceResponse> installPackageUpdateOnManagedInstance(InstallPackageUpdateOnManagedInstanceRequest request, AsyncHandler<InstallPackageUpdateOnManagedInstanceRequest, InstallPackageUpdateOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installPackageUpdateOnManagedInstance");
        InstallPackageUpdateOnManagedInstanceRequest interceptedRequest = InstallPackageUpdateOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallPackageUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallPackageUpdateOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallPackageUpdateOnManagedInstance");
        Function<Response, InstallPackageUpdateOnManagedInstanceResponse> transformer = InstallPackageUpdateOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<InstallPackageUpdateOnManagedInstanceRequest, InstallPackageUpdateOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<InstallPackageUpdateOnManagedInstanceRequest, InstallPackageUpdateOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<InstallWindowsUpdateOnManagedInstanceResponse> installWindowsUpdateOnManagedInstance(InstallWindowsUpdateOnManagedInstanceRequest request, AsyncHandler<InstallWindowsUpdateOnManagedInstanceRequest, InstallWindowsUpdateOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installWindowsUpdateOnManagedInstance");
        InstallWindowsUpdateOnManagedInstanceRequest interceptedRequest = InstallWindowsUpdateOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallWindowsUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallWindowsUpdateOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallWindowsUpdateOnManagedInstance");
        Function<Response, InstallWindowsUpdateOnManagedInstanceResponse> transformer = InstallWindowsUpdateOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<InstallWindowsUpdateOnManagedInstanceRequest, InstallWindowsUpdateOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<InstallWindowsUpdateOnManagedInstanceRequest, InstallWindowsUpdateOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAvailablePackagesForManagedInstanceResponse> listAvailablePackagesForManagedInstance(ListAvailablePackagesForManagedInstanceRequest request, AsyncHandler<ListAvailablePackagesForManagedInstanceRequest, ListAvailablePackagesForManagedInstanceResponse> handler) {
        LOG.trace("Called async listAvailablePackagesForManagedInstance");
        ListAvailablePackagesForManagedInstanceRequest interceptedRequest = ListAvailablePackagesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailablePackagesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListAvailablePackagesForManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailablePackagesForManagedInstance");
        Function<Response, ListAvailablePackagesForManagedInstanceResponse> transformer = ListAvailablePackagesForManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListAvailablePackagesForManagedInstanceRequest, ListAvailablePackagesForManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAvailablePackagesForManagedInstanceRequest, ListAvailablePackagesForManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAvailableSoftwareSourcesForManagedInstanceResponse> listAvailableSoftwareSourcesForManagedInstance(ListAvailableSoftwareSourcesForManagedInstanceRequest request, AsyncHandler<ListAvailableSoftwareSourcesForManagedInstanceRequest, ListAvailableSoftwareSourcesForManagedInstanceResponse> handler) {
        LOG.trace("Called async listAvailableSoftwareSourcesForManagedInstance");
        ListAvailableSoftwareSourcesForManagedInstanceRequest interceptedRequest = ListAvailableSoftwareSourcesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListAvailableSoftwareSourcesForManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableSoftwareSourcesForManagedInstance");
        Function<Response, ListAvailableSoftwareSourcesForManagedInstanceResponse> transformer = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListAvailableSoftwareSourcesForManagedInstanceRequest, ListAvailableSoftwareSourcesForManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAvailableSoftwareSourcesForManagedInstanceRequest, ListAvailableSoftwareSourcesForManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAvailableUpdatesForManagedInstanceResponse> listAvailableUpdatesForManagedInstance(ListAvailableUpdatesForManagedInstanceRequest request, AsyncHandler<ListAvailableUpdatesForManagedInstanceRequest, ListAvailableUpdatesForManagedInstanceResponse> handler) {
        LOG.trace("Called async listAvailableUpdatesForManagedInstance");
        ListAvailableUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableUpdatesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListAvailableUpdatesForManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableUpdatesForManagedInstance");
        Function<Response, ListAvailableUpdatesForManagedInstanceResponse> transformer = ListAvailableUpdatesForManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListAvailableUpdatesForManagedInstanceRequest, ListAvailableUpdatesForManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAvailableUpdatesForManagedInstanceRequest, ListAvailableUpdatesForManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAvailableWindowsUpdatesForManagedInstanceResponse> listAvailableWindowsUpdatesForManagedInstance(ListAvailableWindowsUpdatesForManagedInstanceRequest request, AsyncHandler<ListAvailableWindowsUpdatesForManagedInstanceRequest, ListAvailableWindowsUpdatesForManagedInstanceResponse> handler) {
        LOG.trace("Called async listAvailableWindowsUpdatesForManagedInstance");
        ListAvailableWindowsUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableWindowsUpdatesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListAvailableWindowsUpdatesForManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableWindowsUpdatesForManagedInstance");
        Function<Response, ListAvailableWindowsUpdatesForManagedInstanceResponse> transformer = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListAvailableWindowsUpdatesForManagedInstanceRequest, ListAvailableWindowsUpdatesForManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAvailableWindowsUpdatesForManagedInstanceRequest, ListAvailableWindowsUpdatesForManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListErrataResponse> listErrata(ListErrataRequest request, AsyncHandler<ListErrataRequest, ListErrataResponse> handler) {
        LOG.trace("Called async listErrata");
        ListErrataRequest interceptedRequest = ListErrataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListErrataConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListErrata", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ErratumSummary/ListErrata");
        Function<Response, ListErrataResponse> transformer = ListErrataConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListErrataRequest, ListErrataResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListErrataRequest, ListErrataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListManagedInstanceErrataResponse> listManagedInstanceErrata(ListManagedInstanceErrataRequest request, AsyncHandler<ListManagedInstanceErrataRequest, ListManagedInstanceErrataResponse> handler) {
        LOG.trace("Called async listManagedInstanceErrata");
        ListManagedInstanceErrataRequest interceptedRequest = ListManagedInstanceErrataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstanceErrataConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListManagedInstanceErrata", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListManagedInstanceErrata");
        Function<Response, ListManagedInstanceErrataResponse> transformer = ListManagedInstanceErrataConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListManagedInstanceErrataRequest, ListManagedInstanceErrataResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListManagedInstanceErrataRequest, ListManagedInstanceErrataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListManagedInstanceGroupsResponse> listManagedInstanceGroups(ListManagedInstanceGroupsRequest request, AsyncHandler<ListManagedInstanceGroupsRequest, ListManagedInstanceGroupsResponse> handler) {
        LOG.trace("Called async listManagedInstanceGroups");
        ListManagedInstanceGroupsRequest interceptedRequest = ListManagedInstanceGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstanceGroupsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListManagedInstanceGroups", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroupSummary/ListManagedInstanceGroups");
        Function<Response, ListManagedInstanceGroupsResponse> transformer = ListManagedInstanceGroupsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListManagedInstanceGroupsRequest, ListManagedInstanceGroupsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListManagedInstanceGroupsRequest, ListManagedInstanceGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListManagedInstancesResponse> listManagedInstances(ListManagedInstancesRequest request, AsyncHandler<ListManagedInstancesRequest, ListManagedInstancesResponse> handler) {
        LOG.trace("Called async listManagedInstances");
        ListManagedInstancesRequest interceptedRequest = ListManagedInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstancesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListManagedInstances", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceSummary/ListManagedInstances");
        Function<Response, ListManagedInstancesResponse> transformer = ListManagedInstancesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListManagedInstancesRequest, ListManagedInstancesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListManagedInstancesRequest, ListManagedInstancesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModuleStreamProfilesResponse> listModuleStreamProfiles(ListModuleStreamProfilesRequest request, AsyncHandler<ListModuleStreamProfilesRequest, ListModuleStreamProfilesResponse> handler) {
        LOG.trace("Called async listModuleStreamProfiles");
        ListModuleStreamProfilesRequest interceptedRequest = ListModuleStreamProfilesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamProfilesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListModuleStreamProfiles", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileSummary/ListModuleStreamProfiles");
        Function<Response, ListModuleStreamProfilesResponse> transformer = ListModuleStreamProfilesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListModuleStreamProfilesRequest, ListModuleStreamProfilesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModuleStreamProfilesRequest, ListModuleStreamProfilesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModuleStreamProfilesOnManagedInstanceResponse> listModuleStreamProfilesOnManagedInstance(ListModuleStreamProfilesOnManagedInstanceRequest request, AsyncHandler<ListModuleStreamProfilesOnManagedInstanceRequest, ListModuleStreamProfilesOnManagedInstanceResponse> handler) {
        LOG.trace("Called async listModuleStreamProfilesOnManagedInstance");
        ListModuleStreamProfilesOnManagedInstanceRequest interceptedRequest = ListModuleStreamProfilesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamProfilesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListModuleStreamProfilesOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListModuleStreamProfilesOnManagedInstance");
        Function<Response, ListModuleStreamProfilesOnManagedInstanceResponse> transformer = ListModuleStreamProfilesOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListModuleStreamProfilesOnManagedInstanceRequest, ListModuleStreamProfilesOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModuleStreamProfilesOnManagedInstanceRequest, ListModuleStreamProfilesOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModuleStreamsResponse> listModuleStreams(ListModuleStreamsRequest request, AsyncHandler<ListModuleStreamsRequest, ListModuleStreamsResponse> handler) {
        LOG.trace("Called async listModuleStreams");
        ListModuleStreamsRequest interceptedRequest = ListModuleStreamsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListModuleStreams", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamSummary/ListModuleStreams");
        Function<Response, ListModuleStreamsResponse> transformer = ListModuleStreamsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListModuleStreamsRequest, ListModuleStreamsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModuleStreamsRequest, ListModuleStreamsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModuleStreamsOnManagedInstanceResponse> listModuleStreamsOnManagedInstance(ListModuleStreamsOnManagedInstanceRequest request, AsyncHandler<ListModuleStreamsOnManagedInstanceRequest, ListModuleStreamsOnManagedInstanceResponse> handler) {
        LOG.trace("Called async listModuleStreamsOnManagedInstance");
        ListModuleStreamsOnManagedInstanceRequest interceptedRequest = ListModuleStreamsOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamsOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListModuleStreamsOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListModuleStreamsOnManagedInstance");
        Function<Response, ListModuleStreamsOnManagedInstanceResponse> transformer = ListModuleStreamsOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListModuleStreamsOnManagedInstanceRequest, ListModuleStreamsOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModuleStreamsOnManagedInstanceRequest, ListModuleStreamsOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPackagesInstalledOnManagedInstanceResponse> listPackagesInstalledOnManagedInstance(ListPackagesInstalledOnManagedInstanceRequest request, AsyncHandler<ListPackagesInstalledOnManagedInstanceRequest, ListPackagesInstalledOnManagedInstanceResponse> handler) {
        LOG.trace("Called async listPackagesInstalledOnManagedInstance");
        ListPackagesInstalledOnManagedInstanceRequest interceptedRequest = ListPackagesInstalledOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPackagesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListPackagesInstalledOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListPackagesInstalledOnManagedInstance");
        Function<Response, ListPackagesInstalledOnManagedInstanceResponse> transformer = ListPackagesInstalledOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListPackagesInstalledOnManagedInstanceRequest, ListPackagesInstalledOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPackagesInstalledOnManagedInstanceRequest, ListPackagesInstalledOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListScheduledJobsResponse> listScheduledJobs(ListScheduledJobsRequest request, AsyncHandler<ListScheduledJobsRequest, ListScheduledJobsResponse> handler) {
        LOG.trace("Called async listScheduledJobs");
        ListScheduledJobsRequest interceptedRequest = ListScheduledJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListScheduledJobs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ListScheduledJobs");
        Function<Response, ListScheduledJobsResponse> transformer = ListScheduledJobsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListScheduledJobsRequest, ListScheduledJobsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListScheduledJobsRequest, ListScheduledJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSoftwareSourcePackagesResponse> listSoftwareSourcePackages(ListSoftwareSourcePackagesRequest request, AsyncHandler<ListSoftwareSourcePackagesRequest, ListSoftwareSourcePackagesResponse> handler) {
        LOG.trace("Called async listSoftwareSourcePackages");
        ListSoftwareSourcePackagesRequest interceptedRequest = ListSoftwareSourcePackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSoftwareSourcePackagesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListSoftwareSourcePackages", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/ListSoftwareSourcePackages");
        Function<Response, ListSoftwareSourcePackagesResponse> transformer = ListSoftwareSourcePackagesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListSoftwareSourcePackagesRequest, ListSoftwareSourcePackagesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSoftwareSourcePackagesRequest, ListSoftwareSourcePackagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSoftwareSourcesResponse> listSoftwareSources(ListSoftwareSourcesRequest request, AsyncHandler<ListSoftwareSourcesRequest, ListSoftwareSourcesResponse> handler) {
        LOG.trace("Called async listSoftwareSources");
        ListSoftwareSourcesRequest interceptedRequest = ListSoftwareSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSoftwareSourcesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListSoftwareSources", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSourceSummary/ListSoftwareSources");
        Function<Response, ListSoftwareSourcesResponse> transformer = ListSoftwareSourcesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListSoftwareSourcesRequest, ListSoftwareSourcesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSoftwareSourcesRequest, ListSoftwareSourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListUpcomingScheduledJobsResponse> listUpcomingScheduledJobs(ListUpcomingScheduledJobsRequest request, AsyncHandler<ListUpcomingScheduledJobsRequest, ListUpcomingScheduledJobsResponse> handler) {
        LOG.trace("Called async listUpcomingScheduledJobs");
        ListUpcomingScheduledJobsRequest interceptedRequest = ListUpcomingScheduledJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUpcomingScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListUpcomingScheduledJobs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ListUpcomingScheduledJobs");
        Function<Response, ListUpcomingScheduledJobsResponse> transformer = ListUpcomingScheduledJobsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListUpcomingScheduledJobsRequest, ListUpcomingScheduledJobsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListUpcomingScheduledJobsRequest, ListUpcomingScheduledJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWindowsUpdatesResponse> listWindowsUpdates(ListWindowsUpdatesRequest request, AsyncHandler<ListWindowsUpdatesRequest, ListWindowsUpdatesResponse> handler) {
        LOG.trace("Called async listWindowsUpdates");
        ListWindowsUpdatesRequest interceptedRequest = ListWindowsUpdatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWindowsUpdatesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWindowsUpdates", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WindowsUpdateSummary/ListWindowsUpdates");
        Function<Response, ListWindowsUpdatesResponse> transformer = ListWindowsUpdatesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListWindowsUpdatesRequest, ListWindowsUpdatesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWindowsUpdatesRequest, ListWindowsUpdatesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWindowsUpdatesInstalledOnManagedInstanceResponse> listWindowsUpdatesInstalledOnManagedInstance(ListWindowsUpdatesInstalledOnManagedInstanceRequest request, AsyncHandler<ListWindowsUpdatesInstalledOnManagedInstanceRequest, ListWindowsUpdatesInstalledOnManagedInstanceResponse> handler) {
        LOG.trace("Called async listWindowsUpdatesInstalledOnManagedInstance");
        ListWindowsUpdatesInstalledOnManagedInstanceRequest interceptedRequest = ListWindowsUpdatesInstalledOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWindowsUpdatesInstalledOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListWindowsUpdatesInstalledOnManagedInstance");
        Function<Response, ListWindowsUpdatesInstalledOnManagedInstanceResponse> transformer = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListWindowsUpdatesInstalledOnManagedInstanceRequest, ListWindowsUpdatesInstalledOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWindowsUpdatesInstalledOnManagedInstanceRequest, ListWindowsUpdatesInstalledOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWorkRequestErrors", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/ListWorkRequestErrors");
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWorkRequestLogs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/ListWorkRequestLogs");
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWorkRequests", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequestSummary/ListWorkRequests");
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ManageModuleStreamsOnManagedInstanceResponse> manageModuleStreamsOnManagedInstance(ManageModuleStreamsOnManagedInstanceRequest request, AsyncHandler<ManageModuleStreamsOnManagedInstanceRequest, ManageModuleStreamsOnManagedInstanceResponse> handler) {
        LOG.trace("Called async manageModuleStreamsOnManagedInstance");
        ManageModuleStreamsOnManagedInstanceRequest interceptedRequest = ManageModuleStreamsOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ManageModuleStreamsOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ManageModuleStreamsOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ManageModuleStreamsOnManagedInstance");
        Function<Response, ManageModuleStreamsOnManagedInstanceResponse> transformer = ManageModuleStreamsOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<ManageModuleStreamsOnManagedInstanceRequest, ManageModuleStreamsOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getManageModuleStreamsOnManagedInstanceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ManageModuleStreamsOnManagedInstanceRequest, ManageModuleStreamsOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemoveModuleStreamProfileFromManagedInstanceResponse> removeModuleStreamProfileFromManagedInstance(RemoveModuleStreamProfileFromManagedInstanceRequest request, AsyncHandler<RemoveModuleStreamProfileFromManagedInstanceRequest, RemoveModuleStreamProfileFromManagedInstanceResponse> handler) {
        LOG.trace("Called async removeModuleStreamProfileFromManagedInstance");
        RemoveModuleStreamProfileFromManagedInstanceRequest interceptedRequest = RemoveModuleStreamProfileFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveModuleStreamProfileFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "RemoveModuleStreamProfileFromManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileDetails/RemoveModuleStreamProfileFromManagedInstance");
        Function<Response, RemoveModuleStreamProfileFromManagedInstanceResponse> transformer = RemoveModuleStreamProfileFromManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<RemoveModuleStreamProfileFromManagedInstanceRequest, RemoveModuleStreamProfileFromManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemoveModuleStreamProfileFromManagedInstanceRequest, RemoveModuleStreamProfileFromManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemovePackageFromManagedInstanceResponse> removePackageFromManagedInstance(RemovePackageFromManagedInstanceRequest request, AsyncHandler<RemovePackageFromManagedInstanceRequest, RemovePackageFromManagedInstanceResponse> handler) {
        LOG.trace("Called async removePackageFromManagedInstance");
        RemovePackageFromManagedInstanceRequest interceptedRequest = RemovePackageFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemovePackageFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "RemovePackageFromManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/RemovePackageFromManagedInstance");
        Function<Response, RemovePackageFromManagedInstanceResponse> transformer = RemovePackageFromManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<RemovePackageFromManagedInstanceRequest, RemovePackageFromManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemovePackageFromManagedInstanceRequest, RemovePackageFromManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemovePackagesFromSoftwareSourceResponse> removePackagesFromSoftwareSource(RemovePackagesFromSoftwareSourceRequest request, AsyncHandler<RemovePackagesFromSoftwareSourceRequest, RemovePackagesFromSoftwareSourceResponse> handler) {
        LOG.trace("Called async removePackagesFromSoftwareSource");
        RemovePackagesFromSoftwareSourceRequest interceptedRequest = RemovePackagesFromSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemovePackagesFromSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "RemovePackagesFromSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/RemovePackagesFromSoftwareSource");
        Function<Response, RemovePackagesFromSoftwareSourceResponse> transformer = RemovePackagesFromSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<RemovePackagesFromSoftwareSourceRequest, RemovePackagesFromSoftwareSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getRemovePackagesFromSoftwareSourceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemovePackagesFromSoftwareSourceRequest, RemovePackagesFromSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RunScheduledJobNowResponse> runScheduledJobNow(RunScheduledJobNowRequest request, AsyncHandler<RunScheduledJobNowRequest, RunScheduledJobNowResponse> handler) {
        LOG.trace("Called async runScheduledJobNow");
        RunScheduledJobNowRequest interceptedRequest = RunScheduledJobNowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RunScheduledJobNowConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "RunScheduledJobNow", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/RunScheduledJobNow");
        Function<Response, RunScheduledJobNowResponse> transformer = RunScheduledJobNowConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<RunScheduledJobNowRequest, RunScheduledJobNowResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RunScheduledJobNowRequest, RunScheduledJobNowResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SearchSoftwarePackagesResponse> searchSoftwarePackages(SearchSoftwarePackagesRequest request, AsyncHandler<SearchSoftwarePackagesRequest, SearchSoftwarePackagesResponse> handler) {
        LOG.trace("Called async searchSoftwarePackages");
        SearchSoftwarePackagesRequest interceptedRequest = SearchSoftwarePackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SearchSoftwarePackagesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "SearchSoftwarePackages", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/SearchSoftwarePackages");
        Function<Response, SearchSoftwarePackagesResponse> transformer = SearchSoftwarePackagesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<SearchSoftwarePackagesRequest, SearchSoftwarePackagesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SearchSoftwarePackagesRequest, SearchSoftwarePackagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SkipNextScheduledJobExecutionResponse> skipNextScheduledJobExecution(SkipNextScheduledJobExecutionRequest request, AsyncHandler<SkipNextScheduledJobExecutionRequest, SkipNextScheduledJobExecutionResponse> handler) {
        LOG.trace("Called async skipNextScheduledJobExecution");
        SkipNextScheduledJobExecutionRequest interceptedRequest = SkipNextScheduledJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SkipNextScheduledJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "SkipNextScheduledJobExecution", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/SkipNextScheduledJobExecution");
        Function<Response, SkipNextScheduledJobExecutionResponse> transformer = SkipNextScheduledJobExecutionConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<SkipNextScheduledJobExecutionRequest, SkipNextScheduledJobExecutionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SkipNextScheduledJobExecutionRequest, SkipNextScheduledJobExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SwitchModuleStreamOnManagedInstanceResponse> switchModuleStreamOnManagedInstance(SwitchModuleStreamOnManagedInstanceRequest request, AsyncHandler<SwitchModuleStreamOnManagedInstanceRequest, SwitchModuleStreamOnManagedInstanceResponse> handler) {
        LOG.trace("Called async switchModuleStreamOnManagedInstance");
        SwitchModuleStreamOnManagedInstanceRequest interceptedRequest = SwitchModuleStreamOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SwitchModuleStreamOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "SwitchModuleStreamOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/SwitchModuleStreamOnManagedInstance");
        Function<Response, SwitchModuleStreamOnManagedInstanceResponse> transformer = SwitchModuleStreamOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<SwitchModuleStreamOnManagedInstanceRequest, SwitchModuleStreamOnManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SwitchModuleStreamOnManagedInstanceRequest, SwitchModuleStreamOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateManagedInstanceResponse> updateManagedInstance(UpdateManagedInstanceRequest request, AsyncHandler<UpdateManagedInstanceRequest, UpdateManagedInstanceResponse> handler) {
        LOG.trace("Called async updateManagedInstance");
        UpdateManagedInstanceRequest interceptedRequest = UpdateManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "UpdateManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/UpdateManagedInstanceDetails/UpdateManagedInstance");
        Function<Response, UpdateManagedInstanceResponse> transformer = UpdateManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<UpdateManagedInstanceRequest, UpdateManagedInstanceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateManagedInstanceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateManagedInstanceRequest, UpdateManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateManagedInstanceGroupResponse> updateManagedInstanceGroup(UpdateManagedInstanceGroupRequest request, AsyncHandler<UpdateManagedInstanceGroupRequest, UpdateManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async updateManagedInstanceGroup");
        UpdateManagedInstanceGroupRequest interceptedRequest = UpdateManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "UpdateManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/UpdateManagedInstanceGroup");
        Function<Response, UpdateManagedInstanceGroupResponse> transformer = UpdateManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<UpdateManagedInstanceGroupRequest, UpdateManagedInstanceGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateManagedInstanceGroupDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateManagedInstanceGroupRequest, UpdateManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateScheduledJobResponse> updateScheduledJob(UpdateScheduledJobRequest request, AsyncHandler<UpdateScheduledJobRequest, UpdateScheduledJobResponse> handler) {
        LOG.trace("Called async updateScheduledJob");
        UpdateScheduledJobRequest interceptedRequest = UpdateScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "UpdateScheduledJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/UpdateScheduledJob");
        Function<Response, UpdateScheduledJobResponse> transformer = UpdateScheduledJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<UpdateScheduledJobRequest, UpdateScheduledJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateScheduledJobDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateScheduledJobRequest, UpdateScheduledJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSoftwareSourceResponse> updateSoftwareSource(UpdateSoftwareSourceRequest request, AsyncHandler<UpdateSoftwareSourceRequest, UpdateSoftwareSourceResponse> handler) {
        LOG.trace("Called async updateSoftwareSource");
        UpdateSoftwareSourceRequest interceptedRequest = UpdateSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "UpdateSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/UpdateSoftwareSource");
        Function<Response, UpdateSoftwareSourceResponse> transformer = UpdateSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        AsyncHandler<UpdateSoftwareSourceRequest, UpdateSoftwareSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateSoftwareSourceDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSoftwareSourceRequest, UpdateSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OsManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OsManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new OsManagementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

