/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class ListErrataRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String erratumId;
    private String advisoryName;
    private Date timeIssueDateStart;
    private Date timeIssueDateEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getErratumId() {
        return this.erratumId;
    }

    public String getAdvisoryName() {
        return this.advisoryName;
    }

    public Date getTimeIssueDateStart() {
        return this.timeIssueDateStart;
    }

    public Date getTimeIssueDateEnd() {
        return this.timeIssueDateEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).erratumId(this.erratumId).advisoryName(this.advisoryName).timeIssueDateStart(this.timeIssueDateStart).timeIssueDateEnd(this.timeIssueDateEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",erratumId=").append(String.valueOf(this.erratumId));
        sb.append(",advisoryName=").append(String.valueOf(this.advisoryName));
        sb.append(",timeIssueDateStart=").append(String.valueOf(this.timeIssueDateStart));
        sb.append(",timeIssueDateEnd=").append(String.valueOf(this.timeIssueDateEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListErrataRequest)) {
            return false;
        }
        ListErrataRequest other = (ListErrataRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.erratumId, other.erratumId) && Objects.equals(this.advisoryName, other.advisoryName) && Objects.equals(this.timeIssueDateStart, other.timeIssueDateStart) && Objects.equals(this.timeIssueDateEnd, other.timeIssueDateEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.erratumId == null ? 43 : this.erratumId.hashCode());
        result = result * 59 + (this.advisoryName == null ? 43 : this.advisoryName.hashCode());
        result = result * 59 + (this.timeIssueDateStart == null ? 43 : this.timeIssueDateStart.hashCode());
        result = result * 59 + (this.timeIssueDateEnd == null ? 43 : this.timeIssueDateEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListErrataRequest, Void> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String erratumId = null;
        private String advisoryName = null;
        private Date timeIssueDateStart = null;
        private Date timeIssueDateEnd = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder erratumId(String erratumId) {
            this.erratumId = erratumId;
            return this;
        }

        public Builder advisoryName(String advisoryName) {
            this.advisoryName = advisoryName;
            return this;
        }

        public Builder timeIssueDateStart(Date timeIssueDateStart) {
            this.timeIssueDateStart = timeIssueDateStart;
            return this;
        }

        public Builder timeIssueDateEnd(Date timeIssueDateEnd) {
            this.timeIssueDateEnd = timeIssueDateEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListErrataRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.erratumId(o.getErratumId());
            this.advisoryName(o.getAdvisoryName());
            this.timeIssueDateStart(o.getTimeIssueDateStart());
            this.timeIssueDateEnd(o.getTimeIssueDateEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListErrataRequest build() {
            ListErrataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListErrataRequest buildWithoutInvocationCallback() {
            ListErrataRequest request = new ListErrataRequest();
            request.compartmentId = this.compartmentId;
            request.erratumId = this.erratumId;
            request.advisoryName = this.advisoryName;
            request.timeIssueDateStart = this.timeIssueDateStart;
            request.timeIssueDateEnd = this.timeIssueDateEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy {
        Issuedate("ISSUEDATE"),
        Advisoryname("ADVISORYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

