/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagement.model.Id;
import com.oracle.bmc.osmanagement.model.SoftwareSourceId;
import com.oracle.bmc.osmanagement.model.UpdateTypes;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SoftwarePackageSearchSummary {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="architecture")
    private final String architecture;
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="advisoryType")
    private final UpdateTypes advisoryType;
    @JsonProperty(value="errata")
    private final List<Id> errata;
    @JsonProperty(value="softwareSources")
    private final List<SoftwareSourceId> softwareSources;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    @Deprecated
    @ConstructorProperties(value={"displayName", "name", "type", "version", "architecture", "summary", "advisoryType", "errata", "softwareSources"})
    public SoftwarePackageSearchSummary(String displayName, String name, String type, String version, String architecture, String summary, UpdateTypes advisoryType, List<Id> errata, List<SoftwareSourceId> softwareSources) {
        this.displayName = displayName;
        this.name = name;
        this.type = type;
        this.version = version;
        this.architecture = architecture;
        this.summary = summary;
        this.advisoryType = advisoryType;
        this.errata = errata;
        this.softwareSources = softwareSources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getSummary() {
        return this.summary;
    }

    public UpdateTypes getAdvisoryType() {
        return this.advisoryType;
    }

    public List<Id> getErrata() {
        return this.errata;
    }

    public List<SoftwareSourceId> getSoftwareSources() {
        return this.softwareSources;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SoftwarePackageSearchSummary(");
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", architecture=").append(String.valueOf(this.architecture));
        sb.append(", summary=").append(String.valueOf(this.summary));
        sb.append(", advisoryType=").append(String.valueOf((Object)this.advisoryType));
        sb.append(", errata=").append(String.valueOf(this.errata));
        sb.append(", softwareSources=").append(String.valueOf(this.softwareSources));
        sb.append("__explicitlySet__=").append(String.valueOf(this.__explicitlySet__));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftwarePackageSearchSummary)) {
            return false;
        }
        SoftwarePackageSearchSummary other = (SoftwarePackageSearchSummary)o;
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version) && Objects.equals(this.architecture, other.architecture) && Objects.equals(this.summary, other.summary) && Objects.equals((Object)this.advisoryType, (Object)other.advisoryType) && Objects.equals(this.errata, other.errata) && Objects.equals(this.softwareSources, other.softwareSources) && Objects.equals(this.__explicitlySet__, other.__explicitlySet__);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + (this.advisoryType == null ? 43 : this.advisoryType.hashCode());
        result = result * 59 + (this.errata == null ? 43 : this.errata.hashCode());
        result = result * 59 + (this.softwareSources == null ? 43 : this.softwareSources.hashCode());
        result = result * 59 + (this.__explicitlySet__ == null ? 43 : this.__explicitlySet__.hashCode());
        return result;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="architecture")
        private String architecture;
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="advisoryType")
        private UpdateTypes advisoryType;
        @JsonProperty(value="errata")
        private List<Id> errata;
        @JsonProperty(value="softwareSources")
        private List<SoftwareSourceId> softwareSources;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder advisoryType(UpdateTypes advisoryType) {
            this.advisoryType = advisoryType;
            this.__explicitlySet__.add("advisoryType");
            return this;
        }

        public Builder errata(List<Id> errata) {
            this.errata = errata;
            this.__explicitlySet__.add("errata");
            return this;
        }

        public Builder softwareSources(List<SoftwareSourceId> softwareSources) {
            this.softwareSources = softwareSources;
            this.__explicitlySet__.add("softwareSources");
            return this;
        }

        public SoftwarePackageSearchSummary build() {
            SoftwarePackageSearchSummary __instance__ = new SoftwarePackageSearchSummary(this.displayName, this.name, this.type, this.version, this.architecture, this.summary, this.advisoryType, this.errata, this.softwareSources);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(SoftwarePackageSearchSummary o) {
            Builder copiedBuilder = this.displayName(o.getDisplayName()).name(o.getName()).type(o.getType()).version(o.getVersion()).architecture(o.getArchitecture()).summary(o.getSummary()).advisoryType(o.getAdvisoryType()).errata(o.getErrata()).softwareSources(o.getSoftwareSources());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

