/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.osmanagement.OsManagement;
import com.oracle.bmc.osmanagement.OsManagementAsyncClient;
import com.oracle.bmc.osmanagement.OsManagementPaginators;
import com.oracle.bmc.osmanagement.OsManagementWaiters;
import com.oracle.bmc.osmanagement.internal.http.AddPackagesToSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachChildSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachManagedInstanceToManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachParentSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeManagedInstanceGroupCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeScheduledJobCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeSoftwareSourceCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachChildSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachManagedInstanceFromManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachParentSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.DisableModuleStreamOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.EnableModuleStreamOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetErratumConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.GetModuleStreamConverter;
import com.oracle.bmc.osmanagement.internal.http.GetModuleStreamProfileConverter;
import com.oracle.bmc.osmanagement.internal.http.GetScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwarePackageConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWindowsUpdateConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllPackageUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllUpdatesOnManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllWindowsUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallModuleStreamProfileOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallWindowsUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailablePackagesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableSoftwareSourcesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableWindowsUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListErrataConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstanceErrataConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstanceGroupsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstancesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamProfilesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamProfilesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamsOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListPackagesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListUpcomingScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.osmanagement.internal.http.ManageModuleStreamsOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemoveModuleStreamProfileFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackageFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackagesFromSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.RunScheduledJobNowConverter;
import com.oracle.bmc.osmanagement.internal.http.SearchSoftwarePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.SkipNextScheduledJobExecutionConverter;
import com.oracle.bmc.osmanagement.internal.http.SwitchModuleStreamOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.AttachChildSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.AttachManagedInstanceToManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.AttachParentSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ChangeManagedInstanceGroupCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeScheduledJobCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeSoftwareSourceCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.CreateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DeleteManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DetachChildSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DetachManagedInstanceFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DetachParentSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DisableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.EnableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetErratumRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamProfileRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamRequest;
import com.oracle.bmc.osmanagement.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllPackageUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllUpdatesOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllWindowsUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallModuleStreamProfileOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallWindowsUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailablePackagesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableSoftwareSourcesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableWindowsUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceGroupsRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstancesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsRequest;
import com.oracle.bmc.osmanagement.requests.ListPackagesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcePackagesRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagement.requests.ListUpcomingScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.osmanagement.requests.ManageModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemoveModuleStreamProfileFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackageFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackagesFromSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagement.requests.SearchSoftwarePackagesRequest;
import com.oracle.bmc.osmanagement.requests.SkipNextScheduledJobExecutionRequest;
import com.oracle.bmc.osmanagement.requests.SwitchModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.AttachChildSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.AttachManagedInstanceToManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.AttachParentSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ChangeManagedInstanceGroupCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeScheduledJobCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeSoftwareSourceCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.CreateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DeleteManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DetachChildSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DetachManagedInstanceFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DetachParentSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DisableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.EnableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetErratumResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamProfileResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamResponse;
import com.oracle.bmc.osmanagement.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.osmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllPackageUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllUpdatesOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllWindowsUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallModuleStreamProfileOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallWindowsUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailablePackagesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableSoftwareSourcesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableWindowsUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceGroupsResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstancesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsResponse;
import com.oracle.bmc.osmanagement.responses.ListPackagesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcePackagesResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagement.responses.ListUpcomingScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.osmanagement.responses.ManageModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemoveModuleStreamProfileFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackageFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackagesFromSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagement.responses.SearchSoftwarePackagesResponse;
import com.oracle.bmc.osmanagement.responses.SkipNextScheduledJobExecutionResponse;
import com.oracle.bmc.osmanagement.responses.SwitchModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsManagementClient
implements OsManagement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private static final Logger LOG = LoggerFactory.getLogger(OsManagementAsyncClient.class);
    private final OsManagementWaiters waiters;
    private final OsManagementPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    RestClient getClient() {
        return this.client;
    }

    public OsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        CircuitBreakerConfiguration circuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration((ClientConfiguration)configuration);
        if (circuitBreakerConfiguration == null) {
            circuitBreakerConfiguration = CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION;
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse, isNonBufferingApacheClient, null, circuitBreakerConfiguration);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("OsManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OsManagementWaiters(executorService, this);
        this.paginators = new OsManagementPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AddPackagesToSoftwareSourceResponse addPackagesToSoftwareSource(AddPackagesToSoftwareSourceRequest request) {
        LOG.trace("Called addPackagesToSoftwareSource");
        AddPackagesToSoftwareSourceRequest interceptedRequest = AddPackagesToSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddPackagesToSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddPackagesToSoftwareSourceResponse> transformer = AddPackagesToSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"AddPackagesToSoftwareSource", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/AddPackagesToSoftwareSource");
        return (AddPackagesToSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddPackagesToSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddPackagesToSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (AddPackagesToSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public AttachChildSoftwareSourceToManagedInstanceResponse attachChildSoftwareSourceToManagedInstance(AttachChildSoftwareSourceToManagedInstanceRequest request) {
        LOG.trace("Called attachChildSoftwareSourceToManagedInstance");
        AttachChildSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachChildSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachChildSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachChildSoftwareSourceToManagedInstanceResponse> transformer = AttachChildSoftwareSourceToManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"AttachChildSoftwareSourceToManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/AttachChildSoftwareSourceToManagedInstance");
        return (AttachChildSoftwareSourceToManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachChildSoftwareSourceToManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachChildSoftwareSourceToManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (AttachChildSoftwareSourceToManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public AttachManagedInstanceToManagedInstanceGroupResponse attachManagedInstanceToManagedInstanceGroup(AttachManagedInstanceToManagedInstanceGroupRequest request) {
        LOG.trace("Called attachManagedInstanceToManagedInstanceGroup");
        AttachManagedInstanceToManagedInstanceGroupRequest interceptedRequest = AttachManagedInstanceToManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachManagedInstanceToManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachManagedInstanceToManagedInstanceGroupResponse> transformer = AttachManagedInstanceToManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"AttachManagedInstanceToManagedInstanceGroup", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/AttachManagedInstanceToManagedInstanceGroup");
        return (AttachManagedInstanceToManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachManagedInstanceToManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (AttachManagedInstanceToManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public AttachParentSoftwareSourceToManagedInstanceResponse attachParentSoftwareSourceToManagedInstance(AttachParentSoftwareSourceToManagedInstanceRequest request) {
        LOG.trace("Called attachParentSoftwareSourceToManagedInstance");
        AttachParentSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachParentSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachParentSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachParentSoftwareSourceToManagedInstanceResponse> transformer = AttachParentSoftwareSourceToManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"AttachParentSoftwareSourceToManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/AttachParentSoftwareSourceToManagedInstance");
        return (AttachParentSoftwareSourceToManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachParentSoftwareSourceToManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachParentSoftwareSourceToManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (AttachParentSoftwareSourceToManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeManagedInstanceGroupCompartmentResponse changeManagedInstanceGroupCompartment(ChangeManagedInstanceGroupCompartmentRequest request) {
        LOG.trace("Called changeManagedInstanceGroupCompartment");
        ChangeManagedInstanceGroupCompartmentRequest interceptedRequest = ChangeManagedInstanceGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagedInstanceGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeManagedInstanceGroupCompartmentResponse> transformer = ChangeManagedInstanceGroupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ChangeManagedInstanceGroupCompartment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/ChangeManagedInstanceGroupCompartment");
        return (ChangeManagedInstanceGroupCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeManagedInstanceGroupCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeManagedInstanceGroupCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeManagedInstanceGroupCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeScheduledJobCompartmentResponse changeScheduledJobCompartment(ChangeScheduledJobCompartmentRequest request) {
        LOG.trace("Called changeScheduledJobCompartment");
        ChangeScheduledJobCompartmentRequest interceptedRequest = ChangeScheduledJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeScheduledJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeScheduledJobCompartmentResponse> transformer = ChangeScheduledJobCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ChangeScheduledJobCompartment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ChangeScheduledJobCompartment");
        return (ChangeScheduledJobCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeScheduledJobCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeScheduledJobCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeScheduledJobCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeSoftwareSourceCompartmentResponse changeSoftwareSourceCompartment(ChangeSoftwareSourceCompartmentRequest request) {
        LOG.trace("Called changeSoftwareSourceCompartment");
        ChangeSoftwareSourceCompartmentRequest interceptedRequest = ChangeSoftwareSourceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSoftwareSourceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSoftwareSourceCompartmentResponse> transformer = ChangeSoftwareSourceCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ChangeSoftwareSourceCompartment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/ChangeSoftwareSourceCompartment");
        return (ChangeSoftwareSourceCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeSoftwareSourceCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeSoftwareSourceCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeSoftwareSourceCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateManagedInstanceGroupResponse createManagedInstanceGroup(CreateManagedInstanceGroupRequest request) {
        LOG.trace("Called createManagedInstanceGroup");
        CreateManagedInstanceGroupRequest interceptedRequest = CreateManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateManagedInstanceGroupResponse> transformer = CreateManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"CreateManagedInstanceGroup", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/CreateManagedInstanceGroup");
        return (CreateManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateManagedInstanceGroupDetails(), (BmcRequest)retriedRequest);
                return (CreateManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateScheduledJobResponse createScheduledJob(CreateScheduledJobRequest request) {
        LOG.trace("Called createScheduledJob");
        CreateScheduledJobRequest interceptedRequest = CreateScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateScheduledJobResponse> transformer = CreateScheduledJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"CreateScheduledJob", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/CreateScheduledJob");
        return (CreateScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateScheduledJobDetails(), (BmcRequest)retriedRequest);
                return (CreateScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateSoftwareSourceResponse createSoftwareSource(CreateSoftwareSourceRequest request) {
        LOG.trace("Called createSoftwareSource");
        CreateSoftwareSourceRequest interceptedRequest = CreateSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSoftwareSourceResponse> transformer = CreateSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"CreateSoftwareSource", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/CreateSoftwareSource");
        return (CreateSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (CreateSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteManagedInstanceGroupResponse deleteManagedInstanceGroup(DeleteManagedInstanceGroupRequest request) {
        LOG.trace("Called deleteManagedInstanceGroup");
        DeleteManagedInstanceGroupRequest interceptedRequest = DeleteManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteManagedInstanceGroupResponse> transformer = DeleteManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"DeleteManagedInstanceGroup", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/DeleteManagedInstanceGroup");
        return (DeleteManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteScheduledJobResponse deleteScheduledJob(DeleteScheduledJobRequest request) {
        LOG.trace("Called deleteScheduledJob");
        DeleteScheduledJobRequest interceptedRequest = DeleteScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteScheduledJobResponse> transformer = DeleteScheduledJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"DeleteScheduledJob", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/DeleteScheduledJob");
        return (DeleteScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteSoftwareSourceResponse deleteSoftwareSource(DeleteSoftwareSourceRequest request) {
        LOG.trace("Called deleteSoftwareSource");
        DeleteSoftwareSourceRequest interceptedRequest = DeleteSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSoftwareSourceResponse> transformer = DeleteSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"DeleteSoftwareSource", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/DeleteSoftwareSource");
        return (DeleteSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DetachChildSoftwareSourceFromManagedInstanceResponse detachChildSoftwareSourceFromManagedInstance(DetachChildSoftwareSourceFromManagedInstanceRequest request) {
        LOG.trace("Called detachChildSoftwareSourceFromManagedInstance");
        DetachChildSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachChildSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachChildSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachChildSoftwareSourceFromManagedInstanceResponse> transformer = DetachChildSoftwareSourceFromManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"DetachChildSoftwareSourceFromManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/DetachChildSoftwareSourceFromManagedInstance");
        return (DetachChildSoftwareSourceFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachChildSoftwareSourceFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetachChildSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (DetachChildSoftwareSourceFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DetachManagedInstanceFromManagedInstanceGroupResponse detachManagedInstanceFromManagedInstanceGroup(DetachManagedInstanceFromManagedInstanceGroupRequest request) {
        LOG.trace("Called detachManagedInstanceFromManagedInstanceGroup");
        DetachManagedInstanceFromManagedInstanceGroupRequest interceptedRequest = DetachManagedInstanceFromManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachManagedInstanceFromManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachManagedInstanceFromManagedInstanceGroupResponse> transformer = DetachManagedInstanceFromManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"DetachManagedInstanceFromManagedInstanceGroup", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/DetachManagedInstanceFromManagedInstanceGroup");
        return (DetachManagedInstanceFromManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachManagedInstanceFromManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DetachManagedInstanceFromManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DetachParentSoftwareSourceFromManagedInstanceResponse detachParentSoftwareSourceFromManagedInstance(DetachParentSoftwareSourceFromManagedInstanceRequest request) {
        LOG.trace("Called detachParentSoftwareSourceFromManagedInstance");
        DetachParentSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachParentSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachParentSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachParentSoftwareSourceFromManagedInstanceResponse> transformer = DetachParentSoftwareSourceFromManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"DetachParentSoftwareSourceFromManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/DetachParentSoftwareSourceFromManagedInstance");
        return (DetachParentSoftwareSourceFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachParentSoftwareSourceFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetachParentSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (DetachParentSoftwareSourceFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DisableModuleStreamOnManagedInstanceResponse disableModuleStreamOnManagedInstance(DisableModuleStreamOnManagedInstanceRequest request) {
        LOG.trace("Called disableModuleStreamOnManagedInstance");
        DisableModuleStreamOnManagedInstanceRequest interceptedRequest = DisableModuleStreamOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DisableModuleStreamOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DisableModuleStreamOnManagedInstanceResponse> transformer = DisableModuleStreamOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"DisableModuleStreamOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/DisableModuleStreamOnManagedInstance");
        return (DisableModuleStreamOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DisableModuleStreamOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DisableModuleStreamOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public EnableModuleStreamOnManagedInstanceResponse enableModuleStreamOnManagedInstance(EnableModuleStreamOnManagedInstanceRequest request) {
        LOG.trace("Called enableModuleStreamOnManagedInstance");
        EnableModuleStreamOnManagedInstanceRequest interceptedRequest = EnableModuleStreamOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EnableModuleStreamOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, EnableModuleStreamOnManagedInstanceResponse> transformer = EnableModuleStreamOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"EnableModuleStreamOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/EnableModuleStreamOnManagedInstance");
        return (EnableModuleStreamOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (EnableModuleStreamOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (EnableModuleStreamOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetErratumResponse getErratum(GetErratumRequest request) {
        LOG.trace("Called getErratum");
        GetErratumRequest interceptedRequest = GetErratumConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetErratumConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetErratumResponse> transformer = GetErratumConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetErratum", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Erratum/GetErratum");
        return (GetErratumResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetErratumResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetErratumResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetManagedInstanceResponse getManagedInstance(GetManagedInstanceRequest request) {
        LOG.trace("Called getManagedInstance");
        GetManagedInstanceRequest interceptedRequest = GetManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagedInstanceResponse> transformer = GetManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/GetManagedInstance");
        return (GetManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetManagedInstanceGroupResponse getManagedInstanceGroup(GetManagedInstanceGroupRequest request) {
        LOG.trace("Called getManagedInstanceGroup");
        GetManagedInstanceGroupRequest interceptedRequest = GetManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagedInstanceGroupResponse> transformer = GetManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetManagedInstanceGroup", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/GetManagedInstanceGroup");
        return (GetManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetModuleStreamResponse getModuleStream(GetModuleStreamRequest request) {
        LOG.trace("Called getModuleStream");
        GetModuleStreamRequest interceptedRequest = GetModuleStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModuleStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModuleStreamResponse> transformer = GetModuleStreamConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetModuleStream", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStream/GetModuleStream");
        return (GetModuleStreamResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModuleStreamResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModuleStreamResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetModuleStreamProfileResponse getModuleStreamProfile(GetModuleStreamProfileRequest request) {
        LOG.trace("Called getModuleStreamProfile");
        GetModuleStreamProfileRequest interceptedRequest = GetModuleStreamProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModuleStreamProfileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetModuleStreamProfileResponse> transformer = GetModuleStreamProfileConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetModuleStreamProfile", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfile/GetModuleStreamProfile");
        return (GetModuleStreamProfileResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModuleStreamProfileResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModuleStreamProfileResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetScheduledJobResponse getScheduledJob(GetScheduledJobRequest request) {
        LOG.trace("Called getScheduledJob");
        GetScheduledJobRequest interceptedRequest = GetScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetScheduledJobResponse> transformer = GetScheduledJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetScheduledJob", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/GetScheduledJob");
        return (GetScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetSoftwarePackageResponse getSoftwarePackage(GetSoftwarePackageRequest request) {
        LOG.trace("Called getSoftwarePackage");
        GetSoftwarePackageRequest interceptedRequest = GetSoftwarePackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSoftwarePackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSoftwarePackageResponse> transformer = GetSoftwarePackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetSoftwarePackage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/GetSoftwarePackage");
        return (GetSoftwarePackageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSoftwarePackageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSoftwarePackageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetSoftwareSourceResponse getSoftwareSource(GetSoftwareSourceRequest request) {
        LOG.trace("Called getSoftwareSource");
        GetSoftwareSourceRequest interceptedRequest = GetSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSoftwareSourceResponse> transformer = GetSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetSoftwareSource", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/GetSoftwareSource");
        return (GetSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetWindowsUpdateResponse getWindowsUpdate(GetWindowsUpdateRequest request) {
        LOG.trace("Called getWindowsUpdate");
        GetWindowsUpdateRequest interceptedRequest = GetWindowsUpdateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWindowsUpdateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWindowsUpdateResponse> transformer = GetWindowsUpdateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetWindowsUpdate", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WindowsUpdate/GetWindowsUpdate");
        return (GetWindowsUpdateResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWindowsUpdateResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWindowsUpdateResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"GetWorkRequest", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/GetWorkRequest");
        return (GetWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallAllPackageUpdatesOnManagedInstanceResponse installAllPackageUpdatesOnManagedInstance(InstallAllPackageUpdatesOnManagedInstanceRequest request) {
        LOG.trace("Called installAllPackageUpdatesOnManagedInstance");
        InstallAllPackageUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllPackageUpdatesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllPackageUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallAllPackageUpdatesOnManagedInstanceResponse> transformer = InstallAllPackageUpdatesOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"InstallAllPackageUpdatesOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallAllPackageUpdatesOnManagedInstance");
        return (InstallAllPackageUpdatesOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallAllPackageUpdatesOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallAllPackageUpdatesOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallAllUpdatesOnManagedInstanceGroupResponse installAllUpdatesOnManagedInstanceGroup(InstallAllUpdatesOnManagedInstanceGroupRequest request) {
        LOG.trace("Called installAllUpdatesOnManagedInstanceGroup");
        InstallAllUpdatesOnManagedInstanceGroupRequest interceptedRequest = InstallAllUpdatesOnManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllUpdatesOnManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallAllUpdatesOnManagedInstanceGroupResponse> transformer = InstallAllUpdatesOnManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"InstallAllUpdatesOnManagedInstanceGroup", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/InstallAllUpdatesOnManagedInstanceGroup");
        return (InstallAllUpdatesOnManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallAllUpdatesOnManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallAllUpdatesOnManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallAllWindowsUpdatesOnManagedInstanceResponse installAllWindowsUpdatesOnManagedInstance(InstallAllWindowsUpdatesOnManagedInstanceRequest request) {
        LOG.trace("Called installAllWindowsUpdatesOnManagedInstance");
        InstallAllWindowsUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllWindowsUpdatesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallAllWindowsUpdatesOnManagedInstanceResponse> transformer = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"InstallAllWindowsUpdatesOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallAllWindowsUpdatesOnManagedInstance");
        return (InstallAllWindowsUpdatesOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallAllWindowsUpdatesOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallAllWindowsUpdatesOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallModuleStreamProfileOnManagedInstanceResponse installModuleStreamProfileOnManagedInstance(InstallModuleStreamProfileOnManagedInstanceRequest request) {
        LOG.trace("Called installModuleStreamProfileOnManagedInstance");
        InstallModuleStreamProfileOnManagedInstanceRequest interceptedRequest = InstallModuleStreamProfileOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallModuleStreamProfileOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallModuleStreamProfileOnManagedInstanceResponse> transformer = InstallModuleStreamProfileOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"InstallModuleStreamProfileOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileDetails/InstallModuleStreamProfileOnManagedInstance");
        return (InstallModuleStreamProfileOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallModuleStreamProfileOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallModuleStreamProfileOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallPackageOnManagedInstanceResponse installPackageOnManagedInstance(InstallPackageOnManagedInstanceRequest request) {
        LOG.trace("Called installPackageOnManagedInstance");
        InstallPackageOnManagedInstanceRequest interceptedRequest = InstallPackageOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallPackageOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallPackageOnManagedInstanceResponse> transformer = InstallPackageOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"InstallPackageOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallPackageOnManagedInstance");
        return (InstallPackageOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallPackageOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallPackageOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallPackageUpdateOnManagedInstanceResponse installPackageUpdateOnManagedInstance(InstallPackageUpdateOnManagedInstanceRequest request) {
        LOG.trace("Called installPackageUpdateOnManagedInstance");
        InstallPackageUpdateOnManagedInstanceRequest interceptedRequest = InstallPackageUpdateOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallPackageUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallPackageUpdateOnManagedInstanceResponse> transformer = InstallPackageUpdateOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"InstallPackageUpdateOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallPackageUpdateOnManagedInstance");
        return (InstallPackageUpdateOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallPackageUpdateOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallPackageUpdateOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallWindowsUpdateOnManagedInstanceResponse installWindowsUpdateOnManagedInstance(InstallWindowsUpdateOnManagedInstanceRequest request) {
        LOG.trace("Called installWindowsUpdateOnManagedInstance");
        InstallWindowsUpdateOnManagedInstanceRequest interceptedRequest = InstallWindowsUpdateOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallWindowsUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallWindowsUpdateOnManagedInstanceResponse> transformer = InstallWindowsUpdateOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"InstallWindowsUpdateOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallWindowsUpdateOnManagedInstance");
        return (InstallWindowsUpdateOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallWindowsUpdateOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallWindowsUpdateOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailablePackagesForManagedInstanceResponse listAvailablePackagesForManagedInstance(ListAvailablePackagesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailablePackagesForManagedInstance");
        ListAvailablePackagesForManagedInstanceRequest interceptedRequest = ListAvailablePackagesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailablePackagesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAvailablePackagesForManagedInstanceResponse> transformer = ListAvailablePackagesForManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListAvailablePackagesForManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailablePackagesForManagedInstance");
        return (ListAvailablePackagesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailablePackagesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailablePackagesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailableSoftwareSourcesForManagedInstanceResponse listAvailableSoftwareSourcesForManagedInstance(ListAvailableSoftwareSourcesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailableSoftwareSourcesForManagedInstance");
        ListAvailableSoftwareSourcesForManagedInstanceRequest interceptedRequest = ListAvailableSoftwareSourcesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAvailableSoftwareSourcesForManagedInstanceResponse> transformer = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListAvailableSoftwareSourcesForManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableSoftwareSourcesForManagedInstance");
        return (ListAvailableSoftwareSourcesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailableSoftwareSourcesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailableSoftwareSourcesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailableUpdatesForManagedInstanceResponse listAvailableUpdatesForManagedInstance(ListAvailableUpdatesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailableUpdatesForManagedInstance");
        ListAvailableUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableUpdatesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAvailableUpdatesForManagedInstanceResponse> transformer = ListAvailableUpdatesForManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListAvailableUpdatesForManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableUpdatesForManagedInstance");
        return (ListAvailableUpdatesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailableUpdatesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailableUpdatesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailableWindowsUpdatesForManagedInstanceResponse listAvailableWindowsUpdatesForManagedInstance(ListAvailableWindowsUpdatesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailableWindowsUpdatesForManagedInstance");
        ListAvailableWindowsUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableWindowsUpdatesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAvailableWindowsUpdatesForManagedInstanceResponse> transformer = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListAvailableWindowsUpdatesForManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableWindowsUpdatesForManagedInstance");
        return (ListAvailableWindowsUpdatesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailableWindowsUpdatesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailableWindowsUpdatesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListErrataResponse listErrata(ListErrataRequest request) {
        LOG.trace("Called listErrata");
        ListErrataRequest interceptedRequest = ListErrataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListErrataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListErrataResponse> transformer = ListErrataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListErrata", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ErratumSummary/ListErrata");
        return (ListErrataResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListErrataResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListErrataResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListManagedInstanceErrataResponse listManagedInstanceErrata(ListManagedInstanceErrataRequest request) {
        LOG.trace("Called listManagedInstanceErrata");
        ListManagedInstanceErrataRequest interceptedRequest = ListManagedInstanceErrataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstanceErrataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedInstanceErrataResponse> transformer = ListManagedInstanceErrataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListManagedInstanceErrata", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListManagedInstanceErrata");
        return (ListManagedInstanceErrataResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedInstanceErrataResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedInstanceErrataResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListManagedInstanceGroupsResponse listManagedInstanceGroups(ListManagedInstanceGroupsRequest request) {
        LOG.trace("Called listManagedInstanceGroups");
        ListManagedInstanceGroupsRequest interceptedRequest = ListManagedInstanceGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstanceGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedInstanceGroupsResponse> transformer = ListManagedInstanceGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListManagedInstanceGroups", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroupSummary/ListManagedInstanceGroups");
        return (ListManagedInstanceGroupsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedInstanceGroupsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedInstanceGroupsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListManagedInstancesResponse listManagedInstances(ListManagedInstancesRequest request) {
        LOG.trace("Called listManagedInstances");
        ListManagedInstancesRequest interceptedRequest = ListManagedInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedInstancesResponse> transformer = ListManagedInstancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListManagedInstances", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceSummary/ListManagedInstances");
        return (ListManagedInstancesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedInstancesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedInstancesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModuleStreamProfilesResponse listModuleStreamProfiles(ListModuleStreamProfilesRequest request) {
        LOG.trace("Called listModuleStreamProfiles");
        ListModuleStreamProfilesRequest interceptedRequest = ListModuleStreamProfilesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamProfilesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModuleStreamProfilesResponse> transformer = ListModuleStreamProfilesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListModuleStreamProfiles", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileSummary/ListModuleStreamProfiles");
        return (ListModuleStreamProfilesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModuleStreamProfilesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModuleStreamProfilesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModuleStreamProfilesOnManagedInstanceResponse listModuleStreamProfilesOnManagedInstance(ListModuleStreamProfilesOnManagedInstanceRequest request) {
        LOG.trace("Called listModuleStreamProfilesOnManagedInstance");
        ListModuleStreamProfilesOnManagedInstanceRequest interceptedRequest = ListModuleStreamProfilesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamProfilesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModuleStreamProfilesOnManagedInstanceResponse> transformer = ListModuleStreamProfilesOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListModuleStreamProfilesOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListModuleStreamProfilesOnManagedInstance");
        return (ListModuleStreamProfilesOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModuleStreamProfilesOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModuleStreamProfilesOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModuleStreamsResponse listModuleStreams(ListModuleStreamsRequest request) {
        LOG.trace("Called listModuleStreams");
        ListModuleStreamsRequest interceptedRequest = ListModuleStreamsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModuleStreamsResponse> transformer = ListModuleStreamsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListModuleStreams", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamSummary/ListModuleStreams");
        return (ListModuleStreamsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModuleStreamsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModuleStreamsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModuleStreamsOnManagedInstanceResponse listModuleStreamsOnManagedInstance(ListModuleStreamsOnManagedInstanceRequest request) {
        LOG.trace("Called listModuleStreamsOnManagedInstance");
        ListModuleStreamsOnManagedInstanceRequest interceptedRequest = ListModuleStreamsOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamsOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListModuleStreamsOnManagedInstanceResponse> transformer = ListModuleStreamsOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListModuleStreamsOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListModuleStreamsOnManagedInstance");
        return (ListModuleStreamsOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModuleStreamsOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModuleStreamsOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListPackagesInstalledOnManagedInstanceResponse listPackagesInstalledOnManagedInstance(ListPackagesInstalledOnManagedInstanceRequest request) {
        LOG.trace("Called listPackagesInstalledOnManagedInstance");
        ListPackagesInstalledOnManagedInstanceRequest interceptedRequest = ListPackagesInstalledOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPackagesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPackagesInstalledOnManagedInstanceResponse> transformer = ListPackagesInstalledOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListPackagesInstalledOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListPackagesInstalledOnManagedInstance");
        return (ListPackagesInstalledOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPackagesInstalledOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPackagesInstalledOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListScheduledJobsResponse listScheduledJobs(ListScheduledJobsRequest request) {
        LOG.trace("Called listScheduledJobs");
        ListScheduledJobsRequest interceptedRequest = ListScheduledJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListScheduledJobsResponse> transformer = ListScheduledJobsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListScheduledJobs", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ListScheduledJobs");
        return (ListScheduledJobsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListScheduledJobsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListScheduledJobsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListSoftwareSourcePackagesResponse listSoftwareSourcePackages(ListSoftwareSourcePackagesRequest request) {
        LOG.trace("Called listSoftwareSourcePackages");
        ListSoftwareSourcePackagesRequest interceptedRequest = ListSoftwareSourcePackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSoftwareSourcePackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSoftwareSourcePackagesResponse> transformer = ListSoftwareSourcePackagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListSoftwareSourcePackages", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/ListSoftwareSourcePackages");
        return (ListSoftwareSourcePackagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSoftwareSourcePackagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSoftwareSourcePackagesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListSoftwareSourcesResponse listSoftwareSources(ListSoftwareSourcesRequest request) {
        LOG.trace("Called listSoftwareSources");
        ListSoftwareSourcesRequest interceptedRequest = ListSoftwareSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSoftwareSourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSoftwareSourcesResponse> transformer = ListSoftwareSourcesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListSoftwareSources", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSourceSummary/ListSoftwareSources");
        return (ListSoftwareSourcesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSoftwareSourcesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSoftwareSourcesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListUpcomingScheduledJobsResponse listUpcomingScheduledJobs(ListUpcomingScheduledJobsRequest request) {
        LOG.trace("Called listUpcomingScheduledJobs");
        ListUpcomingScheduledJobsRequest interceptedRequest = ListUpcomingScheduledJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUpcomingScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListUpcomingScheduledJobsResponse> transformer = ListUpcomingScheduledJobsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListUpcomingScheduledJobs", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ListUpcomingScheduledJobs");
        return (ListUpcomingScheduledJobsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListUpcomingScheduledJobsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListUpcomingScheduledJobsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWindowsUpdatesResponse listWindowsUpdates(ListWindowsUpdatesRequest request) {
        LOG.trace("Called listWindowsUpdates");
        ListWindowsUpdatesRequest interceptedRequest = ListWindowsUpdatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWindowsUpdatesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWindowsUpdatesResponse> transformer = ListWindowsUpdatesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListWindowsUpdates", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WindowsUpdateSummary/ListWindowsUpdates");
        return (ListWindowsUpdatesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWindowsUpdatesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWindowsUpdatesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWindowsUpdatesInstalledOnManagedInstanceResponse listWindowsUpdatesInstalledOnManagedInstance(ListWindowsUpdatesInstalledOnManagedInstanceRequest request) {
        LOG.trace("Called listWindowsUpdatesInstalledOnManagedInstance");
        ListWindowsUpdatesInstalledOnManagedInstanceRequest interceptedRequest = ListWindowsUpdatesInstalledOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWindowsUpdatesInstalledOnManagedInstanceResponse> transformer = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListWindowsUpdatesInstalledOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListWindowsUpdatesInstalledOnManagedInstance");
        return (ListWindowsUpdatesInstalledOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWindowsUpdatesInstalledOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWindowsUpdatesInstalledOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListWorkRequestErrors", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/ListWorkRequestErrors");
        return (ListWorkRequestErrorsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListWorkRequestLogs", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/ListWorkRequestLogs");
        return (ListWorkRequestLogsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ListWorkRequests", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequestSummary/ListWorkRequests");
        return (ListWorkRequestsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ManageModuleStreamsOnManagedInstanceResponse manageModuleStreamsOnManagedInstance(ManageModuleStreamsOnManagedInstanceRequest request) {
        LOG.trace("Called manageModuleStreamsOnManagedInstance");
        ManageModuleStreamsOnManagedInstanceRequest interceptedRequest = ManageModuleStreamsOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ManageModuleStreamsOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ManageModuleStreamsOnManagedInstanceResponse> transformer = ManageModuleStreamsOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"ManageModuleStreamsOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ManageModuleStreamsOnManagedInstance");
        return (ManageModuleStreamsOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ManageModuleStreamsOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getManageModuleStreamsOnManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (ManageModuleStreamsOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RemoveModuleStreamProfileFromManagedInstanceResponse removeModuleStreamProfileFromManagedInstance(RemoveModuleStreamProfileFromManagedInstanceRequest request) {
        LOG.trace("Called removeModuleStreamProfileFromManagedInstance");
        RemoveModuleStreamProfileFromManagedInstanceRequest interceptedRequest = RemoveModuleStreamProfileFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveModuleStreamProfileFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveModuleStreamProfileFromManagedInstanceResponse> transformer = RemoveModuleStreamProfileFromManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"RemoveModuleStreamProfileFromManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileDetails/RemoveModuleStreamProfileFromManagedInstance");
        return (RemoveModuleStreamProfileFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveModuleStreamProfileFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RemoveModuleStreamProfileFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RemovePackageFromManagedInstanceResponse removePackageFromManagedInstance(RemovePackageFromManagedInstanceRequest request) {
        LOG.trace("Called removePackageFromManagedInstance");
        RemovePackageFromManagedInstanceRequest interceptedRequest = RemovePackageFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemovePackageFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemovePackageFromManagedInstanceResponse> transformer = RemovePackageFromManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"RemovePackageFromManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/RemovePackageFromManagedInstance");
        return (RemovePackageFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemovePackageFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RemovePackageFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RemovePackagesFromSoftwareSourceResponse removePackagesFromSoftwareSource(RemovePackagesFromSoftwareSourceRequest request) {
        LOG.trace("Called removePackagesFromSoftwareSource");
        RemovePackagesFromSoftwareSourceRequest interceptedRequest = RemovePackagesFromSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemovePackagesFromSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemovePackagesFromSoftwareSourceResponse> transformer = RemovePackagesFromSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"RemovePackagesFromSoftwareSource", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/RemovePackagesFromSoftwareSource");
        return (RemovePackagesFromSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemovePackagesFromSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRemovePackagesFromSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (RemovePackagesFromSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RunScheduledJobNowResponse runScheduledJobNow(RunScheduledJobNowRequest request) {
        LOG.trace("Called runScheduledJobNow");
        RunScheduledJobNowRequest interceptedRequest = RunScheduledJobNowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RunScheduledJobNowConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RunScheduledJobNowResponse> transformer = RunScheduledJobNowConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"RunScheduledJobNow", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/RunScheduledJobNow");
        return (RunScheduledJobNowResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RunScheduledJobNowResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RunScheduledJobNowResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public SearchSoftwarePackagesResponse searchSoftwarePackages(SearchSoftwarePackagesRequest request) {
        LOG.trace("Called searchSoftwarePackages");
        SearchSoftwarePackagesRequest interceptedRequest = SearchSoftwarePackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SearchSoftwarePackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SearchSoftwarePackagesResponse> transformer = SearchSoftwarePackagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"SearchSoftwarePackages", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/SearchSoftwarePackages");
        return (SearchSoftwarePackagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SearchSoftwarePackagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SearchSoftwarePackagesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public SkipNextScheduledJobExecutionResponse skipNextScheduledJobExecution(SkipNextScheduledJobExecutionRequest request) {
        LOG.trace("Called skipNextScheduledJobExecution");
        SkipNextScheduledJobExecutionRequest interceptedRequest = SkipNextScheduledJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SkipNextScheduledJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SkipNextScheduledJobExecutionResponse> transformer = SkipNextScheduledJobExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"SkipNextScheduledJobExecution", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/SkipNextScheduledJobExecution");
        return (SkipNextScheduledJobExecutionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SkipNextScheduledJobExecutionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (SkipNextScheduledJobExecutionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public SwitchModuleStreamOnManagedInstanceResponse switchModuleStreamOnManagedInstance(SwitchModuleStreamOnManagedInstanceRequest request) {
        LOG.trace("Called switchModuleStreamOnManagedInstance");
        SwitchModuleStreamOnManagedInstanceRequest interceptedRequest = SwitchModuleStreamOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SwitchModuleStreamOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SwitchModuleStreamOnManagedInstanceResponse> transformer = SwitchModuleStreamOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"SwitchModuleStreamOnManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/SwitchModuleStreamOnManagedInstance");
        return (SwitchModuleStreamOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SwitchModuleStreamOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (SwitchModuleStreamOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateManagedInstanceResponse updateManagedInstance(UpdateManagedInstanceRequest request) {
        LOG.trace("Called updateManagedInstance");
        UpdateManagedInstanceRequest interceptedRequest = UpdateManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagedInstanceResponse> transformer = UpdateManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"UpdateManagedInstance", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/UpdateManagedInstanceDetails/UpdateManagedInstance");
        return (UpdateManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateManagedInstanceGroupResponse updateManagedInstanceGroup(UpdateManagedInstanceGroupRequest request) {
        LOG.trace("Called updateManagedInstanceGroup");
        UpdateManagedInstanceGroupRequest interceptedRequest = UpdateManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagedInstanceGroupResponse> transformer = UpdateManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"UpdateManagedInstanceGroup", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/UpdateManagedInstanceGroup");
        return (UpdateManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagedInstanceGroupDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateScheduledJobResponse updateScheduledJob(UpdateScheduledJobRequest request) {
        LOG.trace("Called updateScheduledJob");
        UpdateScheduledJobRequest interceptedRequest = UpdateScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateScheduledJobResponse> transformer = UpdateScheduledJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"UpdateScheduledJob", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/UpdateScheduledJob");
        return (UpdateScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateScheduledJobDetails(), (BmcRequest)retriedRequest);
                return (UpdateScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateSoftwareSourceResponse updateSoftwareSource(UpdateSoftwareSourceRequest request) {
        LOG.trace("Called updateSoftwareSource");
        UpdateSoftwareSourceRequest interceptedRequest = UpdateSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSoftwareSourceResponse> transformer = UpdateSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"OsManagement", (String)"UpdateSoftwareSource", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/UpdateSoftwareSource");
        return (UpdateSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (UpdateSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public OsManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OsManagementPaginators getPaginators() {
        return this.paginators;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OsManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OsManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new OsManagementClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

