/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.osmanagement.Event;
import com.oracle.bmc.osmanagement.model.EventSummary;
import com.oracle.bmc.osmanagement.model.RelatedEventSummary;
import com.oracle.bmc.osmanagement.requests.ListEventsRequest;
import com.oracle.bmc.osmanagement.requests.ListRelatedEventsRequest;
import com.oracle.bmc.osmanagement.responses.ListEventsResponse;
import com.oracle.bmc.osmanagement.responses.ListRelatedEventsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class EventPaginators {
    private final Event client;

    public Iterable<ListEventsResponse> listEventsResponseIterator(final ListEventsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEventsRequest.Builder>(){

            public ListEventsRequest.Builder get() {
                return ListEventsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEventsResponse, String>(){

            public String apply(ListEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEventsRequest.Builder>, ListEventsRequest>(){

            public ListEventsRequest apply(RequestBuilderAndToken<ListEventsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListEventsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEventsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListEventsRequest, ListEventsResponse>(){

            public ListEventsResponse apply(ListEventsRequest request) {
                return EventPaginators.this.client.listEvents(request);
            }
        });
    }

    public Iterable<EventSummary> listEventsRecordIterator(final ListEventsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEventsRequest.Builder>(){

            public ListEventsRequest.Builder get() {
                return ListEventsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEventsResponse, String>(){

            public String apply(ListEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEventsRequest.Builder>, ListEventsRequest>(){

            public ListEventsRequest apply(RequestBuilderAndToken<ListEventsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListEventsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEventsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListEventsRequest, ListEventsResponse>(){

            public ListEventsResponse apply(ListEventsRequest request) {
                return EventPaginators.this.client.listEvents(request);
            }
        }, (Function)new Function<ListEventsResponse, List<EventSummary>>(){

            public List<EventSummary> apply(ListEventsResponse response) {
                return response.getEventCollection().getItems();
            }
        });
    }

    public Iterable<ListRelatedEventsResponse> listRelatedEventsResponseIterator(final ListRelatedEventsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRelatedEventsRequest.Builder>(){

            public ListRelatedEventsRequest.Builder get() {
                return ListRelatedEventsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRelatedEventsResponse, String>(){

            public String apply(ListRelatedEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRelatedEventsRequest.Builder>, ListRelatedEventsRequest>(){

            public ListRelatedEventsRequest apply(RequestBuilderAndToken<ListRelatedEventsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRelatedEventsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRelatedEventsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRelatedEventsRequest, ListRelatedEventsResponse>(){

            public ListRelatedEventsResponse apply(ListRelatedEventsRequest request) {
                return EventPaginators.this.client.listRelatedEvents(request);
            }
        });
    }

    public Iterable<RelatedEventSummary> listRelatedEventsRecordIterator(final ListRelatedEventsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRelatedEventsRequest.Builder>(){

            public ListRelatedEventsRequest.Builder get() {
                return ListRelatedEventsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRelatedEventsResponse, String>(){

            public String apply(ListRelatedEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRelatedEventsRequest.Builder>, ListRelatedEventsRequest>(){

            public ListRelatedEventsRequest apply(RequestBuilderAndToken<ListRelatedEventsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRelatedEventsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRelatedEventsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRelatedEventsRequest, ListRelatedEventsResponse>(){

            public ListRelatedEventsResponse apply(ListRelatedEventsRequest request) {
                return EventPaginators.this.client.listRelatedEvents(request);
            }
        }, (Function)new Function<ListRelatedEventsResponse, List<RelatedEventSummary>>(){

            public List<RelatedEventSummary> apply(ListRelatedEventsResponse response) {
                return response.getRelatedEventCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public EventPaginators(Event client) {
        this.client = client;
    }
}

