/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPackagesToSoftwareSourceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AddPackagesToSoftwareSourceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static AddPackagesToSoftwareSourceRequest interceptRequest(AddPackagesToSoftwareSourceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, AddPackagesToSoftwareSourceRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getAddPackagesToSoftwareSourceDetails(), (String)"addPackagesToSoftwareSourceDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("softwareSources").path(HttpUtils.encodePathSegment((String)request.getSoftwareSourceId())).path("actions").path("addPackages");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, AddPackagesToSoftwareSourceResponse> fromResponse() {
        Function<Response, AddPackagesToSoftwareSourceResponse> transformer = new Function<Response, AddPackagesToSoftwareSourceResponse>(){

            public AddPackagesToSoftwareSourceResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.AddPackagesToSoftwareSourceResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                AddPackagesToSoftwareSourceResponse.Builder builder = AddPackagesToSoftwareSourceResponse.builder();
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                AddPackagesToSoftwareSourceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

