/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.WindowsUpdate;
import java.beans.ConstructorProperties;

public class GetWindowsUpdateResponse {
    private String opcRequestId;
    private WindowsUpdate windowsUpdate;

    @ConstructorProperties(value={"opcRequestId", "windowsUpdate"})
    GetWindowsUpdateResponse(String opcRequestId, WindowsUpdate windowsUpdate) {
        this.opcRequestId = opcRequestId;
        this.windowsUpdate = windowsUpdate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public WindowsUpdate getWindowsUpdate() {
        return this.windowsUpdate;
    }

    public static class Builder {
        private String opcRequestId;
        private WindowsUpdate windowsUpdate;

        public Builder copy(GetWindowsUpdateResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.windowsUpdate(o.getWindowsUpdate());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder windowsUpdate(WindowsUpdate windowsUpdate) {
            this.windowsUpdate = windowsUpdate;
            return this;
        }

        public GetWindowsUpdateResponse build() {
            return new GetWindowsUpdateResponse(this.opcRequestId, this.windowsUpdate);
        }

        public String toString() {
            return "GetWindowsUpdateResponse.Builder(opcRequestId=" + this.opcRequestId + ", windowsUpdate=" + this.windowsUpdate + ")";
        }
    }
}

