/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetErratumRequest
extends BmcRequest {
    private String erratumId;
    private String opcRequestId;

    @ConstructorProperties(value={"erratumId", "opcRequestId"})
    GetErratumRequest(String erratumId, String opcRequestId) {
        this.erratumId = erratumId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getErratumId() {
        return this.erratumId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String erratumId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetErratumRequest o) {
            this.erratumId(o.getErratumId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetErratumRequest build() {
            GetErratumRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder erratumId(String erratumId) {
            this.erratumId = erratumId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetErratumRequest buildWithoutInvocationCallback() {
            return new GetErratumRequest(this.erratumId, this.opcRequestId);
        }

        public String toString() {
            return "GetErratumRequest.Builder(erratumId=" + this.erratumId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

