/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetManagedInstanceGroupRequest
extends BmcRequest {
    private String managedInstanceGroupId;
    private String opcRequestId;

    @ConstructorProperties(value={"managedInstanceGroupId", "opcRequestId"})
    GetManagedInstanceGroupRequest(String managedInstanceGroupId, String opcRequestId) {
        this.managedInstanceGroupId = managedInstanceGroupId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagedInstanceGroupId() {
        return this.managedInstanceGroupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String managedInstanceGroupId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagedInstanceGroupRequest o) {
            this.managedInstanceGroupId(o.getManagedInstanceGroupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagedInstanceGroupRequest build() {
            GetManagedInstanceGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedInstanceGroupId(String managedInstanceGroupId) {
            this.managedInstanceGroupId = managedInstanceGroupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetManagedInstanceGroupRequest buildWithoutInvocationCallback() {
            return new GetManagedInstanceGroupRequest(this.managedInstanceGroupId, this.opcRequestId);
        }

        public String toString() {
            return "GetManagedInstanceGroupRequest.Builder(managedInstanceGroupId=" + this.managedInstanceGroupId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

