/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.requests.AttachChildSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.responses.AttachChildSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachChildSoftwareSourceToManagedInstanceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AttachChildSoftwareSourceToManagedInstanceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static AttachChildSoftwareSourceToManagedInstanceRequest interceptRequest(AttachChildSoftwareSourceToManagedInstanceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, AttachChildSoftwareSourceToManagedInstanceRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getAttachChildSoftwareSourceToManagedInstanceDetails(), (String)"attachChildSoftwareSourceToManagedInstanceDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("managedInstances").path(HttpUtils.encodePathSegment((String)request.getManagedInstanceId())).path("actions").path("attachChildSoftwareSource");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, AttachChildSoftwareSourceToManagedInstanceResponse> fromResponse() {
        Function<Response, AttachChildSoftwareSourceToManagedInstanceResponse> transformer = new Function<Response, AttachChildSoftwareSourceToManagedInstanceResponse>(){

            public AttachChildSoftwareSourceToManagedInstanceResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for AttachChildSoftwareSourceToManagedInstanceResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                AttachChildSoftwareSourceToManagedInstanceResponse.Builder builder = AttachChildSoftwareSourceToManagedInstanceResponse.builder();
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                AttachChildSoftwareSourceToManagedInstanceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

