/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class AttachManagedInstanceToManagedInstanceGroupRequest
extends BmcRequest {
    private String managedInstanceGroupId;
    private String managedInstanceId;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"managedInstanceGroupId", "managedInstanceId", "opcRequestId", "opcRetryToken"})
    AttachManagedInstanceToManagedInstanceGroupRequest(String managedInstanceGroupId, String managedInstanceId, String opcRequestId, String opcRetryToken) {
        this.managedInstanceGroupId = managedInstanceGroupId;
        this.managedInstanceId = managedInstanceId;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagedInstanceGroupId() {
        return this.managedInstanceGroupId;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String managedInstanceGroupId;
        private String managedInstanceId;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AttachManagedInstanceToManagedInstanceGroupRequest o) {
            this.managedInstanceGroupId(o.getManagedInstanceGroupId());
            this.managedInstanceId(o.getManagedInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AttachManagedInstanceToManagedInstanceGroupRequest build() {
            AttachManagedInstanceToManagedInstanceGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedInstanceGroupId(String managedInstanceGroupId) {
            this.managedInstanceGroupId = managedInstanceGroupId;
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public AttachManagedInstanceToManagedInstanceGroupRequest buildWithoutInvocationCallback() {
            return new AttachManagedInstanceToManagedInstanceGroupRequest(this.managedInstanceGroupId, this.managedInstanceId, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "AttachManagedInstanceToManagedInstanceGroupRequest.Builder(managedInstanceGroupId=" + this.managedInstanceGroupId + ", managedInstanceId=" + this.managedInstanceId + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

