/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetManagedInstanceRequest
extends BmcRequest {
    private String managedInstanceId;
    private String opcRequestId;

    @ConstructorProperties(value={"managedInstanceId", "opcRequestId"})
    GetManagedInstanceRequest(String managedInstanceId, String opcRequestId) {
        this.managedInstanceId = managedInstanceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String managedInstanceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagedInstanceRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagedInstanceRequest build() {
            GetManagedInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetManagedInstanceRequest buildWithoutInvocationCallback() {
            return new GetManagedInstanceRequest(this.managedInstanceId, this.opcRequestId);
        }

        public String toString() {
            return "GetManagedInstanceRequest.Builder(managedInstanceId=" + this.managedInstanceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

