/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.optimizer.model.BulkApplyRecommendationsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class BulkApplyRecommendationsRequest
extends BmcRequest<BulkApplyRecommendationsDetails> {
    private String recommendationId;
    private BulkApplyRecommendationsDetails bulkApplyRecommendationsDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public BulkApplyRecommendationsDetails getBulkApplyRecommendationsDetails() {
        return this.bulkApplyRecommendationsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public BulkApplyRecommendationsDetails getBody$() {
        return this.bulkApplyRecommendationsDetails;
    }

    public Builder toBuilder() {
        return new Builder().recommendationId(this.recommendationId).bulkApplyRecommendationsDetails(this.bulkApplyRecommendationsDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",recommendationId=").append(String.valueOf(this.recommendationId));
        sb.append(",bulkApplyRecommendationsDetails=").append(String.valueOf((Object)this.bulkApplyRecommendationsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkApplyRecommendationsRequest)) {
            return false;
        }
        BulkApplyRecommendationsRequest other = (BulkApplyRecommendationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.recommendationId, other.recommendationId) && Objects.equals((Object)this.bulkApplyRecommendationsDetails, (Object)other.bulkApplyRecommendationsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.recommendationId == null ? 43 : this.recommendationId.hashCode());
        result = result * 59 + (this.bulkApplyRecommendationsDetails == null ? 43 : this.bulkApplyRecommendationsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkApplyRecommendationsRequest, BulkApplyRecommendationsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String recommendationId = null;
        private BulkApplyRecommendationsDetails bulkApplyRecommendationsDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public Builder bulkApplyRecommendationsDetails(BulkApplyRecommendationsDetails bulkApplyRecommendationsDetails) {
            this.bulkApplyRecommendationsDetails = bulkApplyRecommendationsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkApplyRecommendationsRequest o) {
            this.recommendationId(o.getRecommendationId());
            this.bulkApplyRecommendationsDetails(o.getBulkApplyRecommendationsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkApplyRecommendationsRequest build() {
            BulkApplyRecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkApplyRecommendationsDetails body) {
            this.bulkApplyRecommendationsDetails(body);
            return this;
        }

        public BulkApplyRecommendationsRequest buildWithoutInvocationCallback() {
            BulkApplyRecommendationsRequest request = new BulkApplyRecommendationsRequest();
            request.recommendationId = this.recommendationId;
            request.bulkApplyRecommendationsDetails = this.bulkApplyRecommendationsDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

