/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.optimizer.model.StrategyParameterType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StrategyParameter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final StrategyParameterType type;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isRequired")
    private final Boolean isRequired;
    @JsonProperty(value="defaultValue")
    private final Object defaultValue;
    @JsonProperty(value="possibleValues")
    private final List<Object> possibleValues;

    @Deprecated
    @ConstructorProperties(value={"name", "type", "description", "isRequired", "defaultValue", "possibleValues"})
    public StrategyParameter(String name, StrategyParameterType type, String description, Boolean isRequired, Object defaultValue, List<Object> possibleValues) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.isRequired = isRequired;
        this.defaultValue = defaultValue;
        this.possibleValues = possibleValues;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public StrategyParameterType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public List<Object> getPossibleValues() {
        return this.possibleValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StrategyParameter(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", isRequired=").append(String.valueOf(this.isRequired));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(", possibleValues=").append(String.valueOf(this.possibleValues));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StrategyParameter)) {
            return false;
        }
        StrategyParameter other = (StrategyParameter)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.description, other.description) && Objects.equals(this.isRequired, other.isRequired) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.possibleValues, other.possibleValues) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.isRequired == null ? 43 : this.isRequired.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + (this.possibleValues == null ? 43 : this.possibleValues.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private StrategyParameterType type;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isRequired")
        private Boolean isRequired;
        @JsonProperty(value="defaultValue")
        private Object defaultValue;
        @JsonProperty(value="possibleValues")
        private List<Object> possibleValues;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(StrategyParameterType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.__explicitlySet__.add("isRequired");
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder possibleValues(List<Object> possibleValues) {
            this.possibleValues = possibleValues;
            this.__explicitlySet__.add("possibleValues");
            return this;
        }

        public StrategyParameter build() {
            StrategyParameter model = new StrategyParameter(this.name, this.type, this.description, this.isRequired, this.defaultValue, this.possibleValues);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StrategyParameter model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isRequired")) {
                this.isRequired(model.getIsRequired());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("possibleValues")) {
                this.possibleValues(model.getPossibleValues());
            }
            return this;
        }
    }
}

