/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.optimizer.model.Importance;
import com.oracle.bmc.optimizer.model.LifecycleState;
import com.oracle.bmc.optimizer.model.ResourceCount;
import com.oracle.bmc.optimizer.model.Status;
import com.oracle.bmc.optimizer.model.SupportedLevels;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Recommendation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="categoryId")
    private final String categoryId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="importance")
    private final Importance importance;
    @JsonProperty(value="resourceCounts")
    private final List<ResourceCount> resourceCounts;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="estimatedCostSaving")
    private final Double estimatedCostSaving;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="timeStatusBegin")
    private final Date timeStatusBegin;
    @JsonProperty(value="timeStatusEnd")
    private final Date timeStatusEnd;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="supportedLevels")
    private final SupportedLevels supportedLevels;
    @JsonProperty(value="extendedMetadata")
    private final Map<String, String> extendedMetadata;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "categoryId", "name", "description", "importance", "resourceCounts", "lifecycleState", "estimatedCostSaving", "status", "timeStatusBegin", "timeStatusEnd", "timeCreated", "timeUpdated", "supportedLevels", "extendedMetadata"})
    public Recommendation(String id, String compartmentId, String categoryId, String name, String description, Importance importance, List<ResourceCount> resourceCounts, LifecycleState lifecycleState, Double estimatedCostSaving, Status status, Date timeStatusBegin, Date timeStatusEnd, Date timeCreated, Date timeUpdated, SupportedLevels supportedLevels, Map<String, String> extendedMetadata) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.categoryId = categoryId;
        this.name = name;
        this.description = description;
        this.importance = importance;
        this.resourceCounts = resourceCounts;
        this.lifecycleState = lifecycleState;
        this.estimatedCostSaving = estimatedCostSaving;
        this.status = status;
        this.timeStatusBegin = timeStatusBegin;
        this.timeStatusEnd = timeStatusEnd;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.supportedLevels = supportedLevels;
        this.extendedMetadata = extendedMetadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Importance getImportance() {
        return this.importance;
    }

    public List<ResourceCount> getResourceCounts() {
        return this.resourceCounts;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Double getEstimatedCostSaving() {
        return this.estimatedCostSaving;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getTimeStatusBegin() {
        return this.timeStatusBegin;
    }

    public Date getTimeStatusEnd() {
        return this.timeStatusEnd;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public SupportedLevels getSupportedLevels() {
        return this.supportedLevels;
    }

    public Map<String, String> getExtendedMetadata() {
        return this.extendedMetadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Recommendation(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", categoryId=").append(String.valueOf(this.categoryId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", importance=").append(String.valueOf((Object)this.importance));
        sb.append(", resourceCounts=").append(String.valueOf(this.resourceCounts));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", estimatedCostSaving=").append(String.valueOf(this.estimatedCostSaving));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeStatusBegin=").append(String.valueOf(this.timeStatusBegin));
        sb.append(", timeStatusEnd=").append(String.valueOf(this.timeStatusEnd));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", supportedLevels=").append(String.valueOf((Object)this.supportedLevels));
        sb.append(", extendedMetadata=").append(String.valueOf(this.extendedMetadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.categoryId, other.categoryId) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.importance, (Object)other.importance) && Objects.equals(this.resourceCounts, other.resourceCounts) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.estimatedCostSaving, other.estimatedCostSaving) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeStatusBegin, other.timeStatusBegin) && Objects.equals(this.timeStatusEnd, other.timeStatusEnd) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.supportedLevels, (Object)other.supportedLevels) && Objects.equals(this.extendedMetadata, other.extendedMetadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.categoryId == null ? 43 : this.categoryId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.importance == null ? 43 : this.importance.hashCode());
        result = result * 59 + (this.resourceCounts == null ? 43 : this.resourceCounts.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.estimatedCostSaving == null ? 43 : this.estimatedCostSaving.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeStatusBegin == null ? 43 : this.timeStatusBegin.hashCode());
        result = result * 59 + (this.timeStatusEnd == null ? 43 : this.timeStatusEnd.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.supportedLevels == null ? 43 : this.supportedLevels.hashCode());
        result = result * 59 + (this.extendedMetadata == null ? 43 : this.extendedMetadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="categoryId")
        private String categoryId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="importance")
        private Importance importance;
        @JsonProperty(value="resourceCounts")
        private List<ResourceCount> resourceCounts;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="estimatedCostSaving")
        private Double estimatedCostSaving;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="timeStatusBegin")
        private Date timeStatusBegin;
        @JsonProperty(value="timeStatusEnd")
        private Date timeStatusEnd;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="supportedLevels")
        private SupportedLevels supportedLevels;
        @JsonProperty(value="extendedMetadata")
        private Map<String, String> extendedMetadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder categoryId(String categoryId) {
            this.categoryId = categoryId;
            this.__explicitlySet__.add("categoryId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder importance(Importance importance) {
            this.importance = importance;
            this.__explicitlySet__.add("importance");
            return this;
        }

        public Builder resourceCounts(List<ResourceCount> resourceCounts) {
            this.resourceCounts = resourceCounts;
            this.__explicitlySet__.add("resourceCounts");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder estimatedCostSaving(Double estimatedCostSaving) {
            this.estimatedCostSaving = estimatedCostSaving;
            this.__explicitlySet__.add("estimatedCostSaving");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeStatusBegin(Date timeStatusBegin) {
            this.timeStatusBegin = timeStatusBegin;
            this.__explicitlySet__.add("timeStatusBegin");
            return this;
        }

        public Builder timeStatusEnd(Date timeStatusEnd) {
            this.timeStatusEnd = timeStatusEnd;
            this.__explicitlySet__.add("timeStatusEnd");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder supportedLevels(SupportedLevels supportedLevels) {
            this.supportedLevels = supportedLevels;
            this.__explicitlySet__.add("supportedLevels");
            return this;
        }

        public Builder extendedMetadata(Map<String, String> extendedMetadata) {
            this.extendedMetadata = extendedMetadata;
            this.__explicitlySet__.add("extendedMetadata");
            return this;
        }

        public Recommendation build() {
            Recommendation model = new Recommendation(this.id, this.compartmentId, this.categoryId, this.name, this.description, this.importance, this.resourceCounts, this.lifecycleState, this.estimatedCostSaving, this.status, this.timeStatusBegin, this.timeStatusEnd, this.timeCreated, this.timeUpdated, this.supportedLevels, this.extendedMetadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Recommendation model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("categoryId")) {
                this.categoryId(model.getCategoryId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("importance")) {
                this.importance(model.getImportance());
            }
            if (model.wasPropertyExplicitlySet("resourceCounts")) {
                this.resourceCounts(model.getResourceCounts());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("estimatedCostSaving")) {
                this.estimatedCostSaving(model.getEstimatedCostSaving());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeStatusBegin")) {
                this.timeStatusBegin(model.getTimeStatusBegin());
            }
            if (model.wasPropertyExplicitlySet("timeStatusEnd")) {
                this.timeStatusEnd(model.getTimeStatusEnd());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("supportedLevels")) {
                this.supportedLevels(model.getSupportedLevels());
            }
            if (model.wasPropertyExplicitlySet("extendedMetadata")) {
                this.extendedMetadata(model.getExtendedMetadata());
            }
            return this;
        }
    }
}

