/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer;

import com.oracle.bmc.optimizer.Optimizer;
import com.oracle.bmc.optimizer.model.CategorySummary;
import com.oracle.bmc.optimizer.model.EnrollmentStatusSummary;
import com.oracle.bmc.optimizer.model.HistorySummary;
import com.oracle.bmc.optimizer.model.ProfileLevelSummary;
import com.oracle.bmc.optimizer.model.ProfileSummary;
import com.oracle.bmc.optimizer.model.QueryableFieldSummary;
import com.oracle.bmc.optimizer.model.RecommendationStrategySummary;
import com.oracle.bmc.optimizer.model.RecommendationSummary;
import com.oracle.bmc.optimizer.model.ResourceActionSummary;
import com.oracle.bmc.optimizer.model.WorkRequest;
import com.oracle.bmc.optimizer.model.WorkRequestError;
import com.oracle.bmc.optimizer.model.WorkRequestLogEntry;
import com.oracle.bmc.optimizer.requests.ListCategoriesRequest;
import com.oracle.bmc.optimizer.requests.ListEnrollmentStatusesRequest;
import com.oracle.bmc.optimizer.requests.ListHistoriesRequest;
import com.oracle.bmc.optimizer.requests.ListProfileLevelsRequest;
import com.oracle.bmc.optimizer.requests.ListProfilesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationStrategiesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.ListResourceActionQueryableFieldsRequest;
import com.oracle.bmc.optimizer.requests.ListResourceActionsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.optimizer.responses.ListCategoriesResponse;
import com.oracle.bmc.optimizer.responses.ListEnrollmentStatusesResponse;
import com.oracle.bmc.optimizer.responses.ListHistoriesResponse;
import com.oracle.bmc.optimizer.responses.ListProfileLevelsResponse;
import com.oracle.bmc.optimizer.responses.ListProfilesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationStrategiesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.ListResourceActionQueryableFieldsResponse;
import com.oracle.bmc.optimizer.responses.ListResourceActionsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OptimizerPaginators {
    private final Optimizer client;

    public OptimizerPaginators(Optimizer client) {
        this.client = client;
    }

    public Iterable<ListCategoriesResponse> listCategoriesResponseIterator(final ListCategoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCategoriesRequest.Builder>(){

            @Override
            public ListCategoriesRequest.Builder get() {
                return ListCategoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCategoriesResponse, String>(){

            @Override
            public String apply(ListCategoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCategoriesRequest.Builder>, ListCategoriesRequest>(){

            @Override
            public ListCategoriesRequest apply(RequestBuilderAndToken<ListCategoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCategoriesRequest, ListCategoriesResponse>(){

            @Override
            public ListCategoriesResponse apply(ListCategoriesRequest request) {
                return OptimizerPaginators.this.client.listCategories(request);
            }
        });
    }

    public Iterable<CategorySummary> listCategoriesRecordIterator(final ListCategoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCategoriesRequest.Builder>(){

            @Override
            public ListCategoriesRequest.Builder get() {
                return ListCategoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCategoriesResponse, String>(){

            @Override
            public String apply(ListCategoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCategoriesRequest.Builder>, ListCategoriesRequest>(){

            @Override
            public ListCategoriesRequest apply(RequestBuilderAndToken<ListCategoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCategoriesRequest, ListCategoriesResponse>(){

            @Override
            public ListCategoriesResponse apply(ListCategoriesRequest request) {
                return OptimizerPaginators.this.client.listCategories(request);
            }
        }, (Function)new Function<ListCategoriesResponse, List<CategorySummary>>(){

            @Override
            public List<CategorySummary> apply(ListCategoriesResponse response) {
                return response.getCategoryCollection().getItems();
            }
        });
    }

    public Iterable<ListEnrollmentStatusesResponse> listEnrollmentStatusesResponseIterator(final ListEnrollmentStatusesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEnrollmentStatusesRequest.Builder>(){

            @Override
            public ListEnrollmentStatusesRequest.Builder get() {
                return ListEnrollmentStatusesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEnrollmentStatusesResponse, String>(){

            @Override
            public String apply(ListEnrollmentStatusesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEnrollmentStatusesRequest.Builder>, ListEnrollmentStatusesRequest>(){

            @Override
            public ListEnrollmentStatusesRequest apply(RequestBuilderAndToken<ListEnrollmentStatusesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEnrollmentStatusesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEnrollmentStatusesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEnrollmentStatusesRequest, ListEnrollmentStatusesResponse>(){

            @Override
            public ListEnrollmentStatusesResponse apply(ListEnrollmentStatusesRequest request) {
                return OptimizerPaginators.this.client.listEnrollmentStatuses(request);
            }
        });
    }

    public Iterable<EnrollmentStatusSummary> listEnrollmentStatusesRecordIterator(final ListEnrollmentStatusesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEnrollmentStatusesRequest.Builder>(){

            @Override
            public ListEnrollmentStatusesRequest.Builder get() {
                return ListEnrollmentStatusesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEnrollmentStatusesResponse, String>(){

            @Override
            public String apply(ListEnrollmentStatusesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEnrollmentStatusesRequest.Builder>, ListEnrollmentStatusesRequest>(){

            @Override
            public ListEnrollmentStatusesRequest apply(RequestBuilderAndToken<ListEnrollmentStatusesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEnrollmentStatusesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEnrollmentStatusesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEnrollmentStatusesRequest, ListEnrollmentStatusesResponse>(){

            @Override
            public ListEnrollmentStatusesResponse apply(ListEnrollmentStatusesRequest request) {
                return OptimizerPaginators.this.client.listEnrollmentStatuses(request);
            }
        }, (Function)new Function<ListEnrollmentStatusesResponse, List<EnrollmentStatusSummary>>(){

            @Override
            public List<EnrollmentStatusSummary> apply(ListEnrollmentStatusesResponse response) {
                return response.getEnrollmentStatusCollection().getItems();
            }
        });
    }

    public Iterable<ListHistoriesResponse> listHistoriesResponseIterator(final ListHistoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHistoriesRequest.Builder>(){

            @Override
            public ListHistoriesRequest.Builder get() {
                return ListHistoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHistoriesResponse, String>(){

            @Override
            public String apply(ListHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHistoriesRequest.Builder>, ListHistoriesRequest>(){

            @Override
            public ListHistoriesRequest apply(RequestBuilderAndToken<ListHistoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHistoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHistoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHistoriesRequest, ListHistoriesResponse>(){

            @Override
            public ListHistoriesResponse apply(ListHistoriesRequest request) {
                return OptimizerPaginators.this.client.listHistories(request);
            }
        });
    }

    public Iterable<HistorySummary> listHistoriesRecordIterator(final ListHistoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHistoriesRequest.Builder>(){

            @Override
            public ListHistoriesRequest.Builder get() {
                return ListHistoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHistoriesResponse, String>(){

            @Override
            public String apply(ListHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHistoriesRequest.Builder>, ListHistoriesRequest>(){

            @Override
            public ListHistoriesRequest apply(RequestBuilderAndToken<ListHistoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHistoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHistoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHistoriesRequest, ListHistoriesResponse>(){

            @Override
            public ListHistoriesResponse apply(ListHistoriesRequest request) {
                return OptimizerPaginators.this.client.listHistories(request);
            }
        }, (Function)new Function<ListHistoriesResponse, List<HistorySummary>>(){

            @Override
            public List<HistorySummary> apply(ListHistoriesResponse response) {
                return response.getHistoryCollection().getItems();
            }
        });
    }

    public Iterable<ListProfileLevelsResponse> listProfileLevelsResponseIterator(final ListProfileLevelsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProfileLevelsRequest.Builder>(){

            @Override
            public ListProfileLevelsRequest.Builder get() {
                return ListProfileLevelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProfileLevelsResponse, String>(){

            @Override
            public String apply(ListProfileLevelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProfileLevelsRequest.Builder>, ListProfileLevelsRequest>(){

            @Override
            public ListProfileLevelsRequest apply(RequestBuilderAndToken<ListProfileLevelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProfileLevelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProfileLevelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProfileLevelsRequest, ListProfileLevelsResponse>(){

            @Override
            public ListProfileLevelsResponse apply(ListProfileLevelsRequest request) {
                return OptimizerPaginators.this.client.listProfileLevels(request);
            }
        });
    }

    public Iterable<ProfileLevelSummary> listProfileLevelsRecordIterator(final ListProfileLevelsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProfileLevelsRequest.Builder>(){

            @Override
            public ListProfileLevelsRequest.Builder get() {
                return ListProfileLevelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProfileLevelsResponse, String>(){

            @Override
            public String apply(ListProfileLevelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProfileLevelsRequest.Builder>, ListProfileLevelsRequest>(){

            @Override
            public ListProfileLevelsRequest apply(RequestBuilderAndToken<ListProfileLevelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProfileLevelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProfileLevelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProfileLevelsRequest, ListProfileLevelsResponse>(){

            @Override
            public ListProfileLevelsResponse apply(ListProfileLevelsRequest request) {
                return OptimizerPaginators.this.client.listProfileLevels(request);
            }
        }, (Function)new Function<ListProfileLevelsResponse, List<ProfileLevelSummary>>(){

            @Override
            public List<ProfileLevelSummary> apply(ListProfileLevelsResponse response) {
                return response.getProfileLevelCollection().getItems();
            }
        });
    }

    public Iterable<ListProfilesResponse> listProfilesResponseIterator(final ListProfilesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProfilesRequest.Builder>(){

            @Override
            public ListProfilesRequest.Builder get() {
                return ListProfilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProfilesResponse, String>(){

            @Override
            public String apply(ListProfilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProfilesRequest.Builder>, ListProfilesRequest>(){

            @Override
            public ListProfilesRequest apply(RequestBuilderAndToken<ListProfilesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProfilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProfilesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProfilesRequest, ListProfilesResponse>(){

            @Override
            public ListProfilesResponse apply(ListProfilesRequest request) {
                return OptimizerPaginators.this.client.listProfiles(request);
            }
        });
    }

    public Iterable<ProfileSummary> listProfilesRecordIterator(final ListProfilesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProfilesRequest.Builder>(){

            @Override
            public ListProfilesRequest.Builder get() {
                return ListProfilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProfilesResponse, String>(){

            @Override
            public String apply(ListProfilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProfilesRequest.Builder>, ListProfilesRequest>(){

            @Override
            public ListProfilesRequest apply(RequestBuilderAndToken<ListProfilesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProfilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProfilesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProfilesRequest, ListProfilesResponse>(){

            @Override
            public ListProfilesResponse apply(ListProfilesRequest request) {
                return OptimizerPaginators.this.client.listProfiles(request);
            }
        }, (Function)new Function<ListProfilesResponse, List<ProfileSummary>>(){

            @Override
            public List<ProfileSummary> apply(ListProfilesResponse response) {
                return response.getProfileCollection().getItems();
            }
        });
    }

    public Iterable<ListRecommendationStrategiesResponse> listRecommendationStrategiesResponseIterator(final ListRecommendationStrategiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRecommendationStrategiesRequest.Builder>(){

            @Override
            public ListRecommendationStrategiesRequest.Builder get() {
                return ListRecommendationStrategiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecommendationStrategiesResponse, String>(){

            @Override
            public String apply(ListRecommendationStrategiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecommendationStrategiesRequest.Builder>, ListRecommendationStrategiesRequest>(){

            @Override
            public ListRecommendationStrategiesRequest apply(RequestBuilderAndToken<ListRecommendationStrategiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecommendationStrategiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecommendationStrategiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecommendationStrategiesRequest, ListRecommendationStrategiesResponse>(){

            @Override
            public ListRecommendationStrategiesResponse apply(ListRecommendationStrategiesRequest request) {
                return OptimizerPaginators.this.client.listRecommendationStrategies(request);
            }
        });
    }

    public Iterable<RecommendationStrategySummary> listRecommendationStrategiesRecordIterator(final ListRecommendationStrategiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRecommendationStrategiesRequest.Builder>(){

            @Override
            public ListRecommendationStrategiesRequest.Builder get() {
                return ListRecommendationStrategiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecommendationStrategiesResponse, String>(){

            @Override
            public String apply(ListRecommendationStrategiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecommendationStrategiesRequest.Builder>, ListRecommendationStrategiesRequest>(){

            @Override
            public ListRecommendationStrategiesRequest apply(RequestBuilderAndToken<ListRecommendationStrategiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecommendationStrategiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecommendationStrategiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecommendationStrategiesRequest, ListRecommendationStrategiesResponse>(){

            @Override
            public ListRecommendationStrategiesResponse apply(ListRecommendationStrategiesRequest request) {
                return OptimizerPaginators.this.client.listRecommendationStrategies(request);
            }
        }, (Function)new Function<ListRecommendationStrategiesResponse, List<RecommendationStrategySummary>>(){

            @Override
            public List<RecommendationStrategySummary> apply(ListRecommendationStrategiesResponse response) {
                return response.getRecommendationStrategyCollection().getItems();
            }
        });
    }

    public Iterable<ListRecommendationsResponse> listRecommendationsResponseIterator(final ListRecommendationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRecommendationsRequest.Builder>(){

            @Override
            public ListRecommendationsRequest.Builder get() {
                return ListRecommendationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecommendationsResponse, String>(){

            @Override
            public String apply(ListRecommendationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecommendationsRequest.Builder>, ListRecommendationsRequest>(){

            @Override
            public ListRecommendationsRequest apply(RequestBuilderAndToken<ListRecommendationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecommendationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecommendationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecommendationsRequest, ListRecommendationsResponse>(){

            @Override
            public ListRecommendationsResponse apply(ListRecommendationsRequest request) {
                return OptimizerPaginators.this.client.listRecommendations(request);
            }
        });
    }

    public Iterable<RecommendationSummary> listRecommendationsRecordIterator(final ListRecommendationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRecommendationsRequest.Builder>(){

            @Override
            public ListRecommendationsRequest.Builder get() {
                return ListRecommendationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecommendationsResponse, String>(){

            @Override
            public String apply(ListRecommendationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecommendationsRequest.Builder>, ListRecommendationsRequest>(){

            @Override
            public ListRecommendationsRequest apply(RequestBuilderAndToken<ListRecommendationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecommendationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecommendationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecommendationsRequest, ListRecommendationsResponse>(){

            @Override
            public ListRecommendationsResponse apply(ListRecommendationsRequest request) {
                return OptimizerPaginators.this.client.listRecommendations(request);
            }
        }, (Function)new Function<ListRecommendationsResponse, List<RecommendationSummary>>(){

            @Override
            public List<RecommendationSummary> apply(ListRecommendationsResponse response) {
                return response.getRecommendationCollection().getItems();
            }
        });
    }

    public Iterable<ListResourceActionQueryableFieldsResponse> listResourceActionQueryableFieldsResponseIterator(final ListResourceActionQueryableFieldsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResourceActionQueryableFieldsRequest.Builder>(){

            @Override
            public ListResourceActionQueryableFieldsRequest.Builder get() {
                return ListResourceActionQueryableFieldsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceActionQueryableFieldsResponse, String>(){

            @Override
            public String apply(ListResourceActionQueryableFieldsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceActionQueryableFieldsRequest.Builder>, ListResourceActionQueryableFieldsRequest>(){

            @Override
            public ListResourceActionQueryableFieldsRequest apply(RequestBuilderAndToken<ListResourceActionQueryableFieldsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceActionQueryableFieldsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceActionQueryableFieldsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceActionQueryableFieldsRequest, ListResourceActionQueryableFieldsResponse>(){

            @Override
            public ListResourceActionQueryableFieldsResponse apply(ListResourceActionQueryableFieldsRequest request) {
                return OptimizerPaginators.this.client.listResourceActionQueryableFields(request);
            }
        });
    }

    public Iterable<QueryableFieldSummary> listResourceActionQueryableFieldsRecordIterator(final ListResourceActionQueryableFieldsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResourceActionQueryableFieldsRequest.Builder>(){

            @Override
            public ListResourceActionQueryableFieldsRequest.Builder get() {
                return ListResourceActionQueryableFieldsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceActionQueryableFieldsResponse, String>(){

            @Override
            public String apply(ListResourceActionQueryableFieldsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceActionQueryableFieldsRequest.Builder>, ListResourceActionQueryableFieldsRequest>(){

            @Override
            public ListResourceActionQueryableFieldsRequest apply(RequestBuilderAndToken<ListResourceActionQueryableFieldsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceActionQueryableFieldsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceActionQueryableFieldsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceActionQueryableFieldsRequest, ListResourceActionQueryableFieldsResponse>(){

            @Override
            public ListResourceActionQueryableFieldsResponse apply(ListResourceActionQueryableFieldsRequest request) {
                return OptimizerPaginators.this.client.listResourceActionQueryableFields(request);
            }
        }, (Function)new Function<ListResourceActionQueryableFieldsResponse, List<QueryableFieldSummary>>(){

            @Override
            public List<QueryableFieldSummary> apply(ListResourceActionQueryableFieldsResponse response) {
                return response.getQueryableFieldCollection().getItems();
            }
        });
    }

    public Iterable<ListResourceActionsResponse> listResourceActionsResponseIterator(final ListResourceActionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResourceActionsRequest.Builder>(){

            @Override
            public ListResourceActionsRequest.Builder get() {
                return ListResourceActionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceActionsResponse, String>(){

            @Override
            public String apply(ListResourceActionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceActionsRequest.Builder>, ListResourceActionsRequest>(){

            @Override
            public ListResourceActionsRequest apply(RequestBuilderAndToken<ListResourceActionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceActionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceActionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceActionsRequest, ListResourceActionsResponse>(){

            @Override
            public ListResourceActionsResponse apply(ListResourceActionsRequest request) {
                return OptimizerPaginators.this.client.listResourceActions(request);
            }
        });
    }

    public Iterable<ResourceActionSummary> listResourceActionsRecordIterator(final ListResourceActionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResourceActionsRequest.Builder>(){

            @Override
            public ListResourceActionsRequest.Builder get() {
                return ListResourceActionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceActionsResponse, String>(){

            @Override
            public String apply(ListResourceActionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceActionsRequest.Builder>, ListResourceActionsRequest>(){

            @Override
            public ListResourceActionsRequest apply(RequestBuilderAndToken<ListResourceActionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceActionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceActionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceActionsRequest, ListResourceActionsResponse>(){

            @Override
            public ListResourceActionsResponse apply(ListResourceActionsRequest request) {
                return OptimizerPaginators.this.client.listResourceActions(request);
            }
        }, (Function)new Function<ListResourceActionsResponse, List<ResourceActionSummary>>(){

            @Override
            public List<ResourceActionSummary> apply(ListResourceActionsResponse response) {
                return response.getResourceActionCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            @Override
            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

