/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.responses;

import com.oracle.bmc.opsi.model.DatabaseInsightsCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListDatabaseInsightsResponse
extends BmcResponse {
    private String opcRequestId;
    private Integer opcTotalItems;
    private String opcNextPage;
    private DatabaseInsightsCollection databaseInsightsCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public DatabaseInsightsCollection getDatabaseInsightsCollection() {
        return this.databaseInsightsCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcTotalItems", "opcNextPage", "databaseInsightsCollection"})
    private ListDatabaseInsightsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, Integer opcTotalItems, String opcNextPage, DatabaseInsightsCollection databaseInsightsCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcTotalItems = opcTotalItems;
        this.opcNextPage = opcNextPage;
        this.databaseInsightsCollection = databaseInsightsCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcTotalItems=").append(String.valueOf(this.opcTotalItems));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",databaseInsightsCollection=").append(String.valueOf((Object)this.databaseInsightsCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDatabaseInsightsResponse)) {
            return false;
        }
        ListDatabaseInsightsResponse other = (ListDatabaseInsightsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcTotalItems, other.opcTotalItems) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.databaseInsightsCollection, (Object)other.databaseInsightsCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcTotalItems == null ? 43 : this.opcTotalItems.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.databaseInsightsCollection == null ? 43 : this.databaseInsightsCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListDatabaseInsightsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private Integer opcTotalItems;
        private String opcNextPage;
        private DatabaseInsightsCollection databaseInsightsCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder databaseInsightsCollection(DatabaseInsightsCollection databaseInsightsCollection) {
            this.databaseInsightsCollection = databaseInsightsCollection;
            return this;
        }

        public Builder copy(ListDatabaseInsightsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcTotalItems(o.getOpcTotalItems());
            this.opcNextPage(o.getOpcNextPage());
            this.databaseInsightsCollection(o.getDatabaseInsightsCollection());
            return this;
        }

        public ListDatabaseInsightsResponse build() {
            return new ListDatabaseInsightsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcTotalItems, this.opcNextPage, this.databaseInsightsCollection);
        }
    }
}

