/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.opsi.model.UpdateHostInsightDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateHostInsightRequest
extends BmcRequest<UpdateHostInsightDetails> {
    private String hostInsightId;
    private UpdateHostInsightDetails updateHostInsightDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getHostInsightId() {
        return this.hostInsightId;
    }

    public UpdateHostInsightDetails getUpdateHostInsightDetails() {
        return this.updateHostInsightDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateHostInsightDetails getBody$() {
        return this.updateHostInsightDetails;
    }

    public Builder toBuilder() {
        return new Builder().hostInsightId(this.hostInsightId).updateHostInsightDetails(this.updateHostInsightDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",hostInsightId=").append(String.valueOf(this.hostInsightId));
        sb.append(",updateHostInsightDetails=").append(String.valueOf((Object)this.updateHostInsightDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateHostInsightRequest)) {
            return false;
        }
        UpdateHostInsightRequest other = (UpdateHostInsightRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.hostInsightId, other.hostInsightId) && Objects.equals((Object)this.updateHostInsightDetails, (Object)other.updateHostInsightDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hostInsightId == null ? 43 : this.hostInsightId.hashCode());
        result = result * 59 + (this.updateHostInsightDetails == null ? 43 : this.updateHostInsightDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateHostInsightRequest, UpdateHostInsightDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String hostInsightId = null;
        private UpdateHostInsightDetails updateHostInsightDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder hostInsightId(String hostInsightId) {
            this.hostInsightId = hostInsightId;
            return this;
        }

        public Builder updateHostInsightDetails(UpdateHostInsightDetails updateHostInsightDetails) {
            this.updateHostInsightDetails = updateHostInsightDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateHostInsightRequest o) {
            this.hostInsightId(o.getHostInsightId());
            this.updateHostInsightDetails(o.getUpdateHostInsightDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateHostInsightRequest build() {
            UpdateHostInsightRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateHostInsightDetails body) {
            this.updateHostInsightDetails(body);
            return this;
        }

        public UpdateHostInsightRequest buildWithoutInvocationCallback() {
            UpdateHostInsightRequest request = new UpdateHostInsightRequest();
            request.hostInsightId = this.hostInsightId;
            request.updateHostInsightDetails = this.updateHostInsightDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

