/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.LifecycleState;
import com.oracle.bmc.opsi.model.ResourceStatus;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListExadataInsightsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String enterpriseManagerBridgeId;
    private List<String> id;
    private List<ResourceStatus> status;
    private List<LifecycleState> lifecycleState;
    private List<String> exadataType;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private Boolean compartmentIdInSubtree;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getEnterpriseManagerBridgeId() {
        return this.enterpriseManagerBridgeId;
    }

    public List<String> getId() {
        return this.id;
    }

    public List<ResourceStatus> getStatus() {
        return this.status;
    }

    public List<LifecycleState> getLifecycleState() {
        return this.lifecycleState;
    }

    public List<String> getExadataType() {
        return this.exadataType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).enterpriseManagerBridgeId(this.enterpriseManagerBridgeId).id(this.id).status(this.status).lifecycleState(this.lifecycleState).exadataType(this.exadataType).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).compartmentIdInSubtree(this.compartmentIdInSubtree).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",enterpriseManagerBridgeId=").append(String.valueOf(this.enterpriseManagerBridgeId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(",exadataType=").append(String.valueOf(this.exadataType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListExadataInsightsRequest)) {
            return false;
        }
        ListExadataInsightsRequest other = (ListExadataInsightsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.enterpriseManagerBridgeId, other.enterpriseManagerBridgeId) && Objects.equals(this.id, other.id) && Objects.equals(this.status, other.status) && Objects.equals(this.lifecycleState, other.lifecycleState) && Objects.equals(this.exadataType, other.exadataType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.enterpriseManagerBridgeId == null ? 43 : this.enterpriseManagerBridgeId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.exadataType == null ? 43 : this.exadataType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListExadataInsightsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String enterpriseManagerBridgeId = null;
        private List<String> id = null;
        private List<ResourceStatus> status = null;
        private List<LifecycleState> lifecycleState = null;
        private List<String> exadataType = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private Boolean compartmentIdInSubtree = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder enterpriseManagerBridgeId(String enterpriseManagerBridgeId) {
            this.enterpriseManagerBridgeId = enterpriseManagerBridgeId;
            return this;
        }

        public Builder id(List<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String singularValue) {
            return this.id(Arrays.asList(singularValue));
        }

        public Builder status(List<ResourceStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ResourceStatus singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder lifecycleState(List<LifecycleState> lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lifecycleState(LifecycleState singularValue) {
            return this.lifecycleState(Arrays.asList(singularValue));
        }

        public Builder exadataType(List<String> exadataType) {
            this.exadataType = exadataType;
            return this;
        }

        public Builder exadataType(String singularValue) {
            return this.exadataType(Arrays.asList(singularValue));
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListExadataInsightsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.enterpriseManagerBridgeId(o.getEnterpriseManagerBridgeId());
            this.id(o.getId());
            this.status(o.getStatus());
            this.lifecycleState(o.getLifecycleState());
            this.exadataType(o.getExadataType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListExadataInsightsRequest build() {
            ListExadataInsightsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListExadataInsightsRequest buildWithoutInvocationCallback() {
            ListExadataInsightsRequest request = new ListExadataInsightsRequest();
            request.compartmentId = this.compartmentId;
            request.enterpriseManagerBridgeId = this.enterpriseManagerBridgeId;
            request.id = this.id;
            request.status = this.status;
            request.lifecycleState = this.lifecycleState;
            request.exadataType = this.exadataType;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        ExadataName("exadataName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

