/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOpsiDataObjectRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opsiDataObjectIdentifier;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpsiDataObjectIdentifier() {
        return this.opsiDataObjectIdentifier;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).opsiDataObjectIdentifier(this.opsiDataObjectIdentifier).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opsiDataObjectIdentifier=").append(String.valueOf(this.opsiDataObjectIdentifier));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOpsiDataObjectRequest)) {
            return false;
        }
        GetOpsiDataObjectRequest other = (GetOpsiDataObjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opsiDataObjectIdentifier, other.opsiDataObjectIdentifier) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opsiDataObjectIdentifier == null ? 43 : this.opsiDataObjectIdentifier.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOpsiDataObjectRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String opsiDataObjectIdentifier = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opsiDataObjectIdentifier(String opsiDataObjectIdentifier) {
            this.opsiDataObjectIdentifier = opsiDataObjectIdentifier;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOpsiDataObjectRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opsiDataObjectIdentifier(o.getOpsiDataObjectIdentifier());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOpsiDataObjectRequest build() {
            GetOpsiDataObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOpsiDataObjectRequest buildWithoutInvocationCallback() {
            GetOpsiDataObjectRequest request = new GetOpsiDataObjectRequest();
            request.compartmentId = this.compartmentId;
            request.opsiDataObjectIdentifier = this.opsiDataObjectIdentifier;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

