/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.HistoricalDataItem;
import com.oracle.bmc.opsi.model.ProjectedDataItem;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SummarizeExadataInsightResourceForecastTrendAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeIntervalStart")
    private final Date timeIntervalStart;
    @JsonProperty(value="timeIntervalEnd")
    private final Date timeIntervalEnd;
    @JsonProperty(value="exadataResourceMetric")
    private final ExadataResourceMetric exadataResourceMetric;
    @JsonProperty(value="exadataResourceType")
    private final ExadataResourceType exadataResourceType;
    @JsonProperty(value="usageUnit")
    private final UsageUnit usageUnit;
    @JsonProperty(value="pattern")
    private final Pattern pattern;
    @JsonProperty(value="daysToReachCapacity")
    private final Integer daysToReachCapacity;
    @JsonProperty(value="historicalData")
    private final List<HistoricalDataItem> historicalData;
    @JsonProperty(value="projectedData")
    private final List<ProjectedDataItem> projectedData;

    @Deprecated
    @ConstructorProperties(value={"timeIntervalStart", "timeIntervalEnd", "exadataResourceMetric", "exadataResourceType", "usageUnit", "pattern", "daysToReachCapacity", "historicalData", "projectedData"})
    public SummarizeExadataInsightResourceForecastTrendAggregation(Date timeIntervalStart, Date timeIntervalEnd, ExadataResourceMetric exadataResourceMetric, ExadataResourceType exadataResourceType, UsageUnit usageUnit, Pattern pattern, Integer daysToReachCapacity, List<HistoricalDataItem> historicalData, List<ProjectedDataItem> projectedData) {
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.exadataResourceMetric = exadataResourceMetric;
        this.exadataResourceType = exadataResourceType;
        this.usageUnit = usageUnit;
        this.pattern = pattern;
        this.daysToReachCapacity = daysToReachCapacity;
        this.historicalData = historicalData;
        this.projectedData = projectedData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public ExadataResourceMetric getExadataResourceMetric() {
        return this.exadataResourceMetric;
    }

    public ExadataResourceType getExadataResourceType() {
        return this.exadataResourceType;
    }

    public UsageUnit getUsageUnit() {
        return this.usageUnit;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Integer getDaysToReachCapacity() {
        return this.daysToReachCapacity;
    }

    public List<HistoricalDataItem> getHistoricalData() {
        return this.historicalData;
    }

    public List<ProjectedDataItem> getProjectedData() {
        return this.projectedData;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SummarizeExadataInsightResourceForecastTrendAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(", timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(", exadataResourceMetric=").append(String.valueOf((Object)this.exadataResourceMetric));
        sb.append(", exadataResourceType=").append(String.valueOf((Object)this.exadataResourceType));
        sb.append(", usageUnit=").append(String.valueOf((Object)this.usageUnit));
        sb.append(", pattern=").append(String.valueOf((Object)this.pattern));
        sb.append(", daysToReachCapacity=").append(String.valueOf(this.daysToReachCapacity));
        sb.append(", historicalData=").append(String.valueOf(this.historicalData));
        sb.append(", projectedData=").append(String.valueOf(this.projectedData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeExadataInsightResourceForecastTrendAggregation)) {
            return false;
        }
        SummarizeExadataInsightResourceForecastTrendAggregation other = (SummarizeExadataInsightResourceForecastTrendAggregation)((Object)o);
        return Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals((Object)this.exadataResourceMetric, (Object)other.exadataResourceMetric) && Objects.equals((Object)this.exadataResourceType, (Object)other.exadataResourceType) && Objects.equals((Object)this.usageUnit, (Object)other.usageUnit) && Objects.equals((Object)this.pattern, (Object)other.pattern) && Objects.equals(this.daysToReachCapacity, other.daysToReachCapacity) && Objects.equals(this.historicalData, other.historicalData) && Objects.equals(this.projectedData, other.projectedData) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.exadataResourceMetric == null ? 43 : this.exadataResourceMetric.hashCode());
        result = result * 59 + (this.exadataResourceType == null ? 43 : this.exadataResourceType.hashCode());
        result = result * 59 + (this.usageUnit == null ? 43 : this.usageUnit.hashCode());
        result = result * 59 + (this.pattern == null ? 43 : this.pattern.hashCode());
        result = result * 59 + (this.daysToReachCapacity == null ? 43 : this.daysToReachCapacity.hashCode());
        result = result * 59 + (this.historicalData == null ? 43 : this.historicalData.hashCode());
        result = result * 59 + (this.projectedData == null ? 43 : this.projectedData.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Pattern implements BmcEnum
    {
        Linear("LINEAR"),
        MonthlySeasons("MONTHLY_SEASONS"),
        MonthlyAndYearlySeasons("MONTHLY_AND_YEARLY_SEASONS"),
        WeeklySeasons("WEEKLY_SEASONS"),
        WeeklyAndMonthlySeasons("WEEKLY_AND_MONTHLY_SEASONS"),
        WeeklyMonthlyAndYearlySeasons("WEEKLY_MONTHLY_AND_YEARLY_SEASONS"),
        WeeklyAndYearlySeasons("WEEKLY_AND_YEARLY_SEASONS"),
        YearlySeasons("YEARLY_SEASONS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Pattern> map;

        private Pattern(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Pattern create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Pattern', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Pattern.class);
            map = new HashMap<String, Pattern>();
            for (Pattern v : Pattern.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UsageUnit implements BmcEnum
    {
        Cores("CORES"),
        Gb("GB"),
        Mbps("MBPS"),
        Iops("IOPS"),
        Percent("PERCENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UsageUnit> map;

        private UsageUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UsageUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UsageUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UsageUnit.class);
            map = new HashMap<String, UsageUnit>();
            for (UsageUnit v : UsageUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExadataResourceType implements BmcEnum
    {
        Database("DATABASE"),
        Host("HOST"),
        StorageServer("STORAGE_SERVER"),
        Diskgroup("DISKGROUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExadataResourceType> map;

        private ExadataResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExadataResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExadataResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExadataResourceType.class);
            map = new HashMap<String, ExadataResourceType>();
            for (ExadataResourceType v : ExadataResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExadataResourceMetric implements BmcEnum
    {
        Cpu("CPU"),
        Storage("STORAGE"),
        Io("IO"),
        Memory("MEMORY"),
        Iops("IOPS"),
        Throughput("THROUGHPUT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExadataResourceMetric> map;

        private ExadataResourceMetric(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExadataResourceMetric create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExadataResourceMetric', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExadataResourceMetric.class);
            map = new HashMap<String, ExadataResourceMetric>();
            for (ExadataResourceMetric v : ExadataResourceMetric.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeIntervalStart")
        private Date timeIntervalStart;
        @JsonProperty(value="timeIntervalEnd")
        private Date timeIntervalEnd;
        @JsonProperty(value="exadataResourceMetric")
        private ExadataResourceMetric exadataResourceMetric;
        @JsonProperty(value="exadataResourceType")
        private ExadataResourceType exadataResourceType;
        @JsonProperty(value="usageUnit")
        private UsageUnit usageUnit;
        @JsonProperty(value="pattern")
        private Pattern pattern;
        @JsonProperty(value="daysToReachCapacity")
        private Integer daysToReachCapacity;
        @JsonProperty(value="historicalData")
        private List<HistoricalDataItem> historicalData;
        @JsonProperty(value="projectedData")
        private List<ProjectedDataItem> projectedData;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            this.__explicitlySet__.add("timeIntervalStart");
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            this.__explicitlySet__.add("timeIntervalEnd");
            return this;
        }

        public Builder exadataResourceMetric(ExadataResourceMetric exadataResourceMetric) {
            this.exadataResourceMetric = exadataResourceMetric;
            this.__explicitlySet__.add("exadataResourceMetric");
            return this;
        }

        public Builder exadataResourceType(ExadataResourceType exadataResourceType) {
            this.exadataResourceType = exadataResourceType;
            this.__explicitlySet__.add("exadataResourceType");
            return this;
        }

        public Builder usageUnit(UsageUnit usageUnit) {
            this.usageUnit = usageUnit;
            this.__explicitlySet__.add("usageUnit");
            return this;
        }

        public Builder pattern(Pattern pattern) {
            this.pattern = pattern;
            this.__explicitlySet__.add("pattern");
            return this;
        }

        public Builder daysToReachCapacity(Integer daysToReachCapacity) {
            this.daysToReachCapacity = daysToReachCapacity;
            this.__explicitlySet__.add("daysToReachCapacity");
            return this;
        }

        public Builder historicalData(List<HistoricalDataItem> historicalData) {
            this.historicalData = historicalData;
            this.__explicitlySet__.add("historicalData");
            return this;
        }

        public Builder projectedData(List<ProjectedDataItem> projectedData) {
            this.projectedData = projectedData;
            this.__explicitlySet__.add("projectedData");
            return this;
        }

        public SummarizeExadataInsightResourceForecastTrendAggregation build() {
            SummarizeExadataInsightResourceForecastTrendAggregation model = new SummarizeExadataInsightResourceForecastTrendAggregation(this.timeIntervalStart, this.timeIntervalEnd, this.exadataResourceMetric, this.exadataResourceType, this.usageUnit, this.pattern, this.daysToReachCapacity, this.historicalData, this.projectedData);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SummarizeExadataInsightResourceForecastTrendAggregation model) {
            if (model.wasPropertyExplicitlySet("timeIntervalStart")) {
                this.timeIntervalStart(model.getTimeIntervalStart());
            }
            if (model.wasPropertyExplicitlySet("timeIntervalEnd")) {
                this.timeIntervalEnd(model.getTimeIntervalEnd());
            }
            if (model.wasPropertyExplicitlySet("exadataResourceMetric")) {
                this.exadataResourceMetric(model.getExadataResourceMetric());
            }
            if (model.wasPropertyExplicitlySet("exadataResourceType")) {
                this.exadataResourceType(model.getExadataResourceType());
            }
            if (model.wasPropertyExplicitlySet("usageUnit")) {
                this.usageUnit(model.getUsageUnit());
            }
            if (model.wasPropertyExplicitlySet("pattern")) {
                this.pattern(model.getPattern());
            }
            if (model.wasPropertyExplicitlySet("daysToReachCapacity")) {
                this.daysToReachCapacity(model.getDaysToReachCapacity());
            }
            if (model.wasPropertyExplicitlySet("historicalData")) {
                this.historicalData(model.getHistoricalData());
            }
            if (model.wasPropertyExplicitlySet("projectedData")) {
                this.projectedData(model.getProjectedData());
            }
            return this;
        }
    }
}

