/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlPlanInsightAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="planHash")
    private final Long planHash;
    @JsonProperty(value="ioTimeInSec")
    private final Double ioTimeInSec;
    @JsonProperty(value="cpuTimeInSec")
    private final Double cpuTimeInSec;
    @JsonProperty(value="inefficientWaitTimeInSec")
    private final Double inefficientWaitTimeInSec;
    @JsonProperty(value="executionsCount")
    private final Long executionsCount;

    @Deprecated
    @ConstructorProperties(value={"planHash", "ioTimeInSec", "cpuTimeInSec", "inefficientWaitTimeInSec", "executionsCount"})
    public SqlPlanInsightAggregation(Long planHash, Double ioTimeInSec, Double cpuTimeInSec, Double inefficientWaitTimeInSec, Long executionsCount) {
        this.planHash = planHash;
        this.ioTimeInSec = ioTimeInSec;
        this.cpuTimeInSec = cpuTimeInSec;
        this.inefficientWaitTimeInSec = inefficientWaitTimeInSec;
        this.executionsCount = executionsCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getPlanHash() {
        return this.planHash;
    }

    public Double getIoTimeInSec() {
        return this.ioTimeInSec;
    }

    public Double getCpuTimeInSec() {
        return this.cpuTimeInSec;
    }

    public Double getInefficientWaitTimeInSec() {
        return this.inefficientWaitTimeInSec;
    }

    public Long getExecutionsCount() {
        return this.executionsCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlPlanInsightAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("planHash=").append(String.valueOf(this.planHash));
        sb.append(", ioTimeInSec=").append(String.valueOf(this.ioTimeInSec));
        sb.append(", cpuTimeInSec=").append(String.valueOf(this.cpuTimeInSec));
        sb.append(", inefficientWaitTimeInSec=").append(String.valueOf(this.inefficientWaitTimeInSec));
        sb.append(", executionsCount=").append(String.valueOf(this.executionsCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlPlanInsightAggregation)) {
            return false;
        }
        SqlPlanInsightAggregation other = (SqlPlanInsightAggregation)((Object)o);
        return Objects.equals(this.planHash, other.planHash) && Objects.equals(this.ioTimeInSec, other.ioTimeInSec) && Objects.equals(this.cpuTimeInSec, other.cpuTimeInSec) && Objects.equals(this.inefficientWaitTimeInSec, other.inefficientWaitTimeInSec) && Objects.equals(this.executionsCount, other.executionsCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.planHash == null ? 43 : this.planHash.hashCode());
        result = result * 59 + (this.ioTimeInSec == null ? 43 : this.ioTimeInSec.hashCode());
        result = result * 59 + (this.cpuTimeInSec == null ? 43 : this.cpuTimeInSec.hashCode());
        result = result * 59 + (this.inefficientWaitTimeInSec == null ? 43 : this.inefficientWaitTimeInSec.hashCode());
        result = result * 59 + (this.executionsCount == null ? 43 : this.executionsCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="planHash")
        private Long planHash;
        @JsonProperty(value="ioTimeInSec")
        private Double ioTimeInSec;
        @JsonProperty(value="cpuTimeInSec")
        private Double cpuTimeInSec;
        @JsonProperty(value="inefficientWaitTimeInSec")
        private Double inefficientWaitTimeInSec;
        @JsonProperty(value="executionsCount")
        private Long executionsCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder planHash(Long planHash) {
            this.planHash = planHash;
            this.__explicitlySet__.add("planHash");
            return this;
        }

        public Builder ioTimeInSec(Double ioTimeInSec) {
            this.ioTimeInSec = ioTimeInSec;
            this.__explicitlySet__.add("ioTimeInSec");
            return this;
        }

        public Builder cpuTimeInSec(Double cpuTimeInSec) {
            this.cpuTimeInSec = cpuTimeInSec;
            this.__explicitlySet__.add("cpuTimeInSec");
            return this;
        }

        public Builder inefficientWaitTimeInSec(Double inefficientWaitTimeInSec) {
            this.inefficientWaitTimeInSec = inefficientWaitTimeInSec;
            this.__explicitlySet__.add("inefficientWaitTimeInSec");
            return this;
        }

        public Builder executionsCount(Long executionsCount) {
            this.executionsCount = executionsCount;
            this.__explicitlySet__.add("executionsCount");
            return this;
        }

        public SqlPlanInsightAggregation build() {
            SqlPlanInsightAggregation model = new SqlPlanInsightAggregation(this.planHash, this.ioTimeInSec, this.cpuTimeInSec, this.inefficientWaitTimeInSec, this.executionsCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlPlanInsightAggregation model) {
            if (model.wasPropertyExplicitlySet("planHash")) {
                this.planHash(model.getPlanHash());
            }
            if (model.wasPropertyExplicitlySet("ioTimeInSec")) {
                this.ioTimeInSec(model.getIoTimeInSec());
            }
            if (model.wasPropertyExplicitlySet("cpuTimeInSec")) {
                this.cpuTimeInSec(model.getCpuTimeInSec());
            }
            if (model.wasPropertyExplicitlySet("inefficientWaitTimeInSec")) {
                this.inefficientWaitTimeInSec(model.getInefficientWaitTimeInSec());
            }
            if (model.wasPropertyExplicitlySet("executionsCount")) {
                this.executionsCount(model.getExecutionsCount());
            }
            return this;
        }
    }
}

