/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlInsightThresholds
extends ExplicitlySetBmcModel {
    @JsonProperty(value="degradationInPct")
    private final Integer degradationInPct;
    @JsonProperty(value="variability")
    private final Float variability;
    @JsonProperty(value="inefficiencyInPct")
    private final Integer inefficiencyInPct;
    @JsonProperty(value="increaseInIOInPct")
    private final Integer increaseInIOInPct;
    @JsonProperty(value="increaseInCPUInPct")
    private final Integer increaseInCPUInPct;
    @JsonProperty(value="increaseInInefficientWaitInPct")
    private final Integer increaseInInefficientWaitInPct;
    @JsonProperty(value="improvedInPct")
    private final Integer improvedInPct;

    @Deprecated
    @ConstructorProperties(value={"degradationInPct", "variability", "inefficiencyInPct", "increaseInIOInPct", "increaseInCPUInPct", "increaseInInefficientWaitInPct", "improvedInPct"})
    public SqlInsightThresholds(Integer degradationInPct, Float variability, Integer inefficiencyInPct, Integer increaseInIOInPct, Integer increaseInCPUInPct, Integer increaseInInefficientWaitInPct, Integer improvedInPct) {
        this.degradationInPct = degradationInPct;
        this.variability = variability;
        this.inefficiencyInPct = inefficiencyInPct;
        this.increaseInIOInPct = increaseInIOInPct;
        this.increaseInCPUInPct = increaseInCPUInPct;
        this.increaseInInefficientWaitInPct = increaseInInefficientWaitInPct;
        this.improvedInPct = improvedInPct;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getDegradationInPct() {
        return this.degradationInPct;
    }

    public Float getVariability() {
        return this.variability;
    }

    public Integer getInefficiencyInPct() {
        return this.inefficiencyInPct;
    }

    public Integer getIncreaseInIOInPct() {
        return this.increaseInIOInPct;
    }

    public Integer getIncreaseInCPUInPct() {
        return this.increaseInCPUInPct;
    }

    public Integer getIncreaseInInefficientWaitInPct() {
        return this.increaseInInefficientWaitInPct;
    }

    public Integer getImprovedInPct() {
        return this.improvedInPct;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlInsightThresholds(");
        sb.append("super=").append(super.toString());
        sb.append("degradationInPct=").append(String.valueOf(this.degradationInPct));
        sb.append(", variability=").append(String.valueOf(this.variability));
        sb.append(", inefficiencyInPct=").append(String.valueOf(this.inefficiencyInPct));
        sb.append(", increaseInIOInPct=").append(String.valueOf(this.increaseInIOInPct));
        sb.append(", increaseInCPUInPct=").append(String.valueOf(this.increaseInCPUInPct));
        sb.append(", increaseInInefficientWaitInPct=").append(String.valueOf(this.increaseInInefficientWaitInPct));
        sb.append(", improvedInPct=").append(String.valueOf(this.improvedInPct));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlInsightThresholds)) {
            return false;
        }
        SqlInsightThresholds other = (SqlInsightThresholds)((Object)o);
        return Objects.equals(this.degradationInPct, other.degradationInPct) && Objects.equals(this.variability, other.variability) && Objects.equals(this.inefficiencyInPct, other.inefficiencyInPct) && Objects.equals(this.increaseInIOInPct, other.increaseInIOInPct) && Objects.equals(this.increaseInCPUInPct, other.increaseInCPUInPct) && Objects.equals(this.increaseInInefficientWaitInPct, other.increaseInInefficientWaitInPct) && Objects.equals(this.improvedInPct, other.improvedInPct) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.degradationInPct == null ? 43 : this.degradationInPct.hashCode());
        result = result * 59 + (this.variability == null ? 43 : this.variability.hashCode());
        result = result * 59 + (this.inefficiencyInPct == null ? 43 : this.inefficiencyInPct.hashCode());
        result = result * 59 + (this.increaseInIOInPct == null ? 43 : this.increaseInIOInPct.hashCode());
        result = result * 59 + (this.increaseInCPUInPct == null ? 43 : this.increaseInCPUInPct.hashCode());
        result = result * 59 + (this.increaseInInefficientWaitInPct == null ? 43 : this.increaseInInefficientWaitInPct.hashCode());
        result = result * 59 + (this.improvedInPct == null ? 43 : this.improvedInPct.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="degradationInPct")
        private Integer degradationInPct;
        @JsonProperty(value="variability")
        private Float variability;
        @JsonProperty(value="inefficiencyInPct")
        private Integer inefficiencyInPct;
        @JsonProperty(value="increaseInIOInPct")
        private Integer increaseInIOInPct;
        @JsonProperty(value="increaseInCPUInPct")
        private Integer increaseInCPUInPct;
        @JsonProperty(value="increaseInInefficientWaitInPct")
        private Integer increaseInInefficientWaitInPct;
        @JsonProperty(value="improvedInPct")
        private Integer improvedInPct;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder degradationInPct(Integer degradationInPct) {
            this.degradationInPct = degradationInPct;
            this.__explicitlySet__.add("degradationInPct");
            return this;
        }

        public Builder variability(Float variability) {
            this.variability = variability;
            this.__explicitlySet__.add("variability");
            return this;
        }

        public Builder inefficiencyInPct(Integer inefficiencyInPct) {
            this.inefficiencyInPct = inefficiencyInPct;
            this.__explicitlySet__.add("inefficiencyInPct");
            return this;
        }

        public Builder increaseInIOInPct(Integer increaseInIOInPct) {
            this.increaseInIOInPct = increaseInIOInPct;
            this.__explicitlySet__.add("increaseInIOInPct");
            return this;
        }

        public Builder increaseInCPUInPct(Integer increaseInCPUInPct) {
            this.increaseInCPUInPct = increaseInCPUInPct;
            this.__explicitlySet__.add("increaseInCPUInPct");
            return this;
        }

        public Builder increaseInInefficientWaitInPct(Integer increaseInInefficientWaitInPct) {
            this.increaseInInefficientWaitInPct = increaseInInefficientWaitInPct;
            this.__explicitlySet__.add("increaseInInefficientWaitInPct");
            return this;
        }

        public Builder improvedInPct(Integer improvedInPct) {
            this.improvedInPct = improvedInPct;
            this.__explicitlySet__.add("improvedInPct");
            return this;
        }

        public SqlInsightThresholds build() {
            SqlInsightThresholds model = new SqlInsightThresholds(this.degradationInPct, this.variability, this.inefficiencyInPct, this.increaseInIOInPct, this.increaseInCPUInPct, this.increaseInInefficientWaitInPct, this.improvedInPct);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlInsightThresholds model) {
            if (model.wasPropertyExplicitlySet("degradationInPct")) {
                this.degradationInPct(model.getDegradationInPct());
            }
            if (model.wasPropertyExplicitlySet("variability")) {
                this.variability(model.getVariability());
            }
            if (model.wasPropertyExplicitlySet("inefficiencyInPct")) {
                this.inefficiencyInPct(model.getInefficiencyInPct());
            }
            if (model.wasPropertyExplicitlySet("increaseInIOInPct")) {
                this.increaseInIOInPct(model.getIncreaseInIOInPct());
            }
            if (model.wasPropertyExplicitlySet("increaseInCPUInPct")) {
                this.increaseInCPUInPct(model.getIncreaseInCPUInPct());
            }
            if (model.wasPropertyExplicitlySet("increaseInInefficientWaitInPct")) {
                this.increaseInInefficientWaitInPct(model.getIncreaseInInefficientWaitInPct());
            }
            if (model.wasPropertyExplicitlySet("improvedInPct")) {
                this.improvedInPct(model.getImprovedInPct());
            }
            return this;
        }
    }
}

