/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceUsageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="exadataInsightId")
    private final String exadataInsightId;
    @JsonProperty(value="exadataDisplayName")
    private final String exadataDisplayName;
    @JsonProperty(value="usage")
    private final Double usage;
    @JsonProperty(value="capacity")
    private final Double capacity;
    @JsonProperty(value="utilizationPercent")
    private final Double utilizationPercent;
    @JsonProperty(value="usageChangePercent")
    private final Double usageChangePercent;
    @JsonProperty(value="totalHostCapacity")
    private final Double totalHostCapacity;

    @Deprecated
    @ConstructorProperties(value={"exadataInsightId", "exadataDisplayName", "usage", "capacity", "utilizationPercent", "usageChangePercent", "totalHostCapacity"})
    public ResourceUsageSummary(String exadataInsightId, String exadataDisplayName, Double usage, Double capacity, Double utilizationPercent, Double usageChangePercent, Double totalHostCapacity) {
        this.exadataInsightId = exadataInsightId;
        this.exadataDisplayName = exadataDisplayName;
        this.usage = usage;
        this.capacity = capacity;
        this.utilizationPercent = utilizationPercent;
        this.usageChangePercent = usageChangePercent;
        this.totalHostCapacity = totalHostCapacity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getExadataInsightId() {
        return this.exadataInsightId;
    }

    public String getExadataDisplayName() {
        return this.exadataDisplayName;
    }

    public Double getUsage() {
        return this.usage;
    }

    public Double getCapacity() {
        return this.capacity;
    }

    public Double getUtilizationPercent() {
        return this.utilizationPercent;
    }

    public Double getUsageChangePercent() {
        return this.usageChangePercent;
    }

    public Double getTotalHostCapacity() {
        return this.totalHostCapacity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceUsageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("exadataInsightId=").append(String.valueOf(this.exadataInsightId));
        sb.append(", exadataDisplayName=").append(String.valueOf(this.exadataDisplayName));
        sb.append(", usage=").append(String.valueOf(this.usage));
        sb.append(", capacity=").append(String.valueOf(this.capacity));
        sb.append(", utilizationPercent=").append(String.valueOf(this.utilizationPercent));
        sb.append(", usageChangePercent=").append(String.valueOf(this.usageChangePercent));
        sb.append(", totalHostCapacity=").append(String.valueOf(this.totalHostCapacity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceUsageSummary)) {
            return false;
        }
        ResourceUsageSummary other = (ResourceUsageSummary)((Object)o);
        return Objects.equals(this.exadataInsightId, other.exadataInsightId) && Objects.equals(this.exadataDisplayName, other.exadataDisplayName) && Objects.equals(this.usage, other.usage) && Objects.equals(this.capacity, other.capacity) && Objects.equals(this.utilizationPercent, other.utilizationPercent) && Objects.equals(this.usageChangePercent, other.usageChangePercent) && Objects.equals(this.totalHostCapacity, other.totalHostCapacity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.exadataInsightId == null ? 43 : this.exadataInsightId.hashCode());
        result = result * 59 + (this.exadataDisplayName == null ? 43 : this.exadataDisplayName.hashCode());
        result = result * 59 + (this.usage == null ? 43 : this.usage.hashCode());
        result = result * 59 + (this.capacity == null ? 43 : this.capacity.hashCode());
        result = result * 59 + (this.utilizationPercent == null ? 43 : this.utilizationPercent.hashCode());
        result = result * 59 + (this.usageChangePercent == null ? 43 : this.usageChangePercent.hashCode());
        result = result * 59 + (this.totalHostCapacity == null ? 43 : this.totalHostCapacity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="exadataInsightId")
        private String exadataInsightId;
        @JsonProperty(value="exadataDisplayName")
        private String exadataDisplayName;
        @JsonProperty(value="usage")
        private Double usage;
        @JsonProperty(value="capacity")
        private Double capacity;
        @JsonProperty(value="utilizationPercent")
        private Double utilizationPercent;
        @JsonProperty(value="usageChangePercent")
        private Double usageChangePercent;
        @JsonProperty(value="totalHostCapacity")
        private Double totalHostCapacity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder exadataInsightId(String exadataInsightId) {
            this.exadataInsightId = exadataInsightId;
            this.__explicitlySet__.add("exadataInsightId");
            return this;
        }

        public Builder exadataDisplayName(String exadataDisplayName) {
            this.exadataDisplayName = exadataDisplayName;
            this.__explicitlySet__.add("exadataDisplayName");
            return this;
        }

        public Builder usage(Double usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public Builder capacity(Double capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder utilizationPercent(Double utilizationPercent) {
            this.utilizationPercent = utilizationPercent;
            this.__explicitlySet__.add("utilizationPercent");
            return this;
        }

        public Builder usageChangePercent(Double usageChangePercent) {
            this.usageChangePercent = usageChangePercent;
            this.__explicitlySet__.add("usageChangePercent");
            return this;
        }

        public Builder totalHostCapacity(Double totalHostCapacity) {
            this.totalHostCapacity = totalHostCapacity;
            this.__explicitlySet__.add("totalHostCapacity");
            return this;
        }

        public ResourceUsageSummary build() {
            ResourceUsageSummary model = new ResourceUsageSummary(this.exadataInsightId, this.exadataDisplayName, this.usage, this.capacity, this.utilizationPercent, this.usageChangePercent, this.totalHostCapacity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceUsageSummary model) {
            if (model.wasPropertyExplicitlySet("exadataInsightId")) {
                this.exadataInsightId(model.getExadataInsightId());
            }
            if (model.wasPropertyExplicitlySet("exadataDisplayName")) {
                this.exadataDisplayName(model.getExadataDisplayName());
            }
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("utilizationPercent")) {
                this.utilizationPercent(model.getUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("usageChangePercent")) {
                this.usageChangePercent(model.getUsageChangePercent());
            }
            if (model.wasPropertyExplicitlySet("totalHostCapacity")) {
                this.totalHostCapacity(model.getTotalHostCapacity());
            }
            return this;
        }
    }
}

