/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.DatabaseDetails;
import com.oracle.bmc.opsi.model.ResourceStatistics;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceStatisticsAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="databaseDetails")
    private final DatabaseDetails databaseDetails;
    @JsonProperty(value="currentStatistics")
    private final ResourceStatistics currentStatistics;

    @Deprecated
    @ConstructorProperties(value={"databaseDetails", "currentStatistics"})
    public ResourceStatisticsAggregation(DatabaseDetails databaseDetails, ResourceStatistics currentStatistics) {
        this.databaseDetails = databaseDetails;
        this.currentStatistics = currentStatistics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DatabaseDetails getDatabaseDetails() {
        return this.databaseDetails;
    }

    public ResourceStatistics getCurrentStatistics() {
        return this.currentStatistics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceStatisticsAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("databaseDetails=").append(String.valueOf((Object)this.databaseDetails));
        sb.append(", currentStatistics=").append(String.valueOf((Object)this.currentStatistics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceStatisticsAggregation)) {
            return false;
        }
        ResourceStatisticsAggregation other = (ResourceStatisticsAggregation)((Object)o);
        return Objects.equals((Object)this.databaseDetails, (Object)other.databaseDetails) && Objects.equals((Object)this.currentStatistics, (Object)other.currentStatistics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.databaseDetails == null ? 43 : this.databaseDetails.hashCode());
        result = result * 59 + (this.currentStatistics == null ? 43 : this.currentStatistics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseDetails")
        private DatabaseDetails databaseDetails;
        @JsonProperty(value="currentStatistics")
        private ResourceStatistics currentStatistics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseDetails(DatabaseDetails databaseDetails) {
            this.databaseDetails = databaseDetails;
            this.__explicitlySet__.add("databaseDetails");
            return this;
        }

        public Builder currentStatistics(ResourceStatistics currentStatistics) {
            this.currentStatistics = currentStatistics;
            this.__explicitlySet__.add("currentStatistics");
            return this;
        }

        public ResourceStatisticsAggregation build() {
            ResourceStatisticsAggregation model = new ResourceStatisticsAggregation(this.databaseDetails, this.currentStatistics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceStatisticsAggregation model) {
            if (model.wasPropertyExplicitlySet("databaseDetails")) {
                this.databaseDetails(model.getDatabaseDetails());
            }
            if (model.wasPropertyExplicitlySet("currentStatistics")) {
                this.currentStatistics(model.getCurrentStatistics());
            }
            return this;
        }
    }
}

