/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HostedEntitySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entityIdentifier")
    private final String entityIdentifier;
    @JsonProperty(value="entityName")
    private final String entityName;
    @JsonProperty(value="entityType")
    private final String entityType;

    @Deprecated
    @ConstructorProperties(value={"entityIdentifier", "entityName", "entityType"})
    public HostedEntitySummary(String entityIdentifier, String entityName, String entityType) {
        this.entityIdentifier = entityIdentifier;
        this.entityName = entityName;
        this.entityType = entityType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEntityIdentifier() {
        return this.entityIdentifier;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostedEntitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("entityIdentifier=").append(String.valueOf(this.entityIdentifier));
        sb.append(", entityName=").append(String.valueOf(this.entityName));
        sb.append(", entityType=").append(String.valueOf(this.entityType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostedEntitySummary)) {
            return false;
        }
        HostedEntitySummary other = (HostedEntitySummary)((Object)o);
        return Objects.equals(this.entityIdentifier, other.entityIdentifier) && Objects.equals(this.entityName, other.entityName) && Objects.equals(this.entityType, other.entityType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityIdentifier == null ? 43 : this.entityIdentifier.hashCode());
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityIdentifier")
        private String entityIdentifier;
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            this.__explicitlySet__.add("entityIdentifier");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public HostedEntitySummary build() {
            HostedEntitySummary model = new HostedEntitySummary(this.entityIdentifier, this.entityName, this.entityType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostedEntitySummary model) {
            if (model.wasPropertyExplicitlySet("entityIdentifier")) {
                this.entityIdentifier(model.getEntityIdentifier());
            }
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            return this;
        }
    }
}

