/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostPerformanceMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostMemoryUsage
extends HostPerformanceMetricGroup {
    @JsonProperty(value="memoryUsedInGB")
    private final Double memoryUsedInGB;
    @JsonProperty(value="memoryUtilizationInPercent")
    private final Float memoryUtilizationInPercent;
    @JsonProperty(value="memoryLoadInGB")
    private final Double memoryLoadInGB;
    @JsonProperty(value="realMemoryInKB")
    private final Double realMemoryInKB;
    @JsonProperty(value="freeMemoryInKB")
    private final Double freeMemoryInKB;
    @JsonProperty(value="logicalMemoryUsedInGB")
    private final Double logicalMemoryUsedInGB;
    @JsonProperty(value="logicalMemoryUtilizationInPercent")
    private final Float logicalMemoryUtilizationInPercent;
    @JsonProperty(value="freeLogicalMemoryInKB")
    private final Double freeLogicalMemoryInKB;
    @JsonProperty(value="majorPageFaults")
    private final Integer majorPageFaults;
    @JsonProperty(value="swapFreeInKB")
    private final Double swapFreeInKB;
    @JsonProperty(value="anonHugePagesInKB")
    private final Double anonHugePagesInKB;
    @JsonProperty(value="hugePagesFree")
    private final Integer hugePagesFree;
    @JsonProperty(value="hugePagesReserved")
    private final Integer hugePagesReserved;
    @JsonProperty(value="hugePagesSurplus")
    private final Integer hugePagesSurplus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostMemoryUsage(Date timeCollected, Double memoryUsedInGB, Float memoryUtilizationInPercent, Double memoryLoadInGB, Double realMemoryInKB, Double freeMemoryInKB, Double logicalMemoryUsedInGB, Float logicalMemoryUtilizationInPercent, Double freeLogicalMemoryInKB, Integer majorPageFaults, Double swapFreeInKB, Double anonHugePagesInKB, Integer hugePagesFree, Integer hugePagesReserved, Integer hugePagesSurplus) {
        super(timeCollected);
        this.memoryUsedInGB = memoryUsedInGB;
        this.memoryUtilizationInPercent = memoryUtilizationInPercent;
        this.memoryLoadInGB = memoryLoadInGB;
        this.realMemoryInKB = realMemoryInKB;
        this.freeMemoryInKB = freeMemoryInKB;
        this.logicalMemoryUsedInGB = logicalMemoryUsedInGB;
        this.logicalMemoryUtilizationInPercent = logicalMemoryUtilizationInPercent;
        this.freeLogicalMemoryInKB = freeLogicalMemoryInKB;
        this.majorPageFaults = majorPageFaults;
        this.swapFreeInKB = swapFreeInKB;
        this.anonHugePagesInKB = anonHugePagesInKB;
        this.hugePagesFree = hugePagesFree;
        this.hugePagesReserved = hugePagesReserved;
        this.hugePagesSurplus = hugePagesSurplus;
    }

    public Double getMemoryUsedInGB() {
        return this.memoryUsedInGB;
    }

    public Float getMemoryUtilizationInPercent() {
        return this.memoryUtilizationInPercent;
    }

    public Double getMemoryLoadInGB() {
        return this.memoryLoadInGB;
    }

    public Double getRealMemoryInKB() {
        return this.realMemoryInKB;
    }

    public Double getFreeMemoryInKB() {
        return this.freeMemoryInKB;
    }

    public Double getLogicalMemoryUsedInGB() {
        return this.logicalMemoryUsedInGB;
    }

    public Float getLogicalMemoryUtilizationInPercent() {
        return this.logicalMemoryUtilizationInPercent;
    }

    public Double getFreeLogicalMemoryInKB() {
        return this.freeLogicalMemoryInKB;
    }

    public Integer getMajorPageFaults() {
        return this.majorPageFaults;
    }

    public Double getSwapFreeInKB() {
        return this.swapFreeInKB;
    }

    public Double getAnonHugePagesInKB() {
        return this.anonHugePagesInKB;
    }

    public Integer getHugePagesFree() {
        return this.hugePagesFree;
    }

    public Integer getHugePagesReserved() {
        return this.hugePagesReserved;
    }

    public Integer getHugePagesSurplus() {
        return this.hugePagesSurplus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostMemoryUsage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", memoryUsedInGB=").append(String.valueOf(this.memoryUsedInGB));
        sb.append(", memoryUtilizationInPercent=").append(String.valueOf(this.memoryUtilizationInPercent));
        sb.append(", memoryLoadInGB=").append(String.valueOf(this.memoryLoadInGB));
        sb.append(", realMemoryInKB=").append(String.valueOf(this.realMemoryInKB));
        sb.append(", freeMemoryInKB=").append(String.valueOf(this.freeMemoryInKB));
        sb.append(", logicalMemoryUsedInGB=").append(String.valueOf(this.logicalMemoryUsedInGB));
        sb.append(", logicalMemoryUtilizationInPercent=").append(String.valueOf(this.logicalMemoryUtilizationInPercent));
        sb.append(", freeLogicalMemoryInKB=").append(String.valueOf(this.freeLogicalMemoryInKB));
        sb.append(", majorPageFaults=").append(String.valueOf(this.majorPageFaults));
        sb.append(", swapFreeInKB=").append(String.valueOf(this.swapFreeInKB));
        sb.append(", anonHugePagesInKB=").append(String.valueOf(this.anonHugePagesInKB));
        sb.append(", hugePagesFree=").append(String.valueOf(this.hugePagesFree));
        sb.append(", hugePagesReserved=").append(String.valueOf(this.hugePagesReserved));
        sb.append(", hugePagesSurplus=").append(String.valueOf(this.hugePagesSurplus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostMemoryUsage)) {
            return false;
        }
        HostMemoryUsage other = (HostMemoryUsage)((Object)o);
        return Objects.equals(this.memoryUsedInGB, other.memoryUsedInGB) && Objects.equals(this.memoryUtilizationInPercent, other.memoryUtilizationInPercent) && Objects.equals(this.memoryLoadInGB, other.memoryLoadInGB) && Objects.equals(this.realMemoryInKB, other.realMemoryInKB) && Objects.equals(this.freeMemoryInKB, other.freeMemoryInKB) && Objects.equals(this.logicalMemoryUsedInGB, other.logicalMemoryUsedInGB) && Objects.equals(this.logicalMemoryUtilizationInPercent, other.logicalMemoryUtilizationInPercent) && Objects.equals(this.freeLogicalMemoryInKB, other.freeLogicalMemoryInKB) && Objects.equals(this.majorPageFaults, other.majorPageFaults) && Objects.equals(this.swapFreeInKB, other.swapFreeInKB) && Objects.equals(this.anonHugePagesInKB, other.anonHugePagesInKB) && Objects.equals(this.hugePagesFree, other.hugePagesFree) && Objects.equals(this.hugePagesReserved, other.hugePagesReserved) && Objects.equals(this.hugePagesSurplus, other.hugePagesSurplus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.memoryUsedInGB == null ? 43 : this.memoryUsedInGB.hashCode());
        result = result * 59 + (this.memoryUtilizationInPercent == null ? 43 : this.memoryUtilizationInPercent.hashCode());
        result = result * 59 + (this.memoryLoadInGB == null ? 43 : this.memoryLoadInGB.hashCode());
        result = result * 59 + (this.realMemoryInKB == null ? 43 : this.realMemoryInKB.hashCode());
        result = result * 59 + (this.freeMemoryInKB == null ? 43 : this.freeMemoryInKB.hashCode());
        result = result * 59 + (this.logicalMemoryUsedInGB == null ? 43 : this.logicalMemoryUsedInGB.hashCode());
        result = result * 59 + (this.logicalMemoryUtilizationInPercent == null ? 43 : this.logicalMemoryUtilizationInPercent.hashCode());
        result = result * 59 + (this.freeLogicalMemoryInKB == null ? 43 : this.freeLogicalMemoryInKB.hashCode());
        result = result * 59 + (this.majorPageFaults == null ? 43 : this.majorPageFaults.hashCode());
        result = result * 59 + (this.swapFreeInKB == null ? 43 : this.swapFreeInKB.hashCode());
        result = result * 59 + (this.anonHugePagesInKB == null ? 43 : this.anonHugePagesInKB.hashCode());
        result = result * 59 + (this.hugePagesFree == null ? 43 : this.hugePagesFree.hashCode());
        result = result * 59 + (this.hugePagesReserved == null ? 43 : this.hugePagesReserved.hashCode());
        result = result * 59 + (this.hugePagesSurplus == null ? 43 : this.hugePagesSurplus.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="memoryUsedInGB")
        private Double memoryUsedInGB;
        @JsonProperty(value="memoryUtilizationInPercent")
        private Float memoryUtilizationInPercent;
        @JsonProperty(value="memoryLoadInGB")
        private Double memoryLoadInGB;
        @JsonProperty(value="realMemoryInKB")
        private Double realMemoryInKB;
        @JsonProperty(value="freeMemoryInKB")
        private Double freeMemoryInKB;
        @JsonProperty(value="logicalMemoryUsedInGB")
        private Double logicalMemoryUsedInGB;
        @JsonProperty(value="logicalMemoryUtilizationInPercent")
        private Float logicalMemoryUtilizationInPercent;
        @JsonProperty(value="freeLogicalMemoryInKB")
        private Double freeLogicalMemoryInKB;
        @JsonProperty(value="majorPageFaults")
        private Integer majorPageFaults;
        @JsonProperty(value="swapFreeInKB")
        private Double swapFreeInKB;
        @JsonProperty(value="anonHugePagesInKB")
        private Double anonHugePagesInKB;
        @JsonProperty(value="hugePagesFree")
        private Integer hugePagesFree;
        @JsonProperty(value="hugePagesReserved")
        private Integer hugePagesReserved;
        @JsonProperty(value="hugePagesSurplus")
        private Integer hugePagesSurplus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder memoryUsedInGB(Double memoryUsedInGB) {
            this.memoryUsedInGB = memoryUsedInGB;
            this.__explicitlySet__.add("memoryUsedInGB");
            return this;
        }

        public Builder memoryUtilizationInPercent(Float memoryUtilizationInPercent) {
            this.memoryUtilizationInPercent = memoryUtilizationInPercent;
            this.__explicitlySet__.add("memoryUtilizationInPercent");
            return this;
        }

        public Builder memoryLoadInGB(Double memoryLoadInGB) {
            this.memoryLoadInGB = memoryLoadInGB;
            this.__explicitlySet__.add("memoryLoadInGB");
            return this;
        }

        public Builder realMemoryInKB(Double realMemoryInKB) {
            this.realMemoryInKB = realMemoryInKB;
            this.__explicitlySet__.add("realMemoryInKB");
            return this;
        }

        public Builder freeMemoryInKB(Double freeMemoryInKB) {
            this.freeMemoryInKB = freeMemoryInKB;
            this.__explicitlySet__.add("freeMemoryInKB");
            return this;
        }

        public Builder logicalMemoryUsedInGB(Double logicalMemoryUsedInGB) {
            this.logicalMemoryUsedInGB = logicalMemoryUsedInGB;
            this.__explicitlySet__.add("logicalMemoryUsedInGB");
            return this;
        }

        public Builder logicalMemoryUtilizationInPercent(Float logicalMemoryUtilizationInPercent) {
            this.logicalMemoryUtilizationInPercent = logicalMemoryUtilizationInPercent;
            this.__explicitlySet__.add("logicalMemoryUtilizationInPercent");
            return this;
        }

        public Builder freeLogicalMemoryInKB(Double freeLogicalMemoryInKB) {
            this.freeLogicalMemoryInKB = freeLogicalMemoryInKB;
            this.__explicitlySet__.add("freeLogicalMemoryInKB");
            return this;
        }

        public Builder majorPageFaults(Integer majorPageFaults) {
            this.majorPageFaults = majorPageFaults;
            this.__explicitlySet__.add("majorPageFaults");
            return this;
        }

        public Builder swapFreeInKB(Double swapFreeInKB) {
            this.swapFreeInKB = swapFreeInKB;
            this.__explicitlySet__.add("swapFreeInKB");
            return this;
        }

        public Builder anonHugePagesInKB(Double anonHugePagesInKB) {
            this.anonHugePagesInKB = anonHugePagesInKB;
            this.__explicitlySet__.add("anonHugePagesInKB");
            return this;
        }

        public Builder hugePagesFree(Integer hugePagesFree) {
            this.hugePagesFree = hugePagesFree;
            this.__explicitlySet__.add("hugePagesFree");
            return this;
        }

        public Builder hugePagesReserved(Integer hugePagesReserved) {
            this.hugePagesReserved = hugePagesReserved;
            this.__explicitlySet__.add("hugePagesReserved");
            return this;
        }

        public Builder hugePagesSurplus(Integer hugePagesSurplus) {
            this.hugePagesSurplus = hugePagesSurplus;
            this.__explicitlySet__.add("hugePagesSurplus");
            return this;
        }

        public HostMemoryUsage build() {
            HostMemoryUsage model = new HostMemoryUsage(this.timeCollected, this.memoryUsedInGB, this.memoryUtilizationInPercent, this.memoryLoadInGB, this.realMemoryInKB, this.freeMemoryInKB, this.logicalMemoryUsedInGB, this.logicalMemoryUtilizationInPercent, this.freeLogicalMemoryInKB, this.majorPageFaults, this.swapFreeInKB, this.anonHugePagesInKB, this.hugePagesFree, this.hugePagesReserved, this.hugePagesSurplus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostMemoryUsage model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("memoryUsedInGB")) {
                this.memoryUsedInGB(model.getMemoryUsedInGB());
            }
            if (model.wasPropertyExplicitlySet("memoryUtilizationInPercent")) {
                this.memoryUtilizationInPercent(model.getMemoryUtilizationInPercent());
            }
            if (model.wasPropertyExplicitlySet("memoryLoadInGB")) {
                this.memoryLoadInGB(model.getMemoryLoadInGB());
            }
            if (model.wasPropertyExplicitlySet("realMemoryInKB")) {
                this.realMemoryInKB(model.getRealMemoryInKB());
            }
            if (model.wasPropertyExplicitlySet("freeMemoryInKB")) {
                this.freeMemoryInKB(model.getFreeMemoryInKB());
            }
            if (model.wasPropertyExplicitlySet("logicalMemoryUsedInGB")) {
                this.logicalMemoryUsedInGB(model.getLogicalMemoryUsedInGB());
            }
            if (model.wasPropertyExplicitlySet("logicalMemoryUtilizationInPercent")) {
                this.logicalMemoryUtilizationInPercent(model.getLogicalMemoryUtilizationInPercent());
            }
            if (model.wasPropertyExplicitlySet("freeLogicalMemoryInKB")) {
                this.freeLogicalMemoryInKB(model.getFreeLogicalMemoryInKB());
            }
            if (model.wasPropertyExplicitlySet("majorPageFaults")) {
                this.majorPageFaults(model.getMajorPageFaults());
            }
            if (model.wasPropertyExplicitlySet("swapFreeInKB")) {
                this.swapFreeInKB(model.getSwapFreeInKB());
            }
            if (model.wasPropertyExplicitlySet("anonHugePagesInKB")) {
                this.anonHugePagesInKB(model.getAnonHugePagesInKB());
            }
            if (model.wasPropertyExplicitlySet("hugePagesFree")) {
                this.hugePagesFree(model.getHugePagesFree());
            }
            if (model.wasPropertyExplicitlySet("hugePagesReserved")) {
                this.hugePagesReserved(model.getHugePagesReserved());
            }
            if (model.wasPropertyExplicitlySet("hugePagesSurplus")) {
                this.hugePagesSurplus(model.getHugePagesSurplus());
            }
            return this;
        }
    }
}

