/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostHardwareConfiguration
extends HostConfigurationMetricGroup {
    @JsonProperty(value="cpuArchitecture")
    private final String cpuArchitecture;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostHardwareConfiguration(Date timeCollected, String cpuArchitecture) {
        super(timeCollected);
        this.cpuArchitecture = cpuArchitecture;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostHardwareConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", cpuArchitecture=").append(String.valueOf(this.cpuArchitecture));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostHardwareConfiguration)) {
            return false;
        }
        HostHardwareConfiguration other = (HostHardwareConfiguration)((Object)o);
        return Objects.equals(this.cpuArchitecture, other.cpuArchitecture) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cpuArchitecture == null ? 43 : this.cpuArchitecture.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="cpuArchitecture")
        private String cpuArchitecture;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder cpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
            this.__explicitlySet__.add("cpuArchitecture");
            return this;
        }

        public HostHardwareConfiguration build() {
            HostHardwareConfiguration model = new HostHardwareConfiguration(this.timeCollected, this.cpuArchitecture);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostHardwareConfiguration model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("cpuArchitecture")) {
                this.cpuArchitecture(model.getCpuArchitecture());
            }
            return this;
        }
    }
}

