/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostPerformanceMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostCpuUsage
extends HostPerformanceMetricGroup {
    @JsonProperty(value="cpuUserModeInPercent")
    private final Float cpuUserModeInPercent;
    @JsonProperty(value="cpuSystemModeInPercent")
    private final Float cpuSystemModeInPercent;
    @JsonProperty(value="cpuUsageInSec")
    private final Double cpuUsageInSec;
    @JsonProperty(value="cpuUtilizationInPercent")
    private final Float cpuUtilizationInPercent;
    @JsonProperty(value="cpuStolenInPercent")
    private final Float cpuStolenInPercent;
    @JsonProperty(value="cpuIdleInPercent")
    private final Float cpuIdleInPercent;
    @JsonProperty(value="cpuLoad1min")
    private final Float cpuLoad1min;
    @JsonProperty(value="cpuLoad5min")
    private final Float cpuLoad5min;
    @JsonProperty(value="cpuLoad15min")
    private final Float cpuLoad15min;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostCpuUsage(Date timeCollected, Float cpuUserModeInPercent, Float cpuSystemModeInPercent, Double cpuUsageInSec, Float cpuUtilizationInPercent, Float cpuStolenInPercent, Float cpuIdleInPercent, Float cpuLoad1min, Float cpuLoad5min, Float cpuLoad15min) {
        super(timeCollected);
        this.cpuUserModeInPercent = cpuUserModeInPercent;
        this.cpuSystemModeInPercent = cpuSystemModeInPercent;
        this.cpuUsageInSec = cpuUsageInSec;
        this.cpuUtilizationInPercent = cpuUtilizationInPercent;
        this.cpuStolenInPercent = cpuStolenInPercent;
        this.cpuIdleInPercent = cpuIdleInPercent;
        this.cpuLoad1min = cpuLoad1min;
        this.cpuLoad5min = cpuLoad5min;
        this.cpuLoad15min = cpuLoad15min;
    }

    public Float getCpuUserModeInPercent() {
        return this.cpuUserModeInPercent;
    }

    public Float getCpuSystemModeInPercent() {
        return this.cpuSystemModeInPercent;
    }

    public Double getCpuUsageInSec() {
        return this.cpuUsageInSec;
    }

    public Float getCpuUtilizationInPercent() {
        return this.cpuUtilizationInPercent;
    }

    public Float getCpuStolenInPercent() {
        return this.cpuStolenInPercent;
    }

    public Float getCpuIdleInPercent() {
        return this.cpuIdleInPercent;
    }

    public Float getCpuLoad1min() {
        return this.cpuLoad1min;
    }

    public Float getCpuLoad5min() {
        return this.cpuLoad5min;
    }

    public Float getCpuLoad15min() {
        return this.cpuLoad15min;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostCpuUsage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", cpuUserModeInPercent=").append(String.valueOf(this.cpuUserModeInPercent));
        sb.append(", cpuSystemModeInPercent=").append(String.valueOf(this.cpuSystemModeInPercent));
        sb.append(", cpuUsageInSec=").append(String.valueOf(this.cpuUsageInSec));
        sb.append(", cpuUtilizationInPercent=").append(String.valueOf(this.cpuUtilizationInPercent));
        sb.append(", cpuStolenInPercent=").append(String.valueOf(this.cpuStolenInPercent));
        sb.append(", cpuIdleInPercent=").append(String.valueOf(this.cpuIdleInPercent));
        sb.append(", cpuLoad1min=").append(String.valueOf(this.cpuLoad1min));
        sb.append(", cpuLoad5min=").append(String.valueOf(this.cpuLoad5min));
        sb.append(", cpuLoad15min=").append(String.valueOf(this.cpuLoad15min));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostCpuUsage)) {
            return false;
        }
        HostCpuUsage other = (HostCpuUsage)((Object)o);
        return Objects.equals(this.cpuUserModeInPercent, other.cpuUserModeInPercent) && Objects.equals(this.cpuSystemModeInPercent, other.cpuSystemModeInPercent) && Objects.equals(this.cpuUsageInSec, other.cpuUsageInSec) && Objects.equals(this.cpuUtilizationInPercent, other.cpuUtilizationInPercent) && Objects.equals(this.cpuStolenInPercent, other.cpuStolenInPercent) && Objects.equals(this.cpuIdleInPercent, other.cpuIdleInPercent) && Objects.equals(this.cpuLoad1min, other.cpuLoad1min) && Objects.equals(this.cpuLoad5min, other.cpuLoad5min) && Objects.equals(this.cpuLoad15min, other.cpuLoad15min) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cpuUserModeInPercent == null ? 43 : this.cpuUserModeInPercent.hashCode());
        result = result * 59 + (this.cpuSystemModeInPercent == null ? 43 : this.cpuSystemModeInPercent.hashCode());
        result = result * 59 + (this.cpuUsageInSec == null ? 43 : this.cpuUsageInSec.hashCode());
        result = result * 59 + (this.cpuUtilizationInPercent == null ? 43 : this.cpuUtilizationInPercent.hashCode());
        result = result * 59 + (this.cpuStolenInPercent == null ? 43 : this.cpuStolenInPercent.hashCode());
        result = result * 59 + (this.cpuIdleInPercent == null ? 43 : this.cpuIdleInPercent.hashCode());
        result = result * 59 + (this.cpuLoad1min == null ? 43 : this.cpuLoad1min.hashCode());
        result = result * 59 + (this.cpuLoad5min == null ? 43 : this.cpuLoad5min.hashCode());
        result = result * 59 + (this.cpuLoad15min == null ? 43 : this.cpuLoad15min.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="cpuUserModeInPercent")
        private Float cpuUserModeInPercent;
        @JsonProperty(value="cpuSystemModeInPercent")
        private Float cpuSystemModeInPercent;
        @JsonProperty(value="cpuUsageInSec")
        private Double cpuUsageInSec;
        @JsonProperty(value="cpuUtilizationInPercent")
        private Float cpuUtilizationInPercent;
        @JsonProperty(value="cpuStolenInPercent")
        private Float cpuStolenInPercent;
        @JsonProperty(value="cpuIdleInPercent")
        private Float cpuIdleInPercent;
        @JsonProperty(value="cpuLoad1min")
        private Float cpuLoad1min;
        @JsonProperty(value="cpuLoad5min")
        private Float cpuLoad5min;
        @JsonProperty(value="cpuLoad15min")
        private Float cpuLoad15min;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder cpuUserModeInPercent(Float cpuUserModeInPercent) {
            this.cpuUserModeInPercent = cpuUserModeInPercent;
            this.__explicitlySet__.add("cpuUserModeInPercent");
            return this;
        }

        public Builder cpuSystemModeInPercent(Float cpuSystemModeInPercent) {
            this.cpuSystemModeInPercent = cpuSystemModeInPercent;
            this.__explicitlySet__.add("cpuSystemModeInPercent");
            return this;
        }

        public Builder cpuUsageInSec(Double cpuUsageInSec) {
            this.cpuUsageInSec = cpuUsageInSec;
            this.__explicitlySet__.add("cpuUsageInSec");
            return this;
        }

        public Builder cpuUtilizationInPercent(Float cpuUtilizationInPercent) {
            this.cpuUtilizationInPercent = cpuUtilizationInPercent;
            this.__explicitlySet__.add("cpuUtilizationInPercent");
            return this;
        }

        public Builder cpuStolenInPercent(Float cpuStolenInPercent) {
            this.cpuStolenInPercent = cpuStolenInPercent;
            this.__explicitlySet__.add("cpuStolenInPercent");
            return this;
        }

        public Builder cpuIdleInPercent(Float cpuIdleInPercent) {
            this.cpuIdleInPercent = cpuIdleInPercent;
            this.__explicitlySet__.add("cpuIdleInPercent");
            return this;
        }

        public Builder cpuLoad1min(Float cpuLoad1min) {
            this.cpuLoad1min = cpuLoad1min;
            this.__explicitlySet__.add("cpuLoad1min");
            return this;
        }

        public Builder cpuLoad5min(Float cpuLoad5min) {
            this.cpuLoad5min = cpuLoad5min;
            this.__explicitlySet__.add("cpuLoad5min");
            return this;
        }

        public Builder cpuLoad15min(Float cpuLoad15min) {
            this.cpuLoad15min = cpuLoad15min;
            this.__explicitlySet__.add("cpuLoad15min");
            return this;
        }

        public HostCpuUsage build() {
            HostCpuUsage model = new HostCpuUsage(this.timeCollected, this.cpuUserModeInPercent, this.cpuSystemModeInPercent, this.cpuUsageInSec, this.cpuUtilizationInPercent, this.cpuStolenInPercent, this.cpuIdleInPercent, this.cpuLoad1min, this.cpuLoad5min, this.cpuLoad15min);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostCpuUsage model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("cpuUserModeInPercent")) {
                this.cpuUserModeInPercent(model.getCpuUserModeInPercent());
            }
            if (model.wasPropertyExplicitlySet("cpuSystemModeInPercent")) {
                this.cpuSystemModeInPercent(model.getCpuSystemModeInPercent());
            }
            if (model.wasPropertyExplicitlySet("cpuUsageInSec")) {
                this.cpuUsageInSec(model.getCpuUsageInSec());
            }
            if (model.wasPropertyExplicitlySet("cpuUtilizationInPercent")) {
                this.cpuUtilizationInPercent(model.getCpuUtilizationInPercent());
            }
            if (model.wasPropertyExplicitlySet("cpuStolenInPercent")) {
                this.cpuStolenInPercent(model.getCpuStolenInPercent());
            }
            if (model.wasPropertyExplicitlySet("cpuIdleInPercent")) {
                this.cpuIdleInPercent(model.getCpuIdleInPercent());
            }
            if (model.wasPropertyExplicitlySet("cpuLoad1min")) {
                this.cpuLoad1min(model.getCpuLoad1min());
            }
            if (model.wasPropertyExplicitlySet("cpuLoad5min")) {
                this.cpuLoad5min(model.getCpuLoad5min());
            }
            if (model.wasPropertyExplicitlySet("cpuLoad15min")) {
                this.cpuLoad15min(model.getCpuLoad15min());
            }
            return this;
        }
    }
}

