/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DataObjectColumnUnit;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="unitCategory")
@JsonFilter(value="explicitlySetFilter")
public final class DataObjectRateColumnUnit
extends DataObjectColumnUnit {
    @JsonProperty(value="numerator")
    private final DataObjectColumnUnit numerator;
    @JsonProperty(value="denominator")
    private final DataObjectColumnUnit denominator;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DataObjectRateColumnUnit(String displayName, DataObjectColumnUnit numerator, DataObjectColumnUnit denominator) {
        super(displayName);
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public DataObjectColumnUnit getNumerator() {
        return this.numerator;
    }

    public DataObjectColumnUnit getDenominator() {
        return this.denominator;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataObjectRateColumnUnit(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", numerator=").append(String.valueOf((Object)this.numerator));
        sb.append(", denominator=").append(String.valueOf((Object)this.denominator));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataObjectRateColumnUnit)) {
            return false;
        }
        DataObjectRateColumnUnit other = (DataObjectRateColumnUnit)((Object)o);
        return Objects.equals((Object)this.numerator, (Object)other.numerator) && Objects.equals((Object)this.denominator, (Object)other.denominator) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.numerator == null ? 43 : this.numerator.hashCode());
        result = result * 59 + (this.denominator == null ? 43 : this.denominator.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="numerator")
        private DataObjectColumnUnit numerator;
        @JsonProperty(value="denominator")
        private DataObjectColumnUnit denominator;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder numerator(DataObjectColumnUnit numerator) {
            this.numerator = numerator;
            this.__explicitlySet__.add("numerator");
            return this;
        }

        public Builder denominator(DataObjectColumnUnit denominator) {
            this.denominator = denominator;
            this.__explicitlySet__.add("denominator");
            return this;
        }

        public DataObjectRateColumnUnit build() {
            DataObjectRateColumnUnit model = new DataObjectRateColumnUnit(this.displayName, this.numerator, this.denominator);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataObjectRateColumnUnit model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("numerator")) {
                this.numerator(model.getNumerator());
            }
            if (model.wasPropertyExplicitlySet("denominator")) {
                this.denominator(model.getDenominator());
            }
            return this;
        }
    }
}

