/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.AwrDatabaseCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseCpuUsageCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseMetricCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseParameterChangeCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseParameterCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseReport;
import com.oracle.bmc.opsi.model.AwrDatabaseSnapshotCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseSnapshotRangeCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseSqlReport;
import com.oracle.bmc.opsi.model.AwrDatabaseSysstatCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseTopWaitEventCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseWaitEventBucketCollection;
import com.oracle.bmc.opsi.model.AwrDatabaseWaitEventCollection;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="awrResultType", defaultImpl=AwrQueryResult.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AwrDatabaseCpuUsageCollection.class, name="AWRDB_ASH_CPU_USAGE_SET"), @JsonSubTypes.Type(value=AwrDatabaseParameterCollection.class, name="AWRDB_DB_PARAMETER_SET"), @JsonSubTypes.Type(value=AwrDatabaseWaitEventBucketCollection.class, name="AWRDB_EVENT_HISTOGRAM_SET"), @JsonSubTypes.Type(value=AwrDatabaseSnapshotRangeCollection.class, name="AWRDB_SNAPSHOT_RANGE_SET"), @JsonSubTypes.Type(value=AwrDatabaseSnapshotCollection.class, name="AWRDB_SNAPSHOT_SET"), @JsonSubTypes.Type(value=AwrDatabaseSysstatCollection.class, name="AWRDB_SYSSTAT_SET"), @JsonSubTypes.Type(value=AwrDatabaseMetricCollection.class, name="AWRDB_METRICS_SET"), @JsonSubTypes.Type(value=AwrDatabaseWaitEventCollection.class, name="AWRDB_EVENT_SET"), @JsonSubTypes.Type(value=AwrDatabaseCollection.class, name="AWRDB_SET"), @JsonSubTypes.Type(value=AwrDatabaseTopWaitEventCollection.class, name="AWRDB_TOP_EVENT_SET"), @JsonSubTypes.Type(value=AwrDatabaseParameterChangeCollection.class, name="AWRDB_DB_PARAMETER_CHANGE"), @JsonSubTypes.Type(value=AwrDatabaseReport.class, name="AWRDB_DB_REPORT"), @JsonSubTypes.Type(value=AwrDatabaseSqlReport.class, name="AWRDB_SQL_REPORT")})
@JsonFilter(value="explicitlySetFilter")
public class AwrQueryResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="dbQueryTimeInSecs")
    private final Double dbQueryTimeInSecs;

    @Deprecated
    @ConstructorProperties(value={"name", "version", "dbQueryTimeInSecs"})
    protected AwrQueryResult(String name, String version, Double dbQueryTimeInSecs) {
        this.name = name;
        this.version = version;
        this.dbQueryTimeInSecs = dbQueryTimeInSecs;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Double getDbQueryTimeInSecs() {
        return this.dbQueryTimeInSecs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwrQueryResult(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", dbQueryTimeInSecs=").append(String.valueOf(this.dbQueryTimeInSecs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwrQueryResult)) {
            return false;
        }
        AwrQueryResult other = (AwrQueryResult)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.dbQueryTimeInSecs, other.dbQueryTimeInSecs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.dbQueryTimeInSecs == null ? 43 : this.dbQueryTimeInSecs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AwrResultType implements BmcEnum
    {
        AwrdbSet("AWRDB_SET"),
        AwrdbSnapshotRangeSet("AWRDB_SNAPSHOT_RANGE_SET"),
        AwrdbSnapshotSet("AWRDB_SNAPSHOT_SET"),
        AwrdbMetricsSet("AWRDB_METRICS_SET"),
        AwrdbSysstatSet("AWRDB_SYSSTAT_SET"),
        AwrdbTopEventSet("AWRDB_TOP_EVENT_SET"),
        AwrdbEventSet("AWRDB_EVENT_SET"),
        AwrdbEventHistogram("AWRDB_EVENT_HISTOGRAM"),
        AwrdbDbParameterSet("AWRDB_DB_PARAMETER_SET"),
        AwrdbDbParameterChange("AWRDB_DB_PARAMETER_CHANGE"),
        AwrdbAshCpuUsageSet("AWRDB_ASH_CPU_USAGE_SET"),
        AwrdbDbReport("AWRDB_DB_REPORT"),
        AwrdbSqlReport("AWRDB_SQL_REPORT");

        private final String value;
        private static Map<String, AwrResultType> map;

        private AwrResultType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AwrResultType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AwrResultType: " + key);
        }

        static {
            map = new HashMap<String, AwrResultType>();
            for (AwrResultType v : AwrResultType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

