/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.opensearch.OpensearchCluster;
import com.oracle.bmc.opensearch.OpensearchClusterAsyncClient;
import com.oracle.bmc.opensearch.OpensearchClusterPaginators;
import com.oracle.bmc.opensearch.OpensearchClusterWaiters;
import com.oracle.bmc.opensearch.model.OpensearchClusterCollection;
import com.oracle.bmc.opensearch.model.OpensearchVersionsCollection;
import com.oracle.bmc.opensearch.model.WorkRequest;
import com.oracle.bmc.opensearch.model.WorkRequestCollection;
import com.oracle.bmc.opensearch.model.WorkRequestErrorCollection;
import com.oracle.bmc.opensearch.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.opensearch.requests.BackupOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.CreateOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.DeleteOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.GetOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.GetWorkRequestRequest;
import com.oracle.bmc.opensearch.requests.ListOpensearchClustersRequest;
import com.oracle.bmc.opensearch.requests.ListOpensearchVersionsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestsRequest;
import com.oracle.bmc.opensearch.requests.OpensearchClusterRestoreRequest;
import com.oracle.bmc.opensearch.requests.ResizeOpensearchClusterHorizontalRequest;
import com.oracle.bmc.opensearch.requests.ResizeOpensearchClusterVerticalRequest;
import com.oracle.bmc.opensearch.requests.UpdateOpensearchClusterRequest;
import com.oracle.bmc.opensearch.responses.BackupOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.CreateOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.DeleteOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.GetOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.GetWorkRequestResponse;
import com.oracle.bmc.opensearch.responses.ListOpensearchClustersResponse;
import com.oracle.bmc.opensearch.responses.ListOpensearchVersionsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestsResponse;
import com.oracle.bmc.opensearch.responses.OpensearchClusterRestoreResponse;
import com.oracle.bmc.opensearch.responses.ResizeOpensearchClusterHorizontalResponse;
import com.oracle.bmc.opensearch.responses.ResizeOpensearchClusterVerticalResponse;
import com.oracle.bmc.opensearch.responses.UpdateOpensearchClusterResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpensearchClusterClient
extends BaseSyncClient
implements OpensearchCluster {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPENSEARCHCLUSTER").serviceEndpointPrefix("").serviceEndpointTemplate("https://search-indexing.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OpensearchClusterAsyncClient.class);
    private final OpensearchClusterWaiters waiters;
    private final OpensearchClusterPaginators paginators;

    private OpensearchClusterClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("OpensearchCluster-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OpensearchClusterWaiters(executorService, this);
        this.paginators = new OpensearchClusterPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public BackupOpensearchClusterResponse backupOpensearchCluster(BackupOpensearchClusterRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBackupOpensearchClusterDetails(), "backupOpensearchClusterDetails is required");
        return (BackupOpensearchClusterResponse)this.clientCall(request, BackupOpensearchClusterResponse::builder).logger(LOG, "backupOpensearchCluster").serviceDetails("OpensearchCluster", "BackupOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/BackupOpensearchCluster").method(Method.POST).requestBuilder(BackupOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).appendPathParam("actions").appendPathParam("backup").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", BackupOpensearchClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", BackupOpensearchClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateOpensearchClusterResponse createOpensearchCluster(CreateOpensearchClusterRequest request) {
        Objects.requireNonNull(request.getCreateOpensearchClusterDetails(), "createOpensearchClusterDetails is required");
        return (CreateOpensearchClusterResponse)this.clientCall(request, CreateOpensearchClusterResponse::builder).logger(LOG, "createOpensearchCluster").serviceDetails("OpensearchCluster", "CreateOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/CreateOpensearchCluster").method(Method.POST).requestBuilder(CreateOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateOpensearchClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOpensearchClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteOpensearchClusterResponse deleteOpensearchCluster(DeleteOpensearchClusterRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        return (DeleteOpensearchClusterResponse)this.clientCall(request, DeleteOpensearchClusterResponse::builder).logger(LOG, "deleteOpensearchCluster").serviceDetails("OpensearchCluster", "DeleteOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/DeleteOpensearchCluster").method(Method.DELETE).requestBuilder(DeleteOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteOpensearchClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOpensearchClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOpensearchClusterResponse getOpensearchCluster(GetOpensearchClusterRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        return (GetOpensearchClusterResponse)this.clientCall(request, GetOpensearchClusterResponse::builder).logger(LOG, "getOpensearchCluster").serviceDetails("OpensearchCluster", "GetOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/GetOpensearchCluster").method(Method.GET).requestBuilder(GetOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.opensearch.model.OpensearchCluster.class, GetOpensearchClusterResponse.Builder::opensearchCluster).handleResponseHeaderString("etag", GetOpensearchClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOpensearchClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("OpensearchCluster", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListOpensearchClustersResponse listOpensearchClusters(ListOpensearchClustersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOpensearchClustersResponse)this.clientCall(request, ListOpensearchClustersResponse::builder).logger(LOG, "listOpensearchClusters").serviceDetails("OpensearchCluster", "ListOpensearchClusters", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchClusterCollection/ListOpensearchClusters").method(Method.GET).requestBuilder(ListOpensearchClustersRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OpensearchClusterCollection.class, ListOpensearchClustersResponse.Builder::opensearchClusterCollection).handleResponseHeaderString("opc-request-id", ListOpensearchClustersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOpensearchClustersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOpensearchVersionsResponse listOpensearchVersions(ListOpensearchVersionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOpensearchVersionsResponse)this.clientCall(request, ListOpensearchVersionsResponse::builder).logger(LOG, "listOpensearchVersions").serviceDetails("OpensearchCluster", "ListOpensearchVersions", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchVersionsCollection/ListOpensearchVersions").method(Method.GET).requestBuilder(ListOpensearchVersionsRequest::builder).basePath("/20180828").appendPathParam("opensearch").appendPathParam("versions").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).handleBody(OpensearchVersionsCollection.class, ListOpensearchVersionsResponse.Builder::opensearchVersionsCollection).handleResponseHeaderString("opc-request-id", ListOpensearchVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOpensearchVersionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("OpensearchCluster", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("OpensearchCluster", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("OpensearchCluster", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/WorkRequestCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("sourceResourceId", (Object)request.getSourceResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public OpensearchClusterRestoreResponse opensearchClusterRestore(OpensearchClusterRestoreRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestoreOpensearchClusterDetails(), "restoreOpensearchClusterDetails is required");
        return (OpensearchClusterRestoreResponse)this.clientCall(request, OpensearchClusterRestoreResponse::builder).logger(LOG, "opensearchClusterRestore").serviceDetails("OpensearchCluster", "OpensearchClusterRestore", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/OpensearchClusterRestore").method(Method.POST).requestBuilder(OpensearchClusterRestoreRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).appendPathParam("actions").appendPathParam("restore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", OpensearchClusterRestoreResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", OpensearchClusterRestoreResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ResizeOpensearchClusterHorizontalResponse resizeOpensearchClusterHorizontal(ResizeOpensearchClusterHorizontalRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getResizeOpensearchClusterHorizontalDetails(), "resizeOpensearchClusterHorizontalDetails is required");
        return (ResizeOpensearchClusterHorizontalResponse)this.clientCall(request, ResizeOpensearchClusterHorizontalResponse::builder).logger(LOG, "resizeOpensearchClusterHorizontal").serviceDetails("OpensearchCluster", "ResizeOpensearchClusterHorizontal", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/ResizeOpensearchClusterHorizontal").method(Method.POST).requestBuilder(ResizeOpensearchClusterHorizontalRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).appendPathParam("actions").appendPathParam("resizeHorizontal").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ResizeOpensearchClusterHorizontalResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ResizeOpensearchClusterHorizontalResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ResizeOpensearchClusterVerticalResponse resizeOpensearchClusterVertical(ResizeOpensearchClusterVerticalRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getResizeOpensearchClusterVerticalDetails(), "resizeOpensearchClusterVerticalDetails is required");
        return (ResizeOpensearchClusterVerticalResponse)this.clientCall(request, ResizeOpensearchClusterVerticalResponse::builder).logger(LOG, "resizeOpensearchClusterVertical").serviceDetails("OpensearchCluster", "ResizeOpensearchClusterVertical", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/ResizeOpensearchClusterVertical").method(Method.POST).requestBuilder(ResizeOpensearchClusterVerticalRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).appendPathParam("actions").appendPathParam("resizeVertical").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ResizeOpensearchClusterVerticalResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ResizeOpensearchClusterVerticalResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateOpensearchClusterResponse updateOpensearchCluster(UpdateOpensearchClusterRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOpensearchClusterDetails(), "updateOpensearchClusterDetails is required");
        return (UpdateOpensearchClusterResponse)this.clientCall(request, UpdateOpensearchClusterResponse::builder).logger(LOG, "updateOpensearchCluster").serviceDetails("OpensearchCluster", "UpdateOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/UpdateOpensearchCluster").method(Method.PUT).requestBuilder(UpdateOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateOpensearchClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateOpensearchClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public OpensearchClusterWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OpensearchClusterPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OpensearchClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OpensearchClusterClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OpensearchClusterClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OpensearchClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OpensearchClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OpensearchClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OpensearchClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OpensearchClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OpensearchClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OpensearchClusterClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OpensearchClusterClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OpensearchClusterClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

