/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.opensearch.OpensearchClusterAsync;
import com.oracle.bmc.opensearch.model.OpensearchCluster;
import com.oracle.bmc.opensearch.model.OpensearchClusterCollection;
import com.oracle.bmc.opensearch.model.OpensearchVersionsCollection;
import com.oracle.bmc.opensearch.model.WorkRequest;
import com.oracle.bmc.opensearch.model.WorkRequestCollection;
import com.oracle.bmc.opensearch.model.WorkRequestErrorCollection;
import com.oracle.bmc.opensearch.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.opensearch.requests.BackupOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.CreateOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.DeleteOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.GetOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.GetWorkRequestRequest;
import com.oracle.bmc.opensearch.requests.ListOpensearchClustersRequest;
import com.oracle.bmc.opensearch.requests.ListOpensearchVersionsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestsRequest;
import com.oracle.bmc.opensearch.requests.OpensearchClusterRestoreRequest;
import com.oracle.bmc.opensearch.requests.ResizeOpensearchClusterHorizontalRequest;
import com.oracle.bmc.opensearch.requests.ResizeOpensearchClusterVerticalRequest;
import com.oracle.bmc.opensearch.requests.UpdateOpensearchClusterRequest;
import com.oracle.bmc.opensearch.responses.BackupOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.CreateOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.DeleteOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.GetOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.GetWorkRequestResponse;
import com.oracle.bmc.opensearch.responses.ListOpensearchClustersResponse;
import com.oracle.bmc.opensearch.responses.ListOpensearchVersionsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestsResponse;
import com.oracle.bmc.opensearch.responses.OpensearchClusterRestoreResponse;
import com.oracle.bmc.opensearch.responses.ResizeOpensearchClusterHorizontalResponse;
import com.oracle.bmc.opensearch.responses.ResizeOpensearchClusterVerticalResponse;
import com.oracle.bmc.opensearch.responses.UpdateOpensearchClusterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpensearchClusterAsyncClient
extends BaseAsyncClient
implements OpensearchClusterAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPENSEARCHCLUSTER").serviceEndpointPrefix("").serviceEndpointTemplate("https://search-indexing.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OpensearchClusterAsyncClient.class);

    private OpensearchClusterAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<BackupOpensearchClusterResponse> backupOpensearchCluster(BackupOpensearchClusterRequest request, AsyncHandler<BackupOpensearchClusterRequest, BackupOpensearchClusterResponse> handler) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBackupOpensearchClusterDetails(), "backupOpensearchClusterDetails is required");
        return this.clientCall(request, BackupOpensearchClusterResponse::builder).logger(LOG, "backupOpensearchCluster").serviceDetails("OpensearchCluster", "BackupOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/BackupOpensearchCluster").method(Method.POST).requestBuilder(BackupOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).appendPathParam("actions").appendPathParam("backup").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", BackupOpensearchClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", BackupOpensearchClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateOpensearchClusterResponse> createOpensearchCluster(CreateOpensearchClusterRequest request, AsyncHandler<CreateOpensearchClusterRequest, CreateOpensearchClusterResponse> handler) {
        Objects.requireNonNull(request.getCreateOpensearchClusterDetails(), "createOpensearchClusterDetails is required");
        return this.clientCall(request, CreateOpensearchClusterResponse::builder).logger(LOG, "createOpensearchCluster").serviceDetails("OpensearchCluster", "CreateOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/CreateOpensearchCluster").method(Method.POST).requestBuilder(CreateOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateOpensearchClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOpensearchClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOpensearchClusterResponse> deleteOpensearchCluster(DeleteOpensearchClusterRequest request, AsyncHandler<DeleteOpensearchClusterRequest, DeleteOpensearchClusterResponse> handler) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOpensearchClusterResponse::builder).logger(LOG, "deleteOpensearchCluster").serviceDetails("OpensearchCluster", "DeleteOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/DeleteOpensearchCluster").method(Method.DELETE).requestBuilder(DeleteOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteOpensearchClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOpensearchClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOpensearchClusterResponse> getOpensearchCluster(GetOpensearchClusterRequest request, AsyncHandler<GetOpensearchClusterRequest, GetOpensearchClusterResponse> handler) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOpensearchClusterResponse::builder).logger(LOG, "getOpensearchCluster").serviceDetails("OpensearchCluster", "GetOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/GetOpensearchCluster").method(Method.GET).requestBuilder(GetOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OpensearchCluster.class, GetOpensearchClusterResponse.Builder::opensearchCluster).handleResponseHeaderString("etag", GetOpensearchClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOpensearchClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("OpensearchCluster", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListOpensearchClustersResponse> listOpensearchClusters(ListOpensearchClustersRequest request, AsyncHandler<ListOpensearchClustersRequest, ListOpensearchClustersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListOpensearchClustersResponse::builder).logger(LOG, "listOpensearchClusters").serviceDetails("OpensearchCluster", "ListOpensearchClusters", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchClusterCollection/ListOpensearchClusters").method(Method.GET).requestBuilder(ListOpensearchClustersRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OpensearchClusterCollection.class, ListOpensearchClustersResponse.Builder::opensearchClusterCollection).handleResponseHeaderString("opc-request-id", ListOpensearchClustersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOpensearchClustersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListOpensearchVersionsResponse> listOpensearchVersions(ListOpensearchVersionsRequest request, AsyncHandler<ListOpensearchVersionsRequest, ListOpensearchVersionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListOpensearchVersionsResponse::builder).logger(LOG, "listOpensearchVersions").serviceDetails("OpensearchCluster", "ListOpensearchVersions", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchVersionsCollection/ListOpensearchVersions").method(Method.GET).requestBuilder(ListOpensearchVersionsRequest::builder).basePath("/20180828").appendPathParam("opensearch").appendPathParam("versions").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).handleBody(OpensearchVersionsCollection.class, ListOpensearchVersionsResponse.Builder::opensearchVersionsCollection).handleResponseHeaderString("opc-request-id", ListOpensearchVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOpensearchVersionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("OpensearchCluster", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("OpensearchCluster", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("OpensearchCluster", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/WorkRequestCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("sourceResourceId", (Object)request.getSourceResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<OpensearchClusterRestoreResponse> opensearchClusterRestore(OpensearchClusterRestoreRequest request, AsyncHandler<OpensearchClusterRestoreRequest, OpensearchClusterRestoreResponse> handler) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestoreOpensearchClusterDetails(), "restoreOpensearchClusterDetails is required");
        return this.clientCall(request, OpensearchClusterRestoreResponse::builder).logger(LOG, "opensearchClusterRestore").serviceDetails("OpensearchCluster", "OpensearchClusterRestore", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/OpensearchClusterRestore").method(Method.POST).requestBuilder(OpensearchClusterRestoreRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).appendPathParam("actions").appendPathParam("restore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", OpensearchClusterRestoreResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", OpensearchClusterRestoreResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ResizeOpensearchClusterHorizontalResponse> resizeOpensearchClusterHorizontal(ResizeOpensearchClusterHorizontalRequest request, AsyncHandler<ResizeOpensearchClusterHorizontalRequest, ResizeOpensearchClusterHorizontalResponse> handler) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getResizeOpensearchClusterHorizontalDetails(), "resizeOpensearchClusterHorizontalDetails is required");
        return this.clientCall(request, ResizeOpensearchClusterHorizontalResponse::builder).logger(LOG, "resizeOpensearchClusterHorizontal").serviceDetails("OpensearchCluster", "ResizeOpensearchClusterHorizontal", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/ResizeOpensearchClusterHorizontal").method(Method.POST).requestBuilder(ResizeOpensearchClusterHorizontalRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).appendPathParam("actions").appendPathParam("resizeHorizontal").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ResizeOpensearchClusterHorizontalResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ResizeOpensearchClusterHorizontalResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ResizeOpensearchClusterVerticalResponse> resizeOpensearchClusterVertical(ResizeOpensearchClusterVerticalRequest request, AsyncHandler<ResizeOpensearchClusterVerticalRequest, ResizeOpensearchClusterVerticalResponse> handler) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getResizeOpensearchClusterVerticalDetails(), "resizeOpensearchClusterVerticalDetails is required");
        return this.clientCall(request, ResizeOpensearchClusterVerticalResponse::builder).logger(LOG, "resizeOpensearchClusterVertical").serviceDetails("OpensearchCluster", "ResizeOpensearchClusterVertical", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/ResizeOpensearchClusterVertical").method(Method.POST).requestBuilder(ResizeOpensearchClusterVerticalRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).appendPathParam("actions").appendPathParam("resizeVertical").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ResizeOpensearchClusterVerticalResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ResizeOpensearchClusterVerticalResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateOpensearchClusterResponse> updateOpensearchCluster(UpdateOpensearchClusterRequest request, AsyncHandler<UpdateOpensearchClusterRequest, UpdateOpensearchClusterResponse> handler) {
        Validate.notBlank((String)request.getOpensearchClusterId(), (String)"opensearchClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOpensearchClusterDetails(), "updateOpensearchClusterDetails is required");
        return this.clientCall(request, UpdateOpensearchClusterResponse::builder).logger(LOG, "updateOpensearchCluster").serviceDetails("OpensearchCluster", "UpdateOpensearchCluster", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchCluster/UpdateOpensearchCluster").method(Method.PUT).requestBuilder(UpdateOpensearchClusterRequest::builder).basePath("/20180828").appendPathParam("opensearchClusters").appendPathParam(request.getOpensearchClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateOpensearchClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateOpensearchClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OpensearchClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OpensearchClusterAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OpensearchClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OpensearchClusterAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OpensearchClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OpensearchClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OpensearchClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OpensearchClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OpensearchClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OpensearchClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OpensearchClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OpensearchClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OpensearchClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OpensearchClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OpensearchClusterAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OpensearchClusterAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OpensearchClusterAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

