/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opa.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOpaInstanceRequest
extends BmcRequest<Void> {
    private String opaInstanceId;
    private String opcRequestId;

    public String getOpaInstanceId() {
        return this.opaInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().opaInstanceId(this.opaInstanceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opaInstanceId=").append(String.valueOf(this.opaInstanceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOpaInstanceRequest)) {
            return false;
        }
        GetOpaInstanceRequest other = (GetOpaInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opaInstanceId, other.opaInstanceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opaInstanceId == null ? 43 : this.opaInstanceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOpaInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opaInstanceId = null;
        private String opcRequestId = null;

        public Builder opaInstanceId(String opaInstanceId) {
            this.opaInstanceId = opaInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOpaInstanceRequest o) {
            this.opaInstanceId(o.getOpaInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOpaInstanceRequest build() {
            GetOpaInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOpaInstanceRequest buildWithoutInvocationCallback() {
            GetOpaInstanceRequest request = new GetOpaInstanceRequest();
            request.opaInstanceId = this.opaInstanceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

