/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.ons.model.TopicAttributesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateTopicRequest
extends BmcRequest<TopicAttributesDetails> {
    private String topicId;
    private TopicAttributesDetails topicAttributesDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getTopicId() {
        return this.topicId;
    }

    public TopicAttributesDetails getTopicAttributesDetails() {
        return this.topicAttributesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public TopicAttributesDetails getBody$() {
        return this.topicAttributesDetails;
    }

    public Builder toBuilder() {
        return new Builder().topicId(this.topicId).topicAttributesDetails(this.topicAttributesDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",topicId=").append(String.valueOf(this.topicId));
        sb.append(",topicAttributesDetails=").append(String.valueOf((Object)this.topicAttributesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTopicRequest)) {
            return false;
        }
        UpdateTopicRequest other = (UpdateTopicRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.topicId, other.topicId) && Objects.equals((Object)this.topicAttributesDetails, (Object)other.topicAttributesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.topicId == null ? 43 : this.topicId.hashCode());
        result = result * 59 + (this.topicAttributesDetails == null ? 43 : this.topicAttributesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateTopicRequest, TopicAttributesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String topicId = null;
        private TopicAttributesDetails topicAttributesDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public Builder topicAttributesDetails(TopicAttributesDetails topicAttributesDetails) {
            this.topicAttributesDetails = topicAttributesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTopicRequest o) {
            this.topicId(o.getTopicId());
            this.topicAttributesDetails(o.getTopicAttributesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTopicRequest build() {
            UpdateTopicRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TopicAttributesDetails body) {
            this.topicAttributesDetails(body);
            return this;
        }

        public UpdateTopicRequest buildWithoutInvocationCallback() {
            UpdateTopicRequest request = new UpdateTopicRequest();
            request.topicId = this.topicId;
            request.topicAttributesDetails = this.topicAttributesDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

