/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.ons.model.MessageDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PublishMessageRequest
extends BmcRequest<MessageDetails> {
    private String topicId;
    private MessageDetails messageDetails;
    private String opcRequestId;
    private MessageType messageType;

    public String getTopicId() {
        return this.topicId;
    }

    public MessageDetails getMessageDetails() {
        return this.messageDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    @InternalSdk
    public MessageDetails getBody$() {
        return this.messageDetails;
    }

    public Builder toBuilder() {
        return new Builder().topicId(this.topicId).messageDetails(this.messageDetails).opcRequestId(this.opcRequestId).messageType(this.messageType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",topicId=").append(String.valueOf(this.topicId));
        sb.append(",messageDetails=").append(String.valueOf((Object)this.messageDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",messageType=").append(String.valueOf((Object)this.messageType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishMessageRequest)) {
            return false;
        }
        PublishMessageRequest other = (PublishMessageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.topicId, other.topicId) && Objects.equals((Object)this.messageDetails, (Object)other.messageDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.messageType, (Object)other.messageType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.topicId == null ? 43 : this.topicId.hashCode());
        result = result * 59 + (this.messageDetails == null ? 43 : this.messageDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.messageType == null ? 43 : this.messageType.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PublishMessageRequest, MessageDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String topicId = null;
        private MessageDetails messageDetails = null;
        private String opcRequestId = null;
        private MessageType messageType = null;

        public Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public Builder messageDetails(MessageDetails messageDetails) {
            this.messageDetails = messageDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PublishMessageRequest o) {
            this.topicId(o.getTopicId());
            this.messageDetails(o.getMessageDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.messageType(o.getMessageType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PublishMessageRequest build() {
            PublishMessageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(MessageDetails body) {
            this.messageDetails(body);
            return this;
        }

        public PublishMessageRequest buildWithoutInvocationCallback() {
            PublishMessageRequest request = new PublishMessageRequest();
            request.topicId = this.topicId;
            request.messageDetails = this.messageDetails;
            request.opcRequestId = this.opcRequestId;
            request.messageType = this.messageType;
            return request;
        }
    }

    public static enum MessageType implements BmcEnum
    {
        Json("JSON"),
        RawText("RAW_TEXT");

        private final String value;
        private static Map<String, MessageType> map;

        private MessageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MessageType: " + key);
        }

        static {
            map = new HashMap<String, MessageType>();
            for (MessageType v : MessageType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

