/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GetSubscribedServiceRequest
extends BmcRequest<Void> {
    private String subscribedServiceId;
    private List<String> fields;
    private String opcRequestId;

    public String getSubscribedServiceId() {
        return this.subscribedServiceId;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().subscribedServiceId(this.subscribedServiceId).fields(this.fields).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",subscribedServiceId=").append(String.valueOf(this.subscribedServiceId));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSubscribedServiceRequest)) {
            return false;
        }
        GetSubscribedServiceRequest other = (GetSubscribedServiceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.subscribedServiceId, other.subscribedServiceId) && Objects.equals(this.fields, other.fields) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.subscribedServiceId == null ? 43 : this.subscribedServiceId.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSubscribedServiceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String subscribedServiceId = null;
        private List<String> fields = null;
        private String opcRequestId = null;

        public Builder subscribedServiceId(String subscribedServiceId) {
            this.subscribedServiceId = subscribedServiceId;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSubscribedServiceRequest o) {
            this.subscribedServiceId(o.getSubscribedServiceId());
            this.fields(o.getFields());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSubscribedServiceRequest build() {
            GetSubscribedServiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSubscribedServiceRequest buildWithoutInvocationCallback() {
            GetSubscribedServiceRequest request = new GetSubscribedServiceRequest();
            request.subscribedServiceId = this.subscribedServiceId;
            request.fields = this.fields;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

