/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InvoicingProduct
extends ExplicitlySetBmcModel {
    @JsonProperty(value="partNumber")
    private final String partNumber;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="unitOfMeasure")
    private final String unitOfMeasure;
    @JsonProperty(value="billingCategory")
    private final String billingCategory;
    @JsonProperty(value="productCategory")
    private final String productCategory;
    @JsonProperty(value="ucmRateCardPartType")
    private final String ucmRateCardPartType;

    @Deprecated
    @ConstructorProperties(value={"partNumber", "name", "unitOfMeasure", "billingCategory", "productCategory", "ucmRateCardPartType"})
    public InvoicingProduct(String partNumber, String name, String unitOfMeasure, String billingCategory, String productCategory, String ucmRateCardPartType) {
        this.partNumber = partNumber;
        this.name = name;
        this.unitOfMeasure = unitOfMeasure;
        this.billingCategory = billingCategory;
        this.productCategory = productCategory;
        this.ucmRateCardPartType = ucmRateCardPartType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public String getBillingCategory() {
        return this.billingCategory;
    }

    public String getProductCategory() {
        return this.productCategory;
    }

    public String getUcmRateCardPartType() {
        return this.ucmRateCardPartType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InvoicingProduct(");
        sb.append("super=").append(super.toString());
        sb.append("partNumber=").append(String.valueOf(this.partNumber));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", unitOfMeasure=").append(String.valueOf(this.unitOfMeasure));
        sb.append(", billingCategory=").append(String.valueOf(this.billingCategory));
        sb.append(", productCategory=").append(String.valueOf(this.productCategory));
        sb.append(", ucmRateCardPartType=").append(String.valueOf(this.ucmRateCardPartType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvoicingProduct)) {
            return false;
        }
        InvoicingProduct other = (InvoicingProduct)((Object)o);
        return Objects.equals(this.partNumber, other.partNumber) && Objects.equals(this.name, other.name) && Objects.equals(this.unitOfMeasure, other.unitOfMeasure) && Objects.equals(this.billingCategory, other.billingCategory) && Objects.equals(this.productCategory, other.productCategory) && Objects.equals(this.ucmRateCardPartType, other.ucmRateCardPartType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.partNumber == null ? 43 : this.partNumber.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.unitOfMeasure == null ? 43 : this.unitOfMeasure.hashCode());
        result = result * 59 + (this.billingCategory == null ? 43 : this.billingCategory.hashCode());
        result = result * 59 + (this.productCategory == null ? 43 : this.productCategory.hashCode());
        result = result * 59 + (this.ucmRateCardPartType == null ? 43 : this.ucmRateCardPartType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="partNumber")
        private String partNumber;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="unitOfMeasure")
        private String unitOfMeasure;
        @JsonProperty(value="billingCategory")
        private String billingCategory;
        @JsonProperty(value="productCategory")
        private String productCategory;
        @JsonProperty(value="ucmRateCardPartType")
        private String ucmRateCardPartType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder partNumber(String partNumber) {
            this.partNumber = partNumber;
            this.__explicitlySet__.add("partNumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder unitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            this.__explicitlySet__.add("unitOfMeasure");
            return this;
        }

        public Builder billingCategory(String billingCategory) {
            this.billingCategory = billingCategory;
            this.__explicitlySet__.add("billingCategory");
            return this;
        }

        public Builder productCategory(String productCategory) {
            this.productCategory = productCategory;
            this.__explicitlySet__.add("productCategory");
            return this;
        }

        public Builder ucmRateCardPartType(String ucmRateCardPartType) {
            this.ucmRateCardPartType = ucmRateCardPartType;
            this.__explicitlySet__.add("ucmRateCardPartType");
            return this;
        }

        public InvoicingProduct build() {
            InvoicingProduct model = new InvoicingProduct(this.partNumber, this.name, this.unitOfMeasure, this.billingCategory, this.productCategory, this.ucmRateCardPartType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InvoicingProduct model) {
            if (model.wasPropertyExplicitlySet("partNumber")) {
                this.partNumber(model.getPartNumber());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("unitOfMeasure")) {
                this.unitOfMeasure(model.getUnitOfMeasure());
            }
            if (model.wasPropertyExplicitlySet("billingCategory")) {
                this.billingCategory(model.getBillingCategory());
            }
            if (model.wasPropertyExplicitlySet("productCategory")) {
                this.productCategory(model.getProductCategory());
            }
            if (model.wasPropertyExplicitlySet("ucmRateCardPartType")) {
                this.ucmRateCardPartType(model.getUcmRateCardPartType());
            }
            return this;
        }
    }
}

