/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.onesubscription.model.InvoicingProduct;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InvoicelineComputedUsageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="parentProduct")
    private final InvoicingProduct parentProduct;
    @JsonProperty(value="product")
    private final InvoicingProduct product;
    @JsonProperty(value="quantity")
    private final Double quantity;
    @JsonProperty(value="netUnitPrice")
    private final Double netUnitPrice;
    @JsonProperty(value="timeMeteredOn")
    private final Date timeMeteredOn;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="cost")
    private final Double cost;
    @JsonProperty(value="costRounded")
    private final Double costRounded;

    @Deprecated
    @ConstructorProperties(value={"parentProduct", "product", "quantity", "netUnitPrice", "timeMeteredOn", "type", "cost", "costRounded"})
    public InvoicelineComputedUsageSummary(InvoicingProduct parentProduct, InvoicingProduct product, Double quantity, Double netUnitPrice, Date timeMeteredOn, Type type, Double cost, Double costRounded) {
        this.parentProduct = parentProduct;
        this.product = product;
        this.quantity = quantity;
        this.netUnitPrice = netUnitPrice;
        this.timeMeteredOn = timeMeteredOn;
        this.type = type;
        this.cost = cost;
        this.costRounded = costRounded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public InvoicingProduct getParentProduct() {
        return this.parentProduct;
    }

    public InvoicingProduct getProduct() {
        return this.product;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public Double getNetUnitPrice() {
        return this.netUnitPrice;
    }

    public Date getTimeMeteredOn() {
        return this.timeMeteredOn;
    }

    public Type getType() {
        return this.type;
    }

    public Double getCost() {
        return this.cost;
    }

    public Double getCostRounded() {
        return this.costRounded;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InvoicelineComputedUsageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("parentProduct=").append(String.valueOf((Object)this.parentProduct));
        sb.append(", product=").append(String.valueOf((Object)this.product));
        sb.append(", quantity=").append(String.valueOf(this.quantity));
        sb.append(", netUnitPrice=").append(String.valueOf(this.netUnitPrice));
        sb.append(", timeMeteredOn=").append(String.valueOf(this.timeMeteredOn));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", cost=").append(String.valueOf(this.cost));
        sb.append(", costRounded=").append(String.valueOf(this.costRounded));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvoicelineComputedUsageSummary)) {
            return false;
        }
        InvoicelineComputedUsageSummary other = (InvoicelineComputedUsageSummary)((Object)o);
        return Objects.equals((Object)this.parentProduct, (Object)other.parentProduct) && Objects.equals((Object)this.product, (Object)other.product) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.netUnitPrice, other.netUnitPrice) && Objects.equals(this.timeMeteredOn, other.timeMeteredOn) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.cost, other.cost) && Objects.equals(this.costRounded, other.costRounded) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.parentProduct == null ? 43 : this.parentProduct.hashCode());
        result = result * 59 + (this.product == null ? 43 : this.product.hashCode());
        result = result * 59 + (this.quantity == null ? 43 : this.quantity.hashCode());
        result = result * 59 + (this.netUnitPrice == null ? 43 : this.netUnitPrice.hashCode());
        result = result * 59 + (this.timeMeteredOn == null ? 43 : this.timeMeteredOn.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.cost == null ? 43 : this.cost.hashCode());
        result = result * 59 + (this.costRounded == null ? 43 : this.costRounded.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Promotion("PROMOTION"),
        DoNotBill("DO_NOT_BILL"),
        Usage("USAGE"),
        Commit("COMMIT"),
        Overage("OVERAGE"),
        PayAsYouGo("PAY_AS_YOU_GO"),
        MonthlyMinimum("MONTHLY_MINIMUM"),
        DelayedUsageInvoiceTiming("DELAYED_USAGE_INVOICE_TIMING"),
        DelayedUsageCommitmentExp("DELAYED_USAGE_COMMITMENT_EXP"),
        OnAccountCredit("ON_ACCOUNT_CREDIT"),
        ServiceCredit("SERVICE_CREDIT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="parentProduct")
        private InvoicingProduct parentProduct;
        @JsonProperty(value="product")
        private InvoicingProduct product;
        @JsonProperty(value="quantity")
        private Double quantity;
        @JsonProperty(value="netUnitPrice")
        private Double netUnitPrice;
        @JsonProperty(value="timeMeteredOn")
        private Date timeMeteredOn;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="cost")
        private Double cost;
        @JsonProperty(value="costRounded")
        private Double costRounded;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder parentProduct(InvoicingProduct parentProduct) {
            this.parentProduct = parentProduct;
            this.__explicitlySet__.add("parentProduct");
            return this;
        }

        public Builder product(InvoicingProduct product) {
            this.product = product;
            this.__explicitlySet__.add("product");
            return this;
        }

        public Builder quantity(Double quantity) {
            this.quantity = quantity;
            this.__explicitlySet__.add("quantity");
            return this;
        }

        public Builder netUnitPrice(Double netUnitPrice) {
            this.netUnitPrice = netUnitPrice;
            this.__explicitlySet__.add("netUnitPrice");
            return this;
        }

        public Builder timeMeteredOn(Date timeMeteredOn) {
            this.timeMeteredOn = timeMeteredOn;
            this.__explicitlySet__.add("timeMeteredOn");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder cost(Double cost) {
            this.cost = cost;
            this.__explicitlySet__.add("cost");
            return this;
        }

        public Builder costRounded(Double costRounded) {
            this.costRounded = costRounded;
            this.__explicitlySet__.add("costRounded");
            return this;
        }

        public InvoicelineComputedUsageSummary build() {
            InvoicelineComputedUsageSummary model = new InvoicelineComputedUsageSummary(this.parentProduct, this.product, this.quantity, this.netUnitPrice, this.timeMeteredOn, this.type, this.cost, this.costRounded);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InvoicelineComputedUsageSummary model) {
            if (model.wasPropertyExplicitlySet("parentProduct")) {
                this.parentProduct(model.getParentProduct());
            }
            if (model.wasPropertyExplicitlySet("product")) {
                this.product(model.getProduct());
            }
            if (model.wasPropertyExplicitlySet("quantity")) {
                this.quantity(model.getQuantity());
            }
            if (model.wasPropertyExplicitlySet("netUnitPrice")) {
                this.netUnitPrice(model.getNetUnitPrice());
            }
            if (model.wasPropertyExplicitlySet("timeMeteredOn")) {
                this.timeMeteredOn(model.getTimeMeteredOn());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("cost")) {
                this.cost(model.getCost());
            }
            if (model.wasPropertyExplicitlySet("costRounded")) {
                this.costRounded(model.getCostRounded());
            }
            return this;
        }
    }
}

