/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.onesubscription.model.ComputedUsageProduct;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComputedUsageAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="quantity")
    private final String quantity;
    @JsonProperty(value="product")
    private final ComputedUsageProduct product;
    @JsonProperty(value="dataCenter")
    private final String dataCenter;
    @JsonProperty(value="timeMeteredOn")
    private final Date timeMeteredOn;
    @JsonProperty(value="netUnitPrice")
    private final String netUnitPrice;
    @JsonProperty(value="costUnrounded")
    private final String costUnrounded;
    @JsonProperty(value="cost")
    private final String cost;
    @JsonProperty(value="type")
    private final Type type;

    @Deprecated
    @ConstructorProperties(value={"quantity", "product", "dataCenter", "timeMeteredOn", "netUnitPrice", "costUnrounded", "cost", "type"})
    public ComputedUsageAggregation(String quantity, ComputedUsageProduct product, String dataCenter, Date timeMeteredOn, String netUnitPrice, String costUnrounded, String cost, Type type) {
        this.quantity = quantity;
        this.product = product;
        this.dataCenter = dataCenter;
        this.timeMeteredOn = timeMeteredOn;
        this.netUnitPrice = netUnitPrice;
        this.costUnrounded = costUnrounded;
        this.cost = cost;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getQuantity() {
        return this.quantity;
    }

    public ComputedUsageProduct getProduct() {
        return this.product;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public Date getTimeMeteredOn() {
        return this.timeMeteredOn;
    }

    public String getNetUnitPrice() {
        return this.netUnitPrice;
    }

    public String getCostUnrounded() {
        return this.costUnrounded;
    }

    public String getCost() {
        return this.cost;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComputedUsageAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("quantity=").append(String.valueOf(this.quantity));
        sb.append(", product=").append(String.valueOf((Object)this.product));
        sb.append(", dataCenter=").append(String.valueOf(this.dataCenter));
        sb.append(", timeMeteredOn=").append(String.valueOf(this.timeMeteredOn));
        sb.append(", netUnitPrice=").append(String.valueOf(this.netUnitPrice));
        sb.append(", costUnrounded=").append(String.valueOf(this.costUnrounded));
        sb.append(", cost=").append(String.valueOf(this.cost));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComputedUsageAggregation)) {
            return false;
        }
        ComputedUsageAggregation other = (ComputedUsageAggregation)((Object)o);
        return Objects.equals(this.quantity, other.quantity) && Objects.equals((Object)this.product, (Object)other.product) && Objects.equals(this.dataCenter, other.dataCenter) && Objects.equals(this.timeMeteredOn, other.timeMeteredOn) && Objects.equals(this.netUnitPrice, other.netUnitPrice) && Objects.equals(this.costUnrounded, other.costUnrounded) && Objects.equals(this.cost, other.cost) && Objects.equals((Object)this.type, (Object)other.type) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.quantity == null ? 43 : this.quantity.hashCode());
        result = result * 59 + (this.product == null ? 43 : this.product.hashCode());
        result = result * 59 + (this.dataCenter == null ? 43 : this.dataCenter.hashCode());
        result = result * 59 + (this.timeMeteredOn == null ? 43 : this.timeMeteredOn.hashCode());
        result = result * 59 + (this.netUnitPrice == null ? 43 : this.netUnitPrice.hashCode());
        result = result * 59 + (this.costUnrounded == null ? 43 : this.costUnrounded.hashCode());
        result = result * 59 + (this.cost == null ? 43 : this.cost.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Promotion("PROMOTION"),
        DoNotBill("DO_NOT_BILL"),
        Usage("USAGE"),
        Commit("COMMIT"),
        Overage("OVERAGE"),
        PayAsYouGo("PAY_AS_YOU_GO"),
        MonthlyMinimum("MONTHLY_MINIMUM"),
        DelayedUsageInvoiceTiming("DELAYED_USAGE_INVOICE_TIMING"),
        DelayedUsageCommitmentExp("DELAYED_USAGE_COMMITMENT_EXP"),
        OnAccountCredit("ON_ACCOUNT_CREDIT"),
        ServiceCredit("SERVICE_CREDIT"),
        CommitmentExpiration("COMMITMENT_EXPIRATION"),
        FundedAllocation("FUNDED_ALLOCATION"),
        DonotBillUsagePostTermination("DONOT_BILL_USAGE_POST_TERMINATION"),
        DelayedUsagePostTermination("DELAYED_USAGE_POST_TERMINATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="quantity")
        private String quantity;
        @JsonProperty(value="product")
        private ComputedUsageProduct product;
        @JsonProperty(value="dataCenter")
        private String dataCenter;
        @JsonProperty(value="timeMeteredOn")
        private Date timeMeteredOn;
        @JsonProperty(value="netUnitPrice")
        private String netUnitPrice;
        @JsonProperty(value="costUnrounded")
        private String costUnrounded;
        @JsonProperty(value="cost")
        private String cost;
        @JsonProperty(value="type")
        private Type type;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            this.__explicitlySet__.add("quantity");
            return this;
        }

        public Builder product(ComputedUsageProduct product) {
            this.product = product;
            this.__explicitlySet__.add("product");
            return this;
        }

        public Builder dataCenter(String dataCenter) {
            this.dataCenter = dataCenter;
            this.__explicitlySet__.add("dataCenter");
            return this;
        }

        public Builder timeMeteredOn(Date timeMeteredOn) {
            this.timeMeteredOn = timeMeteredOn;
            this.__explicitlySet__.add("timeMeteredOn");
            return this;
        }

        public Builder netUnitPrice(String netUnitPrice) {
            this.netUnitPrice = netUnitPrice;
            this.__explicitlySet__.add("netUnitPrice");
            return this;
        }

        public Builder costUnrounded(String costUnrounded) {
            this.costUnrounded = costUnrounded;
            this.__explicitlySet__.add("costUnrounded");
            return this;
        }

        public Builder cost(String cost) {
            this.cost = cost;
            this.__explicitlySet__.add("cost");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public ComputedUsageAggregation build() {
            ComputedUsageAggregation model = new ComputedUsageAggregation(this.quantity, this.product, this.dataCenter, this.timeMeteredOn, this.netUnitPrice, this.costUnrounded, this.cost, this.type);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComputedUsageAggregation model) {
            if (model.wasPropertyExplicitlySet("quantity")) {
                this.quantity(model.getQuantity());
            }
            if (model.wasPropertyExplicitlySet("product")) {
                this.product(model.getProduct());
            }
            if (model.wasPropertyExplicitlySet("dataCenter")) {
                this.dataCenter(model.getDataCenter());
            }
            if (model.wasPropertyExplicitlySet("timeMeteredOn")) {
                this.timeMeteredOn(model.getTimeMeteredOn());
            }
            if (model.wasPropertyExplicitlySet("netUnitPrice")) {
                this.netUnitPrice(model.getNetUnitPrice());
            }
            if (model.wasPropertyExplicitlySet("costUnrounded")) {
                this.costUnrounded(model.getCostUnrounded());
            }
            if (model.wasPropertyExplicitlySet("cost")) {
                this.cost(model.getCost());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            return this;
        }
    }
}

