/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.ocvp.model.HcxLicenseStatus;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HcxLicenseSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="activationKey")
    private final String activationKey;
    @JsonProperty(value="status")
    private final HcxLicenseStatus status;
    @JsonProperty(value="systemName")
    private final String systemName;

    @Deprecated
    @ConstructorProperties(value={"activationKey", "status", "systemName"})
    public HcxLicenseSummary(String activationKey, HcxLicenseStatus status, String systemName) {
        this.activationKey = activationKey;
        this.status = status;
        this.systemName = systemName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public HcxLicenseStatus getStatus() {
        return this.status;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HcxLicenseSummary(");
        sb.append("super=").append(super.toString());
        sb.append("activationKey=").append(String.valueOf(this.activationKey));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", systemName=").append(String.valueOf(this.systemName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HcxLicenseSummary)) {
            return false;
        }
        HcxLicenseSummary other = (HcxLicenseSummary)((Object)o);
        return Objects.equals(this.activationKey, other.activationKey) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.systemName, other.systemName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.activationKey == null ? 43 : this.activationKey.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.systemName == null ? 43 : this.systemName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="activationKey")
        private String activationKey;
        @JsonProperty(value="status")
        private HcxLicenseStatus status;
        @JsonProperty(value="systemName")
        private String systemName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder activationKey(String activationKey) {
            this.activationKey = activationKey;
            this.__explicitlySet__.add("activationKey");
            return this;
        }

        public Builder status(HcxLicenseStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder systemName(String systemName) {
            this.systemName = systemName;
            this.__explicitlySet__.add("systemName");
            return this;
        }

        public HcxLicenseSummary build() {
            HcxLicenseSummary model = new HcxLicenseSummary(this.activationKey, this.status, this.systemName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HcxLicenseSummary model) {
            if (model.wasPropertyExplicitlySet("activationKey")) {
                this.activationKey(model.getActivationKey());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("systemName")) {
                this.systemName(model.getSystemName());
            }
            return this;
        }
    }
}

