/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce;

import com.oracle.bmc.oce.OceInstance;
import com.oracle.bmc.oce.model.LifecycleState;
import com.oracle.bmc.oce.requests.GetOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetWorkRequestRequest;
import com.oracle.bmc.oce.responses.GetOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OceInstanceWaiters {
    private final ExecutorService executorService;
    private final OceInstance client;

    public OceInstanceWaiters(ExecutorService executorService, OceInstance client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOceInstanceRequest, GetOceInstanceResponse> forOceInstance(GetOceInstanceRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOceInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOceInstanceRequest, GetOceInstanceResponse> forOceInstance(GetOceInstanceRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOceInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOceInstanceRequest, GetOceInstanceResponse> forOceInstance(GetOceInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOceInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOceInstanceRequest, GetOceInstanceResponse> forOceInstance(BmcGenericWaiter waiter, GetOceInstanceRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOceInstanceRequest, GetOceInstanceResponse>(){

            @Override
            public GetOceInstanceResponse apply(GetOceInstanceRequest request) {
                return OceInstanceWaiters.this.client.getOceInstance(request);
            }
        }, (Predicate)new Predicate<GetOceInstanceResponse>(){

            @Override
            public boolean test(GetOceInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getOceInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return OceInstanceWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

