/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.responses;

import com.oracle.bmc.mysql.model.Configuration;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateConfigurationResponse
extends BmcResponse {
    private String location;
    private String etag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private Configuration configuration;

    public String getLocation() {
        return this.location;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "location", "etag", "opcRequestId", "opcWorkRequestId", "configuration"})
    private CreateConfigurationResponse(int __httpStatusCode__, Map<String, List<String>> headers, String location, String etag, String opcRequestId, String opcWorkRequestId, Configuration configuration) {
        super(__httpStatusCode__, headers);
        this.location = location;
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.configuration = configuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",configuration=").append(String.valueOf((Object)this.configuration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateConfigurationResponse)) {
            return false;
        }
        CreateConfigurationResponse other = (CreateConfigurationResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.location, other.location) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals((Object)this.configuration, (Object)other.configuration);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.configuration == null ? 43 : this.configuration.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateConfigurationResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String location;
        private String etag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private Configuration configuration;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder copy(CreateConfigurationResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.location(o.getLocation());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.configuration(o.getConfiguration());
            return this;
        }

        public CreateConfigurationResponse build() {
            return new CreateConfigurationResponse(this.__httpStatusCode__, this.headers, this.location, this.etag, this.opcRequestId, this.opcWorkRequestId, this.configuration);
        }
    }
}

