/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.mysql.model.DbSystem;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDbSystemsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private Boolean isAnalyticsClusterAttached;
    private Boolean isHeatWaveClusterAttached;
    private String dbSystemId;
    private String displayName;
    private DbSystem.LifecycleState lifecycleState;
    private String configurationId;
    private Boolean isUpToDate;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsAnalyticsClusterAttached() {
        return this.isAnalyticsClusterAttached;
    }

    public Boolean getIsHeatWaveClusterAttached() {
        return this.isHeatWaveClusterAttached;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DbSystem.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public Boolean getIsUpToDate() {
        return this.isUpToDate;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).isAnalyticsClusterAttached(this.isAnalyticsClusterAttached).isHeatWaveClusterAttached(this.isHeatWaveClusterAttached).dbSystemId(this.dbSystemId).displayName(this.displayName).lifecycleState(this.lifecycleState).configurationId(this.configurationId).isUpToDate(this.isUpToDate).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isAnalyticsClusterAttached=").append(String.valueOf(this.isAnalyticsClusterAttached));
        sb.append(",isHeatWaveClusterAttached=").append(String.valueOf(this.isHeatWaveClusterAttached));
        sb.append(",dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",configurationId=").append(String.valueOf(this.configurationId));
        sb.append(",isUpToDate=").append(String.valueOf(this.isUpToDate));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDbSystemsRequest)) {
            return false;
        }
        ListDbSystemsRequest other = (ListDbSystemsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isAnalyticsClusterAttached, other.isAnalyticsClusterAttached) && Objects.equals(this.isHeatWaveClusterAttached, other.isHeatWaveClusterAttached) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.configurationId, other.configurationId) && Objects.equals(this.isUpToDate, other.isUpToDate) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isAnalyticsClusterAttached == null ? 43 : this.isAnalyticsClusterAttached.hashCode());
        result = result * 59 + (this.isHeatWaveClusterAttached == null ? 43 : this.isHeatWaveClusterAttached.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.configurationId == null ? 43 : this.configurationId.hashCode());
        result = result * 59 + (this.isUpToDate == null ? 43 : this.isUpToDate.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbSystemsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private Boolean isAnalyticsClusterAttached = null;
        private Boolean isHeatWaveClusterAttached = null;
        private String dbSystemId = null;
        private String displayName = null;
        private DbSystem.LifecycleState lifecycleState = null;
        private String configurationId = null;
        private Boolean isUpToDate = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isAnalyticsClusterAttached(Boolean isAnalyticsClusterAttached) {
            this.isAnalyticsClusterAttached = isAnalyticsClusterAttached;
            return this;
        }

        public Builder isHeatWaveClusterAttached(Boolean isHeatWaveClusterAttached) {
            this.isHeatWaveClusterAttached = isHeatWaveClusterAttached;
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(DbSystem.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public Builder isUpToDate(Boolean isUpToDate) {
            this.isUpToDate = isUpToDate;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbSystemsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.isAnalyticsClusterAttached(o.getIsAnalyticsClusterAttached());
            this.isHeatWaveClusterAttached(o.getIsHeatWaveClusterAttached());
            this.dbSystemId(o.getDbSystemId());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.configurationId(o.getConfigurationId());
            this.isUpToDate(o.getIsUpToDate());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbSystemsRequest build() {
            ListDbSystemsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDbSystemsRequest buildWithoutInvocationCallback() {
            ListDbSystemsRequest request = new ListDbSystemsRequest();
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.isAnalyticsClusterAttached = this.isAnalyticsClusterAttached;
            request.isHeatWaveClusterAttached = this.isHeatWaveClusterAttached;
            request.dbSystemId = this.dbSystemId;
            request.displayName = this.displayName;
            request.lifecycleState = this.lifecycleState;
            request.configurationId = this.configurationId;
            request.isUpToDate = this.isUpToDate;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DisplayName("displayName"),
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

