/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.mysql.model.BackupPolicy;
import com.oracle.bmc.mysql.model.CrashRecoveryStatus;
import com.oracle.bmc.mysql.model.DbSystemEndpoint;
import com.oracle.bmc.mysql.model.DeletionPolicyDetails;
import com.oracle.bmc.mysql.model.MaintenanceDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemSnapshot
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="mysqlVersion")
    private final String mysqlVersion;
    @JsonProperty(value="adminUsername")
    private final String adminUsername;
    @JsonProperty(value="backupPolicy")
    private final BackupPolicy backupPolicy;
    @JsonProperty(value="configurationId")
    private final String configurationId;
    @JsonProperty(value="dataStorageSizeInGBs")
    private final Integer dataStorageSizeInGBs;
    @JsonProperty(value="hostnameLabel")
    private final String hostnameLabel;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="portX")
    private final Integer portX;
    @JsonProperty(value="isHighlyAvailable")
    private final Boolean isHighlyAvailable;
    @JsonProperty(value="endpoints")
    private final List<DbSystemEndpoint> endpoints;
    @JsonProperty(value="maintenance")
    private final MaintenanceDetails maintenance;
    @JsonProperty(value="deletionPolicy")
    private final DeletionPolicyDetails deletionPolicy;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="crashRecovery")
    private final CrashRecoveryStatus crashRecovery;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "compartmentId", "subnetId", "availabilityDomain", "faultDomain", "shapeName", "mysqlVersion", "adminUsername", "backupPolicy", "configurationId", "dataStorageSizeInGBs", "hostnameLabel", "ipAddress", "port", "portX", "isHighlyAvailable", "endpoints", "maintenance", "deletionPolicy", "freeformTags", "definedTags", "crashRecovery"})
    public DbSystemSnapshot(String id, String displayName, String description, String compartmentId, String subnetId, String availabilityDomain, String faultDomain, String shapeName, String mysqlVersion, String adminUsername, BackupPolicy backupPolicy, String configurationId, Integer dataStorageSizeInGBs, String hostnameLabel, String ipAddress, Integer port, Integer portX, Boolean isHighlyAvailable, List<DbSystemEndpoint> endpoints, MaintenanceDetails maintenance, DeletionPolicyDetails deletionPolicy, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, CrashRecoveryStatus crashRecovery) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.compartmentId = compartmentId;
        this.subnetId = subnetId;
        this.availabilityDomain = availabilityDomain;
        this.faultDomain = faultDomain;
        this.shapeName = shapeName;
        this.mysqlVersion = mysqlVersion;
        this.adminUsername = adminUsername;
        this.backupPolicy = backupPolicy;
        this.configurationId = configurationId;
        this.dataStorageSizeInGBs = dataStorageSizeInGBs;
        this.hostnameLabel = hostnameLabel;
        this.ipAddress = ipAddress;
        this.port = port;
        this.portX = portX;
        this.isHighlyAvailable = isHighlyAvailable;
        this.endpoints = endpoints;
        this.maintenance = maintenance;
        this.deletionPolicy = deletionPolicy;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.crashRecovery = crashRecovery;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public String getMysqlVersion() {
        return this.mysqlVersion;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public Integer getDataStorageSizeInGBs() {
        return this.dataStorageSizeInGBs;
    }

    public String getHostnameLabel() {
        return this.hostnameLabel;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getPortX() {
        return this.portX;
    }

    public Boolean getIsHighlyAvailable() {
        return this.isHighlyAvailable;
    }

    public List<DbSystemEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public MaintenanceDetails getMaintenance() {
        return this.maintenance;
    }

    public DeletionPolicyDetails getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public CrashRecoveryStatus getCrashRecovery() {
        return this.crashRecovery;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystemSnapshot(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", mysqlVersion=").append(String.valueOf(this.mysqlVersion));
        sb.append(", adminUsername=").append(String.valueOf(this.adminUsername));
        sb.append(", backupPolicy=").append(String.valueOf((Object)this.backupPolicy));
        sb.append(", configurationId=").append(String.valueOf(this.configurationId));
        sb.append(", dataStorageSizeInGBs=").append(String.valueOf(this.dataStorageSizeInGBs));
        sb.append(", hostnameLabel=").append(String.valueOf(this.hostnameLabel));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", portX=").append(String.valueOf(this.portX));
        sb.append(", isHighlyAvailable=").append(String.valueOf(this.isHighlyAvailable));
        sb.append(", endpoints=").append(String.valueOf(this.endpoints));
        sb.append(", maintenance=").append(String.valueOf((Object)this.maintenance));
        sb.append(", deletionPolicy=").append(String.valueOf((Object)this.deletionPolicy));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", crashRecovery=").append(String.valueOf((Object)this.crashRecovery));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystemSnapshot)) {
            return false;
        }
        DbSystemSnapshot other = (DbSystemSnapshot)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.shapeName, other.shapeName) && Objects.equals(this.mysqlVersion, other.mysqlVersion) && Objects.equals(this.adminUsername, other.adminUsername) && Objects.equals((Object)this.backupPolicy, (Object)other.backupPolicy) && Objects.equals(this.configurationId, other.configurationId) && Objects.equals(this.dataStorageSizeInGBs, other.dataStorageSizeInGBs) && Objects.equals(this.hostnameLabel, other.hostnameLabel) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.port, other.port) && Objects.equals(this.portX, other.portX) && Objects.equals(this.isHighlyAvailable, other.isHighlyAvailable) && Objects.equals(this.endpoints, other.endpoints) && Objects.equals((Object)this.maintenance, (Object)other.maintenance) && Objects.equals((Object)this.deletionPolicy, (Object)other.deletionPolicy) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.crashRecovery, (Object)other.crashRecovery) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.mysqlVersion == null ? 43 : this.mysqlVersion.hashCode());
        result = result * 59 + (this.adminUsername == null ? 43 : this.adminUsername.hashCode());
        result = result * 59 + (this.backupPolicy == null ? 43 : this.backupPolicy.hashCode());
        result = result * 59 + (this.configurationId == null ? 43 : this.configurationId.hashCode());
        result = result * 59 + (this.dataStorageSizeInGBs == null ? 43 : this.dataStorageSizeInGBs.hashCode());
        result = result * 59 + (this.hostnameLabel == null ? 43 : this.hostnameLabel.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.portX == null ? 43 : this.portX.hashCode());
        result = result * 59 + (this.isHighlyAvailable == null ? 43 : this.isHighlyAvailable.hashCode());
        result = result * 59 + (this.endpoints == null ? 43 : this.endpoints.hashCode());
        result = result * 59 + (this.maintenance == null ? 43 : this.maintenance.hashCode());
        result = result * 59 + (this.deletionPolicy == null ? 43 : this.deletionPolicy.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.crashRecovery == null ? 43 : this.crashRecovery.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="mysqlVersion")
        private String mysqlVersion;
        @JsonProperty(value="adminUsername")
        private String adminUsername;
        @JsonProperty(value="backupPolicy")
        private BackupPolicy backupPolicy;
        @JsonProperty(value="configurationId")
        private String configurationId;
        @JsonProperty(value="dataStorageSizeInGBs")
        private Integer dataStorageSizeInGBs;
        @JsonProperty(value="hostnameLabel")
        private String hostnameLabel;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="portX")
        private Integer portX;
        @JsonProperty(value="isHighlyAvailable")
        private Boolean isHighlyAvailable;
        @JsonProperty(value="endpoints")
        private List<DbSystemEndpoint> endpoints;
        @JsonProperty(value="maintenance")
        private MaintenanceDetails maintenance;
        @JsonProperty(value="deletionPolicy")
        private DeletionPolicyDetails deletionPolicy;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="crashRecovery")
        private CrashRecoveryStatus crashRecovery;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder mysqlVersion(String mysqlVersion) {
            this.mysqlVersion = mysqlVersion;
            this.__explicitlySet__.add("mysqlVersion");
            return this;
        }

        public Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            this.__explicitlySet__.add("adminUsername");
            return this;
        }

        public Builder backupPolicy(BackupPolicy backupPolicy) {
            this.backupPolicy = backupPolicy;
            this.__explicitlySet__.add("backupPolicy");
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            this.__explicitlySet__.add("configurationId");
            return this;
        }

        public Builder dataStorageSizeInGBs(Integer dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
            this.__explicitlySet__.add("dataStorageSizeInGBs");
            return this;
        }

        public Builder hostnameLabel(String hostnameLabel) {
            this.hostnameLabel = hostnameLabel;
            this.__explicitlySet__.add("hostnameLabel");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder portX(Integer portX) {
            this.portX = portX;
            this.__explicitlySet__.add("portX");
            return this;
        }

        public Builder isHighlyAvailable(Boolean isHighlyAvailable) {
            this.isHighlyAvailable = isHighlyAvailable;
            this.__explicitlySet__.add("isHighlyAvailable");
            return this;
        }

        public Builder endpoints(List<DbSystemEndpoint> endpoints) {
            this.endpoints = endpoints;
            this.__explicitlySet__.add("endpoints");
            return this;
        }

        public Builder maintenance(MaintenanceDetails maintenance) {
            this.maintenance = maintenance;
            this.__explicitlySet__.add("maintenance");
            return this;
        }

        public Builder deletionPolicy(DeletionPolicyDetails deletionPolicy) {
            this.deletionPolicy = deletionPolicy;
            this.__explicitlySet__.add("deletionPolicy");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder crashRecovery(CrashRecoveryStatus crashRecovery) {
            this.crashRecovery = crashRecovery;
            this.__explicitlySet__.add("crashRecovery");
            return this;
        }

        public DbSystemSnapshot build() {
            DbSystemSnapshot model = new DbSystemSnapshot(this.id, this.displayName, this.description, this.compartmentId, this.subnetId, this.availabilityDomain, this.faultDomain, this.shapeName, this.mysqlVersion, this.adminUsername, this.backupPolicy, this.configurationId, this.dataStorageSizeInGBs, this.hostnameLabel, this.ipAddress, this.port, this.portX, this.isHighlyAvailable, this.endpoints, this.maintenance, this.deletionPolicy, this.freeformTags, this.definedTags, this.crashRecovery);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystemSnapshot model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("mysqlVersion")) {
                this.mysqlVersion(model.getMysqlVersion());
            }
            if (model.wasPropertyExplicitlySet("adminUsername")) {
                this.adminUsername(model.getAdminUsername());
            }
            if (model.wasPropertyExplicitlySet("backupPolicy")) {
                this.backupPolicy(model.getBackupPolicy());
            }
            if (model.wasPropertyExplicitlySet("configurationId")) {
                this.configurationId(model.getConfigurationId());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeInGBs")) {
                this.dataStorageSizeInGBs(model.getDataStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("hostnameLabel")) {
                this.hostnameLabel(model.getHostnameLabel());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("portX")) {
                this.portX(model.getPortX());
            }
            if (model.wasPropertyExplicitlySet("isHighlyAvailable")) {
                this.isHighlyAvailable(model.getIsHighlyAvailable());
            }
            if (model.wasPropertyExplicitlySet("endpoints")) {
                this.endpoints(model.getEndpoints());
            }
            if (model.wasPropertyExplicitlySet("maintenance")) {
                this.maintenance(model.getMaintenance());
            }
            if (model.wasPropertyExplicitlySet("deletionPolicy")) {
                this.deletionPolicy(model.getDeletionPolicy());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("crashRecovery")) {
                this.crashRecovery(model.getCrashRecovery());
            }
            return this;
        }
    }
}

